/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyTXXX
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyTXXX object.
     */
    public FrameBodyTXXX() {
        //        this.setObject("Text Encoding", new Byte((byte) 0));
        //        this.setObject("Description", "");
        //        this.setObject("Text", "");
    }

    /**
     * Creates a new FrameBodyTXXX object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param text DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyTXXX(byte textEncoding, String description, String text,
                         boolean is6ByteHeader) {
        this.setObject("Text Encoding",
                       new Byte(textEncoding));
        this.setObject("Description", description);
        this.setObject("Text", text);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyTXXX object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyTXXX(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getBriefDescription() {
        return this.getText();
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void setDescription(String description) {
        setObject("Description", description);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return (String) getObject("Description");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "TXXX" + ((char) 0) + getDescription();
    }

    /**
     * DOCUMENT ME!
     *
     * @param text DOCUMENT ME!
     */
    public void setText(String text) {
        setObject("Text", text);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getText() {
        return (String) getObject("Text");
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap("Text Encoding", 1));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectStringSizeTerminated("Text"));
    }
}