// Xbox Linux XBE Bootloader
//
//  Copyright (C) 2002 Michael Steil & anonymous
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// The latest version of the GPL can be retrieved at:
// http://www.gnu.org/licenses/gpl.html .
//
// Xbox is a trademark or registered trademark of Microsoft Corporation.
// No relationship between the author(s) and Microsoft Corporation exists or is
// implied.

#include "xbox.h"

.code32

.text
// This is a minimal XBE header. It's not complete, i.e. software that wants
// to decode the header, such as "xbedump" (or probably Microsoft's certification
// tools) are likely to fail, but it is a valid header for the Xbox kernel.
#define BASE_ADDRESS 0x10000
#define FILE_SIZE (0x4000+0x44000)
header_start:
  .ascii "XBEH"

// digital signature
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

  .long BASE_ADDRESS                    // base address
  .long headers_end - header_start      // size of headers
  .long FILE_SIZE+1024                  // size of image
  .long header_end - header_start       // size of image header
  .long 0                               // time date stamp                 *unimportant*
  .long certificate                     // certificate address
  .long 1                               // number of section headers
  .long section_headers                 // section headers address
  .long 0                               // initialization flags
  .long 0x11100 ^ 0xA8FC57AB            // entry point address XOR key **GAS ISSUE: "entry" won't work**
  .long 0x18000                         // thread local storage address
  .long 0                               // size of stack commit (PE copy)  *unimportant*
  .long 0                               // size of heap reserve (PE copy)  *unimportant*
  .long 0                               // size of heap commit (PE copy)   *unimportant*
  .long 0                               // original base address (PE copy) *unimportant*
  .long 0                               // original size of image (PE copy)*unimportant*
  .long 0                               // original checksum (PE copy)     *unimportant*
  .long 0                               // original time stamp (PE copy)   *unimportant*
  .long normalname			// debug path name address         *unimportant*
  .long normalname			// debug file name address         *unimportant*
  .long unicodename			// debug unicode file name address *unimportant*
  .long 0x11000 ^ 0x5B6D40B6            // kernel image thunk address XOR key **GAS ISSUE: see above**
  .long 0                               // non-kernel import directory address
  .long 0                               // number of library versions      *unimportant*
  .long 0                               // library versions address        *unimportant*
  .long 0                               // kernel library version address  *unimportant*
  .long 0                               // XAPI library address            *unimportant*
  .long logo                            // logo bitmap address
  .long logo_end-logo                   // logo bitmap size
header_end:

certificate:
  .long certificate_end - certificate   // size of certificate
  .long 0                               // time date stamp                 *unimportant*
  .long 0                               // title id                        *unimportant?*

  // title name (unicode string, 40 chars) *unimportant, but beautiful*
unicodename:
  .word 'P','h','o','e','n','i','x',' ','B','i','o','s',' ','L','o','a','d','e','r',0
normalname:
  .word 0,0,0,0,0,0,0,0,0,0
  .word 0,0,0,0,0,0,0,0,0,0

  // alternate title ids
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  
  .long 0xC00003FF   // allowed media types: HD or any CD/DVD; no panic of HDD unlocked; don't reboot on eject
  .long 0x80000007   // game regions: all; don't delete eepromkey
  .long -1  // game ratings
  .long 0   // disk number
  .long 0   // version

  // LAN key
  .long 0,0,0,0

  // signature key
  .long 0,0,0,0

  // 16 title alternate signature keys
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
certificate_end:

section_headers:
//  .long 0x16            // flags: RO_HEAD_PAGE, EXECUTABLE, PRELOAD
  .long 0x07            // flags: WRITABLE, EXECUTABLE, PRELOAD
  .long section_1_start // virtual address
  .long FILE_SIZE       // virtual size
  .long 0x1000          // file pointer to raw data
  .long FILE_SIZE       // size of raw data
  .long section_name    // address of section name
  .long 0               // unknown
  .long rc1             // head shared page reference count address *not NULL important*
  .long rc2             // tail shared page reference count address *not NULL important*

  // unknown
  .byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  .byte 0,0,0,0

section_headers_end:

rc1:
  .word 0
rc2:
  .word 0
section_name:
  .byte '.','t','e','x','t',0

.align 4
logo:
// "Linux"
.byte 0x52, 0x00, 0x13, 0x73, 0xB3, 0xF3, 0xF5, 0xE3
.byte 0xD3, 0xE3, 0x63, 0x03, 0x03, 0x03, 0x03, 0x07
.byte 0x03, 0x03, 0x13, 0x43, 0x33, 0x13, 0x03, 0x96
.byte 0x00, 0x9A, 0x00, 0x03, 0x03, 0x13, 0x33, 0xB3
.byte 0xF3, 0xF3, 0xF3, 0x93, 0x43, 0x23, 0x13, 0x03
.byte 0x03, 0x09, 0x03, 0x03, 0x73, 0x93, 0x83, 0x33
.byte 0x13, 0x03, 0x92, 0x00, 0x9A, 0x00, 0x03, 0x03
.byte 0x03, 0x23, 0x63, 0xF5, 0xE3, 0x73, 0x43, 0x23
.byte 0x13, 0x03, 0x03, 0x09, 0x03, 0x03, 0x73, 0x93
.byte 0x83, 0x33, 0x13, 0x03, 0x03, 0x09, 0x03, 0x05
.byte 0x09, 0x0B, 0x05, 0x03, 0x03, 0x05, 0x05, 0x07
.byte 0x03, 0x0B, 0x05, 0x9A, 0x00, 0x03, 0x03, 0x03
.byte 0x13, 0x63, 0xF5, 0xE3, 0x73, 0x43, 0x23, 0x03
.byte 0x03, 0x0B, 0x03, 0x13, 0x33, 0x53, 0x53, 0x33
.byte 0x13, 0x03, 0x03, 0x05, 0x03, 0x03, 0x05, 0x03
.byte 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03
.byte 0x03, 0x03, 0x03, 0x03, 0x03, 0x05, 0x03, 0x03
.byte 0x03, 0x03, 0x05, 0x03, 0x03, 0x05, 0x03, 0x03
.byte 0x03, 0x9A, 0x00, 0x03, 0x03, 0x03, 0x13, 0x53
.byte 0xF5, 0xD3, 0x73, 0x33, 0x13, 0x03, 0x05, 0x03
.byte 0x05, 0x03, 0x03, 0x23, 0x33, 0x33, 0x33, 0x23
.byte 0x23, 0x23, 0x23, 0x35, 0x23, 0x33, 0x33, 0x33
.byte 0x23, 0x05, 0x03, 0x13, 0x35, 0x33, 0x23, 0x13
.byte 0x25, 0x23, 0x33, 0x23, 0x13, 0x13, 0x33, 0x33
.byte 0x35, 0x33, 0x23, 0x23, 0x33, 0x33, 0x13, 0x03
.byte 0x03, 0x9A, 0x00, 0x03, 0x03, 0x03, 0x03, 0x53
.byte 0xF5, 0xD3, 0x73, 0x33, 0x13, 0x03, 0x03, 0x03
.byte 0x05, 0x03, 0x03, 0x53, 0x83, 0x73, 0x43, 0x23
.byte 0x13, 0x63, 0x93, 0xD3, 0xF3, 0xE3, 0xB3, 0xB3
.byte 0xA3, 0xE3, 0xA3, 0x43, 0x13, 0x23, 0x93, 0xF3
.byte 0xE3, 0xF3, 0x83, 0x43, 0x83, 0x93, 0xD3, 0xF3
.byte 0x93, 0x13, 0x33, 0xB3, 0xF7, 0xB3, 0x43, 0xA3
.byte 0xF3, 0xE3, 0x53, 0x13, 0x03, 0x9A, 0x00, 0x03
.byte 0x03, 0x03, 0x03, 0x53, 0xF5, 0xD3, 0x63, 0x33
.byte 0x13, 0x03, 0x05, 0x03, 0x03, 0x03, 0x63, 0x83
.byte 0x53, 0x93, 0x83, 0x33, 0x23, 0x13, 0x23, 0xD3
.byte 0xF3, 0xF3, 0xD3, 0x53, 0x33, 0xC3, 0xF3, 0xD3
.byte 0x43, 0x33, 0x53, 0x93, 0xF3, 0xF3, 0xA3, 0x43
.byte 0x23, 0x73, 0xF5, 0xC3, 0x33, 0x23, 0x23, 0xA3
.byte 0xF5, 0x83, 0x43, 0x73, 0xD3, 0x63, 0x23, 0x13
.byte 0x03, 0x9A, 0x00, 0x03, 0x03, 0x03, 0x03, 0x53
.byte 0xF5, 0xD3, 0x63, 0x33, 0x13, 0x03, 0x03, 0x03
.byte 0x05, 0x13, 0x83, 0x43, 0x63, 0x93, 0x83, 0x53
.byte 0x33, 0x13, 0x33, 0xC3, 0xF3, 0xF3, 0x83, 0x53
.byte 0x33, 0xA3, 0xF3, 0xF3, 0x73, 0x33, 0x23, 0x43
.byte 0xE3, 0xF3, 0xB3, 0x53, 0x33, 0x83, 0xF5, 0xC3
.byte 0x53, 0x33, 0x23, 0x43, 0xD3, 0xF3, 0xE3, 0x83
.byte 0xD3, 0x83, 0x33, 0x23, 0x13, 0x03, 0x9A, 0x00
.byte 0x03, 0x03, 0x03, 0x03, 0x53, 0xF5, 0xD3, 0x63
.byte 0x33, 0x13, 0x03, 0x05, 0x03, 0x73, 0x33, 0x43
.byte 0x33, 0x73, 0x93, 0x83, 0x53, 0x33, 0x13, 0x23
.byte 0xB3, 0xF3, 0xF3, 0x83, 0x53, 0x33, 0x93, 0xF3
.byte 0xF3, 0x83, 0x33, 0x23, 0x43, 0xF3, 0xF3, 0xB3
.byte 0x53, 0x33, 0x93, 0xF5, 0xC3, 0x53, 0x33, 0x13
.byte 0x23, 0x73, 0xF5, 0xE3, 0xC3, 0x53, 0x33, 0x23
.byte 0x03, 0x03, 0x9A, 0x00, 0x03, 0x03, 0x03, 0x13
.byte 0x53, 0xF5, 0xD3, 0x63, 0x33, 0x13, 0x03, 0x03
.byte 0x03, 0x03, 0xA3, 0x53, 0x23, 0x53, 0x93, 0x93
.byte 0x83, 0x53, 0x33, 0x13, 0x23, 0xC3, 0xF3, 0xE3
.byte 0x83, 0x43, 0x23, 0x93, 0xF3, 0xF3, 0x83, 0x43
.byte 0x23, 0x43, 0xF5, 0xA3, 0x53, 0x33, 0x73, 0xF5
.byte 0xC3, 0x53, 0x33, 0x13, 0x13, 0x23, 0xB3, 0xF3
.byte 0xF3, 0xA3, 0x53, 0x33, 0x13, 0x03, 0x03, 0x9A
.byte 0x00, 0x03, 0x03, 0x03, 0x03, 0x53, 0xF5, 0xD3
.byte 0x73, 0x33, 0x13, 0x03, 0x03, 0x03, 0x03, 0xB3
.byte 0x63, 0x33, 0x63, 0x93, 0x93, 0x73, 0x53, 0x33
.byte 0x13, 0x23, 0xC3, 0xF3, 0xE3, 0x73, 0x43, 0x23
.byte 0x93, 0xF3, 0xF3, 0x83, 0x43, 0x23, 0x43, 0xF5
.byte 0xA3, 0x53, 0x33, 0x73, 0xF3, 0xF3, 0xC3, 0x53
.byte 0x33, 0x13, 0x13, 0x13, 0x73, 0xF3, 0xF3, 0xE3
.byte 0x73, 0x33, 0x13, 0x03, 0x03, 0x9A, 0x00, 0x03
.byte 0x03, 0x03, 0x03, 0x53, 0xF5, 0xD3, 0x63, 0x33
.byte 0x13, 0x03, 0x03, 0x03, 0x33, 0xE3, 0x63, 0x43
.byte 0x83, 0x93, 0x83, 0x73, 0x73, 0x53, 0x13, 0x23
.byte 0xC3, 0xF3, 0xD3, 0x73, 0x33, 0x13, 0x93, 0xF3
.byte 0xF3, 0x73, 0x43, 0x23, 0x43, 0xF5, 0xA3, 0x53
.byte 0x23, 0x73, 0xF5, 0xC3, 0x53, 0x33, 0x13, 0x03
.byte 0x03, 0x83, 0xC3, 0xF3, 0xF3, 0xC3, 0x43, 0x23
.byte 0x03, 0x03, 0x9A, 0x00, 0x05, 0x03, 0x03, 0x53
.byte 0xF5, 0xE3, 0x73, 0x33, 0x13, 0x03, 0x05, 0x83
.byte 0xF3, 0x73, 0x53, 0x93, 0x93, 0x83, 0x73, 0x83
.byte 0x43, 0x23, 0x33, 0xC3, 0xF3, 0xD3, 0x73, 0x43
.byte 0x23, 0x93, 0xF3, 0xF3, 0x73, 0x43, 0x23, 0x43
.byte 0xF5, 0xA3, 0x53, 0x33, 0x83, 0xF5, 0xC3, 0x53
.byte 0x33, 0x13, 0x03, 0x63, 0xE3, 0x73, 0xB3, 0xF5
.byte 0x83, 0x33, 0x13, 0x03, 0x9A, 0x00, 0x05, 0x03
.byte 0x03, 0x63, 0xF5, 0xF3, 0x73, 0x33, 0x13, 0x03
.byte 0x23, 0x73, 0xF3, 0xF3, 0x73, 0x63, 0x93, 0x93
.byte 0x83, 0x83, 0x73, 0x33, 0x23, 0x23, 0xD3, 0xF3
.byte 0xD3, 0x63, 0x33, 0x13, 0x93, 0xF3, 0xF3, 0x63
.byte 0x33, 0x23, 0x43, 0xF3, 0xF3, 0xB3, 0x53, 0x43
.byte 0xA3, 0xF5, 0xC3, 0x53, 0x33, 0x03, 0x23, 0xB3
.byte 0x83, 0x43, 0x63, 0xD3, 0xF3, 0xE3, 0x53, 0x23
.byte 0x13, 0x9E, 0x00, 0x13, 0x63, 0x83, 0xC3, 0xF3
.byte 0xF5, 0xA3, 0x83, 0x73, 0x73, 0xC3, 0xF7, 0x83
.byte 0x53, 0x83, 0x93, 0x93, 0x83, 0x53, 0x33, 0x53
.byte 0x83, 0xF5, 0xE3, 0xA3, 0x53, 0x63, 0xD3, 0xF3
.byte 0xF3, 0xA3, 0x63, 0x23, 0x23, 0x93, 0xF3, 0xF3
.byte 0xB3, 0x93, 0xB3, 0xF3, 0xF3, 0xE3, 0x83, 0x53
.byte 0x73, 0xA3, 0xF3, 0xC3, 0x63, 0x73, 0xB3, 0xF5
.byte 0xC3, 0x63, 0x23, 0x9E, 0x00, 0x13, 0x63, 0x75
.byte 0x83, 0x93, 0x83, 0x83, 0x73, 0x63, 0x73, 0x73
.byte 0x83, 0x83, 0x93, 0x63, 0x43, 0x43, 0x63, 0x63
.byte 0x53, 0x33, 0x23, 0x43, 0x63, 0x73, 0x83, 0x93
.byte 0x83, 0x53, 0x63, 0x83, 0x83, 0x93, 0x93, 0x53
.byte 0x23, 0x13, 0x33, 0x73, 0xA3, 0xA3, 0x73, 0x43
.byte 0x83, 0xA3, 0x93, 0x73, 0x43, 0x73, 0x73, 0x73
.byte 0x93, 0x53, 0x53, 0x73, 0x83, 0x93, 0x93, 0x63
.byte 0x23, 0x9A, 0x00, 0x03, 0x03, 0x03, 0x13, 0x23
.byte 0x33, 0x43, 0x43, 0x33, 0x23, 0x13, 0x13, 0x23
.byte 0x23, 0x35, 0x33, 0x23, 0x23, 0x23, 0x33, 0x33
.byte 0x23, 0x13, 0x13, 0x13, 0x23, 0x33, 0x33, 0x33
.byte 0x23, 0x13, 0x23, 0x33, 0x33, 0x33, 0x23, 0x13
.byte 0x13, 0x13, 0x23, 0x33, 0x33, 0x33, 0x35, 0x45
.byte 0x33, 0x23, 0x13, 0x13, 0x23, 0x23, 0x23, 0x23
.byte 0x23, 0x33, 0x33, 0x33, 0x23, 0x13, 0x4E, 0x00
logo_end:

.align 4
headers_end:


.org 0x1000
section_1_start:		// this should be 0x11000
// kernel thunk table
#include "import.tbl"
	.long	0		// end of table

.org 0x1080
	.long	0		// VMLinuz Image Position
	.long	0		// VMLinuz Image Size
	.long	0		// VMLinuz Image Size Kernel Paramter
	.long	0		// Initrd Image Position
	.long	0		// Initrd Image Size
	.long	0		// Linuxboot.cfg Position
	.long	0		// Linuxboot.cfg Size
	
.globl _start
.org 0x1100
entry:				// this should be 0x11100
.intel_syntax noprefix
_start:

	jmp boot

.org 0x2000
