/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import java.util.ArrayList;
import java.util.Iterator;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectGroupRepeated
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    private ArrayList objectList;

    /** DOCUMENT ME! */
    private ArrayList propertyList;

    /**
     * Creates a new ObjectGroupRepeated object.
     *
     * @param identifier DOCUMENT ME!
     */
    public ObjectGroupRepeated(String identifier) {
        this.identifier   = identifier;
        this.propertyList = new ArrayList();
        this.objectList   = new ArrayList();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ArrayList getObjectList() {
        return this.objectList;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ArrayList getPropertyList() {
        return this.propertyList;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int               size     = 0;
        AbstractMP3Object object;
        Iterator          iterator = objectList.listIterator();

        while (iterator.hasNext()) {
            object = (AbstractMP3Object) iterator.next();
            size += object.getSize();
        }

        return size;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     */
    public void addObject(AbstractMP3Object obj) {
        objectList.add(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     */
    public void addProperty(AbstractMP3Object obj) {
        propertyList.add(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectGroupRepeated) == false) {
            return false;
        }

        ObjectGroupRepeated object = (ObjectGroupRepeated) obj;

        if (this.objectList.equals(object.objectList) == false) {
            return false;
        }

        if (this.propertyList.equals(object.propertyList) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param arr DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readByteArray(byte[] arr, int offset) {
        AbstractMP3Object object;
        Class             className;
        Iterator          iterator;

        if (propertyList.size() > 0) {
            while (offset < arr.length) {
                iterator = propertyList.listIterator();

                while (iterator.hasNext()) {
                    className = iterator.next()
                                .getClass();

                    try {
                        object = (AbstractMP3Object) className.newInstance();
                        objectList.add(object);
                        object.readByteArray(arr, offset);
                        offset += object.getSize();
                    } catch (IllegalAccessException ex) {
                        ex.printStackTrace();

                        // do nothing, just skip this one
                    } catch (InstantiationException ex) {
                        ex.printStackTrace();

                        // do nothing, just skip this one
                    }
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String            str      = "";
        AbstractMP3Object object;
        Iterator          iterator = objectList.listIterator();

        while (iterator.hasNext()) {
            object = (AbstractMP3Object) iterator.next();
            str += (object.toString() + "\n");
        }

        return str;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public byte[] writeByteArray() {
        AbstractMP3Object object;
        int               offset      = 0;
        byte[]            totalArray  = new byte[this.getSize()];
        byte[]            objectArray;
        Iterator          iterator    = objectList.listIterator();

        while (iterator.hasNext()) {
            object      = (AbstractMP3Object) iterator.next();
            objectArray = object.writeByteArray();
            System.arraycopy(objectArray, 0, totalArray, 0, totalArray.length);
        }

        return totalArray;
    }
}