/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import org.farng.mp3.TagUtilities;

/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectStringFixedLength extends AbstractMP3Object {
	/** DOCUMENT ME! */
	int length = 0;

	/**
	 * Creates a new ObjectStringFixedLength object.
	 *
	 * @param identifier DOCUMENT ME!
	 * @param length DOCUMENT ME!
	 */
	public ObjectStringFixedLength(String identifier, int length) {
		this.identifier = identifier;
		this.length = length;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param size DOCUMENT ME!
	 */
	public void setLength(int size) {
		this.length = size;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public int getLength() {
		return length;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public int getSize() {
		return length;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param obj DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public boolean equals(Object obj) {
		if ((obj instanceof ObjectStringFixedLength) == false) {
			return false;
		}

		ObjectStringFixedLength object = (ObjectStringFixedLength) obj;

		if (this.length != object.length) {
			return false;
		}

		return super.equals(obj);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param str DOCUMENT ME!
	 * @param offset DOCUMENT ME!
	 */
	public void readString(String str, int offset) {
		if (length + offset > str.length())
			this.value = "";
		else
			this.value = str.substring(offset, length + offset);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String toString() {
		return writeString();
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String writeString() {
		String str = "";

		if (value != null) {
			int vlength = ((String) value).length();

			if (vlength > this.length) {
				str = ((String) value).substring(0, this.length);
			} else if (vlength == this.length) {
				str = (String) value;
			} else {
				str =
					TagUtilities.padString(
						(String) value,
						this.length,
						' ',
						false);
			}
		}

		return str;
	}
}