/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import java.util.Arrays;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractMP3Object {
    /** DOCUMENT ME! */
    protected Object value = null;

    /** DOCUMENT ME! */
    protected String identifier = "";

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return identifier;
    }

    /**
     * DOCUMENT ME!
     *
     * @param value DOCUMENT ME!
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object getValue() {
        return value;
    }

    /**
     * DOCUMENT ME!
     *
     * @param arr DOCUMENT ME!
     */
    final public void readByteArray(byte[] arr) {
        readByteArray(arr, 0);
    }

    /**
     * DOCUMENT ME!
     *
     * @param str DOCUMENT ME!
     */
    final public void readString(String str) {
        readString(str, 0);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public int getSize();

    /**
     * DOCUMENT ME!
     *
     * @param arr DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readByteArray(byte[] arr, int offset) {
        readString(new String(arr),
                   offset);
    }

    /**
     * DOCUMENT ME!
     *
     * @param str DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readString(String str, int offset) {
        readByteArray(str.substring(offset).getBytes(),
                      0);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public String toString();

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof AbstractMP3Object) == false) {
            return false;
        }

        AbstractMP3Object object = (AbstractMP3Object) obj;

        if (this.identifier.equals(object.identifier) == false) {
            return false;
        }

        if ((this.value == null) && (object.value == null)) {
            return true;
        } else if ((this.value == null) || (object.value == null)) {
            return false;
        }

        // boolean[]
        if (this.value instanceof boolean[] &&
                object.value instanceof boolean[]) {
            if (Arrays.equals((boolean[]) this.value, (boolean[]) object.value) == false) {
                return false;
            }

            // byte[]
        } else if (this.value instanceof byte[] &&
                       object.value instanceof byte[]) {
            if (Arrays.equals((byte[]) this.value, (byte[]) object.value) == false) {
                return false;
            }

            // char[]
        } else if (this.value instanceof char[] &&
                       object.value instanceof char[]) {
            if (Arrays.equals((char[]) this.value, (char[]) object.value) == false) {
                return false;
            }

            // double[]
        } else if (this.value instanceof double[] &&
                       object.value instanceof double[]) {
            if (Arrays.equals((double[]) this.value, (double[]) object.value) == false) {
                return false;
            }

            // float[]
        } else if (this.value instanceof float[] &&
                       object.value instanceof float[]) {
            if (Arrays.equals((float[]) this.value, (float[]) object.value) == false) {
                return false;
            }

            // int[]
        } else if (this.value instanceof int[] &&
                       object.value instanceof int[]) {
            if (Arrays.equals((int[]) this.value, (int[]) object.value) == false) {
                return false;
            }

            // long[]
        } else if (this.value instanceof long[] &&
                       object.value instanceof long[]) {
            if (Arrays.equals((long[]) this.value, (long[]) object.value) == false) {
                return false;
            }

            // Object[]
        } else if (this.value instanceof Object[] &&
                       object.value instanceof Object[]) {
            if (Arrays.equals((Object[]) this.value, (Object[]) object.value) == false) {
                return false;
            }

            // short[]
        } else if (this.value instanceof short[] &&
                       object.value instanceof short[]) {
            if (Arrays.equals((short[]) this.value, (short[]) object.value) == false) {
                return false;
            }
        } else if (this.value.equals(object.value) == false) {
            return false;
        }

        return true;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public byte[] writeByteArray() {
        return writeString()
               .getBytes();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String writeString() {
        return new String(writeByteArray());
    }
}