/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.lyrics3;

import java.io.RandomAccessFile;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * DOCUMENT ME!
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FieldBodyEAR
    extends AbstractLyrics3v2FieldBody {
    /**
     * Creates a new FieldBodyEAR object.
     */
    public FieldBodyEAR() {
        //        this.setObject("Artist", "");
    }

    /**
     * Creates a new FieldBodyEAR object.
     *
     * @param artist DOCUMENT ME!
     */
    public FieldBodyEAR(String artist) {
        this.setObject("Artist", artist);
    }

    /**
     * Creates a new FieldBodyEAR object.
     *
     * @param file DOCUMENT ME!
     *
     * @throws InvalidTagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     */
    public FieldBodyEAR(RandomAccessFile file)
                 throws InvalidTagException, java.io.IOException {
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @param artist DOCUMENT ME!
     */
    public void setArtist(String artist) {
        setObject("Artist", artist);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getArtist() {
        return (String) getObject("Artist");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "EAR";
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectStringSizeTerminated("Artist"));
    }
}