/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-18 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-18 at 22:20

using System;

namespace Xbgm.FTP
{
	public class Configuration
	{
		private string ip;
		private Int32 port;
		private string dir;
		private string user;
		private string passwd;
			
		public Configuration()
		{
			#if (DEBUG)
				Console.WriteLine("Loading default configuration.");
			#endif
		}
		
		public Configuration(string	ip, Int32 port, string dir, string user, string	passwd)
		{
			this.ip = ip;
			this.port = port;
			this.dir = dir;
			this.user = user;
			this.passwd = passwd;
		}
		
		// Getters
		public string getIp() { return this.ip; }
		public Int32 getPort() { return this.port; }
		public string getDirectory() { return this.dir;	}
		public string getUser() { return this.user;	}
		public string getPassword()	{ return this.passwd; }
		
		// Setters
		public void set(Xbgm.FTP.Configuration ftpinfo)
		{
			this.ip = ftpinfo.getIp();
			this.port = ftpinfo.getPort();
			this.dir = ftpinfo.getDirectory();
			this.user = ftpinfo.getUser();
			this.passwd = ftpinfo.getPassword();
		}
		
		public void setIp(string ip) { this.ip = ip; }
		public void setPort(Int32 port) { this.port = port; }
		public void setDirectory(string dir) { this.dir = dir; }
		public void setUser(string user) { this.user = user; }
		public void setPassword(string passwd) { this.passwd = passwd; }
		
		override public string ToString()
		{
			return this.ip + "\n" + this.port.ToString() + "\n" + this.dir + "\n" +
					this.user + "\n" + this.passwd;
		}
	}
}
