/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-19 at 21:00

using Gtk;
using Gdk;
using GtkSharp;

namespace Xbgm.Gui
{
	public class Popup : Xbgm.Core.Messages
	{
		private Gtk.Window parent; 

		// Default constructor
		public Popup(){}
		
		/// <summary>
		/// Basic dialogs: Error, Info, Question.
		/// The parent can be set to null. 
		/// </summary>
		public Popup(Gtk.Window parent)
		{
			 this.parent = parent; 
		}
		
		public void Error(string msg)
		{
			// This make a Warning on Win XP If using the XP theme.
			// works fine on linux on Win32 and with the win classic theme.
			MessageDialog md = new MessageDialog (this.parent, // Root Window 
				                              DialogFlags.DestroyWithParent, 
				                              MessageType.Error, 
				                              ButtonsType.Ok, 
				                              msg);
			md.Modal = true;
			md.WindowPosition = WindowPosition.CenterOnParent;
			md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
		}
	
		public void Info(string msg)
		{
			MessageDialog md = new MessageDialog (this.parent, // Root Window 
				                              DialogFlags.DestroyWithParent, 
				                              MessageType.Info, 
				                              ButtonsType.Ok, 
				                              msg);
			md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
		}
		
		public bool Question(string msg)
		{
			MessageDialog md = new MessageDialog (this.parent, // Root Window 
				                              DialogFlags.DestroyWithParent, 
				                              MessageType.Question,
				                              ButtonsType.YesNo, 
				                              msg);
			int response = md.Run ();
			
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
			
			return (response == (int)ResponseType.Yes) ? true : false;
		}
	}
}
