/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.2  2004/08/14 KaYa
/// Add thread support
///
/// Revision 0.1  2004/08/10 KaYa
/// first release
///
/// </summary>

namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using Gtk;
using Gdk;
using GtkSharp;
using System.Threading;
using Xbgm.Xiso;
	
/// <summary>
/// Description of ProgressDialog.	
/// Show stat when extracting iso.
/// </summary>
public class ProgressDialog
{
	Dialog dialog;
	Label labelFilename = null;
	Label labelISOname = null;
	Label labelFileremain = null;
	ProgressBar Progress = null;
	ProgressBar ISOProgress = null;
	
	uint	IDtimeout = 0;
	
	public struct Xiso
	{
		public string xisofilename;
		public double totisofile;
		public double totsizefile;
		public string ISOFileName;
		public string xboxdir;
		public string gamedir;
		public bool	  hdd;
		public struct FTP
		{
			public string		IP;
			public Int32		port;
			public string		dir;
			public string		user;
			public string		pass;
		}
		public FTP FTPiso;
	}
	public Xiso xisostruct;
	
	private XisoExtractClass iso = null;
	
	public void UpdateXiso(string xisofile, string xboxdir, string gamedir, double maxfiles, Int64 sizefiles, Xbgm.Gui.MyWindow.FTP FTPinfo, bool extractto)
	{
		xisostruct.xisofilename = xisofile;
		xisostruct.totisofile = maxfiles;
		xisostruct.totsizefile = sizefiles;
		xisostruct.ISOFileName = System.IO.Path.GetFileName(xisofile);
		xisostruct.xboxdir = xboxdir;
		xisostruct.gamedir = gamedir;
		xisostruct.hdd = extractto;
		xisostruct.FTPiso.IP = FTPinfo.IP;
		xisostruct.FTPiso.port = FTPinfo.port;
		xisostruct.FTPiso.dir = FTPinfo.dir;
		xisostruct.FTPiso.user = FTPinfo.user;
		xisostruct.FTPiso.pass = FTPinfo.pass;
		iso.Nbfiles = (int)maxfiles;
		iso.sendfile = 0;
		iso.totsendsize = 0;
		labelFilename.Text = "Preparing tranfert...";
	}
	
	public ProgressDialog()
	{
		dialog = new Dialog ();
		dialog.Title = "Progress";
		dialog.Modal = true;
		dialog.DestroyWithParent = true;
		dialog.TypeHint = WindowTypeHint.Dialog;
		dialog.WindowPosition = WindowPosition.Center;
		dialog.Decorated = true;
		dialog.BorderWidth = 3;
		dialog.VBox.BorderWidth = 5;
		dialog.HasSeparator = false;

		Frame frame = new Frame ("Progress");
		//string image = Stock.DialogInfo;
		
		//Pixbuf pix = new Gdk.Pixbuf (null, "timeprogress.png");

		//HBox hbox = new HBox (false, 3);
		HBox hbox = new HBox (false, 2);
		hbox.BorderWidth = 5;
		//hbox.PackStart (new Gtk.Image (pix), true, true, 0);

		Table table = new Table (6, 3, false);
		hbox.PackStart (table);
		table.ColumnSpacing = 4;
		table.RowSpacing = 4;
		Label label = null;

		label = new Label ("File Progress:");
		table.Attach (label, 0, 1, 0, 1);
		
		Progress = new Gtk.ProgressBar();
		Progress.HeightRequest = 15;
		Progress.WidthRequest = 330;
		Progress.Fraction= 0.0;
		Progress.Text = "Waiting";
		table.Attach (Progress, 1, 2, 0, 1);

		label = new Label ("ISO Progress:");
		table.Attach (label, 0, 1, 1, 2);
		ISOProgress = new Gtk.ProgressBar();
		ISOProgress.HeightRequest = 15;
		ISOProgress.WidthRequest = 330;
		ISOProgress.Fraction= 0.0;
		ISOProgress.Text = "Waiting";
		table.Attach (ISOProgress, 1, 2, 1, 2);
		
		label = new Label ("Current ISO:");
		table.Attach (label, 0, 1, 2, 3);
		labelISOname = new Label ();
		labelISOname.Text = "ISO_name";
		table.Attach (labelISOname, 1, 2, 2, 3);			
		
		label = new Label ("Current File:");
		table.Attach (label, 0, 1, 3, 4);
		labelFilename = new Label ();
		labelFilename.Text = "File_name";
		table.Attach (labelFilename, 1, 2, 3, 4);
		
		label = new Label ("File Remaining:");
		table.Attach (label, 0, 1, 4, 5);
		labelFileremain = new Label ();
		labelFileremain.Text = "File_remaining";
		table.Attach (labelFileremain, 1, 2, 4, 5);

		frame.Add (hbox);

		dialog.VBox.PackStart (frame, true, true, 0);		
		
		Button button = null;
		button = new Button (Stock.Cancel);
		button.Clicked += new EventHandler (Dialog_Cancel);
		dialog.ActionArea.PackStart (button, true, true, 0);

		// Set a  1sec timout to update the GUI
		IDtimeout = Gtk.Timeout.Add((uint)(1000), new Gtk.Function(UpdateProgressBarTimeOut));
		dialog.ShowAll ();
		
		//Init xisothread class
		iso = new XisoExtractClass();
		//init isoinfo struct
		xisostruct = new Xiso();
	}
 
	public bool UpdateProgressBarTimeOut() //Unuse maybe in Next release
	{
		// ISO Name
		labelISOname.Text = xisostruct.ISOFileName;
		
		// Current file name label
		if (iso.currentfile != null)
			labelFilename.Text = iso.currentfile;
		
		// nb File  remaining
		labelFileremain.Text = (xisostruct.totisofile - iso.sendfile).ToString();
		
		// Current file progress bar
		if (iso.currentfile != null)
		{
			Progress.Fraction = ( iso.sendsize / iso.totsendsize);
			Progress.Text = String.Format ("{0}", (iso.sendsize/iso.totsendsize).ToString("#%"));
		}
		else
			Progress.Text = String.Format ("Preparing tranfert...");
		// Iso progress bar
		ISOProgress.Fraction = (iso.sendsizefile/xisostruct.totsizefile);
		ISOProgress.Text = String.Format ("{0}", (iso.sendsizefile/xisostruct.totsizefile).ToString("#.#%"));
		//Console.WriteLine("filesize: " + iso.sendsizefile + "=" + xisostruct.totsizefile);
		//Console.ReadLine();
		 while( Application.EventsPending() )
		   Application.RunIteration();
			
		return true;	// must return true from timeout to keep it active
	}

	void Dialog_Cancel (object o, EventArgs args) 
	{
		iso.docontinue = false;
		Gtk.Timeout.Remove(IDtimeout);
		dialog.Hide ();
	}

	public void Run ()
	{
		Thread t1 = new Thread(new ThreadStart(f1));
		t1.Start();
		dialog.Run();
		//t1.Join();
	}
	
	public void Close()
	{
		iso = null;
		dialog.Hide ();
		dialog.Destroy();
		System.GC.Collect();
	}
	
	void f1()
	{
		if (xisostruct.hdd == true)
			iso.hdd = true;
		//Console.WriteLine(xisostruct.xisofilename + "=" + xisostruct.xboxdir + "=" + xisostruct.gamedir + "=" + xisostruct.FTPiso.IP);
		iso.extractiso(xisostruct.xisofilename, xisostruct.xboxdir,
			               xisostruct.gamedir, 
			               xisostruct.FTPiso.IP, xisostruct.FTPiso.port, 
				           xisostruct.FTPiso.user, xisostruct.FTPiso.pass, 
				           xisostruct.FTPiso.dir);
		//iso.docontinue = false;
		//iso = null;
		Gtk.Timeout.Remove(IDtimeout);
		dialog.Hide ();	
	}
}
}
