/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

using System;
using System.IO;
using System.Text;
using System.Data;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using System.Threading;
using System.Diagnostics;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.InteropServices;
using Gtk;
using Gdk;
using GtkSharp;

using EnterpriseDT.Net.Ftp;
using ICSharpCode.SharpZipLib.Zip;
using Xbgm.Xiso;

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
namespace Xbgm.Gui
{
	
public class MyWindow : Gtk.Window {
		const string VERSION = "0.6";
		const string NAME = "XBGM#";

// That is bad i know but i need a full list of the game in memory.
 		string[]	liste;
// Info on the selected game. 4 string:  0: Name 1:xbe name 2: directory name 3: ID
		ArrayList	CurrentGame = null;
// Define if i use cache or not to show game list
		bool		cache = true;
// Xbox Media Center Full path + xbe
		string		XBMC = null;
// The FTP structure of a FTP connection
		public struct FTP
		{
			public string		IP;
			public Int32		port;
			public string		dir;
			public string		user;
			public string		pass;
		}
		public FTP FTPinfo;
	
		private XisoInfoClass iso = null;

// List of xbox action on FTP
		enum FtpXbox { ready, scan, rename, delete, launch, reboot, shutdown, xbmc, image, freespace};
		FtpXbox xboxAction;
		
		bool freespace = false;
		bool deletesave = false;
		
		public uint	IDtimeout = 0;
	//Notebook1
		private HPaned top;
		private Menu menu = null;
		private ListStore store = null;	
		private Gtk.TreeIter iter;
		private Gtk.TreeView tv;

		private Gtk.Image image;
		private Pixbuf pix;
	
		private Label labelIDresult;
		private Label labelSpaceresult;
		private Label labelSlackresult;
		//private Label labelAllFreespace;
		private Label labelAlltitlesResult;
		private Label labelAllfilesResult;
		private Label labelAllfoldersResult;
		private Label labelAllspaceResult;
		private Label labelAllslackResult;
		private Label labelAllsizeResult;
		private Label labelAllFreespaceResult;
		 
		private CheckButton DLicons;
	
	//Notebook2
		private ListStore store2 = null;
		private Gtk.TreeIter iter2;
		private Gtk.TreeView tv2;
		private Label labelR1;
		private Label labelR2;
		private Label labelR3;
		private Entry Entrygamexbe;
		private Entry Entrygamedir;
		private Entry Entryxboxdir;
	
		private Statusbar statusbar;

	/// <summary>
	/// Create the Main GUI
	/// </summary>
	public MyWindow () : base ("MyWindow")
	{
	 try{
			this.SetDefaultSize (840, 560);
			this.Title = NAME + " " + VERSION;
			this.DeleteEvent += new DeleteEventHandler (OnMyWindowDelete);
			this.BorderWidth = 2;
	 	
	 		// Set the app icon
	 		Gdk.Pixbuf Icon = new Gdk.Pixbuf(null, "xbgmicon.png");
			this.Icon = Icon;

			// 1 first split in line		
			VBox vbox = new VBox (false, 0); 
			this.Add (vbox);
	 	
			// Create the Top Toolbar.
			Toolbar Toptoolbar = CreateTopToolbar ();
			vbox.PackStart (Toptoolbar, false, false, 0);

//=================================================
// 				NoteBook 1
			#region NoteBook 1
			Notebook nb = new Notebook ();
	 		VBox vboxnb1 = new VBox (false, 0);
	 		nb.Add(vboxnb1);
	 		nb.SetTabLabelText(vboxnb1, "Manage Titles On Xbox");
	 		vbox.PackStart (nb, true, true, 0);
	 	
			// Create the Toolbar.
			Toolbar Gametoolbar = CreateGameToolbar ();
			vboxnb1.PackStart (Gametoolbar, false, false, 0);

			// Add Horizontal Frame
			top = new HPaned ();
			top.Position = 680;
			vboxnb1.PackStart (top, true, true, 0);
			top.BorderWidth = 0;
			
			// Add a scrolledWindows for the GameList
			ScrolledWindow sw = new ScrolledWindow ();
			top.Add1 (sw);
			
			// Create the treeview containing 6 string
			store = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string) );
	
			// sort by on name for column 0
			//store.SetSortColumnId(0, 0);
			tv = new TreeView (store);
			tv.HeadersVisible = true;
	 		// I don't know what that but why not?
			//tv.Reorderable = true;
	 		
	 		// Right Click 
	 		// Connect signals for mouse button press and popup menu
            tv.ButtonPressEvent += new ButtonPressEventHandler (OnTreeviewButtonPressEvent);
            tv.PopupMenu += new PopupMenuHandler (PopupMenuCb); 
	 	
			// Got left clickable
			// This crash if not using the mono1.0 command line on WIN32
			// Suppress the crash by catch exception but the GUi it is not fulle functional.
			tv.Selection.Changed += 
				new EventHandler(on_List_selection);
	 	
			// This is bad but if i don't it that way.
			// it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column = new TreeViewColumn ();
			CellRendererText text = new CellRendererText ();
			column.Title = "Title";
			column.Resizable = true;
			column.SortColumnId = 0;
	 		column.MinWidth = 100;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 0);
			tv.AppendColumn(column);

			// 2
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Size";
			column.Resizable = true;
			column.SortColumnId = 1;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 1);
			tv.AppendColumn(column);
			
			// 3 
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folder";
			column.Resizable = true;
	 		column.Reorderable = true;
			column.SortColumnId = 0;
			column.MinWidth = 200;
			// specified the size of the column Folder
			/*column.Sizing = TreeViewColumnSizing.Fixed;
			column.FixedWidth = 260;
			*/
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 2);
			tv.AppendColumn(column);
			
			// 4
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Files";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 3);
			tv.AppendColumn(column);
			
			// 5
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folders";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 4);
			tv.AppendColumn(column);

			// 6
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Region";
			column.Resizable = true;
			column.SortColumnId = 5;
			column.MaxWidth = 5;
	 		column.FixedWidth = 5;
	 		column.Sizing = TreeViewColumnSizing.Fixed;
			//column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 5);
			tv.AppendColumn(column);

			sw.Add(tv);
						
			// Split for the right view 			
			VBox vboxinside = new VBox (false, 0); 
			//vboxinside.Visible = true;
			vboxinside.Visible = false;
			top.Add2 (vboxinside);					
		
			// Now that is split 
			// Add the image view
			// Don't show image if check box not Active.
			// Old way to get image from file V0.1
			//pix = GetPixbufFromFile ("xbgm.png"); 
	 		// New way to get image from resource V0.2
	 		pix = new Gdk.Pixbuf (null, "xbgm.png");	
	        image = new Gtk.Image (pix);  // OK
	 	
			vboxinside.PackStart (image);
			
			// Add a frame with a label Title view
			Frame frame = new Frame (" Selected Title ");
			frame.BorderWidth = 4;
			vboxinside.PackStart (frame);

			Table table = new Table (3, 2, true);
	 		//table.SetColSpacing(1, 50);
	 		table.Homogeneous = true;
			frame.Add (table);

			Label labelID = new Label ("ID:");
			table.Attach (labelID, 0, 1, 0, 1);

			Label labelSpace = new Label ("Space:");
			table.Attach (labelSpace,0, 1, 0, 2);

			Label labelSlack = new Label ("Slack:");
			table.Attach (labelSlack, 0, 1, 0, 3);
		
			labelIDresult = new Label ("00000000");
			table.Attach (labelIDresult, 1, 2, 0, 1);
		
			labelSpaceresult = new Label ("nb Space");
			table.Attach (labelSpaceresult, 1, 2, 0, 2);

			labelSlackresult = new Label ("nb Slack");
			table.Attach (labelSlackresult, 1, 2, 0, 3);
		
			// Add a frame label All Titles
			frame = new Frame (" All Titles ");
			frame.BorderWidth = 4;
		
			vboxinside.PackStart (frame);
			
			Table table2 = new Table (7, 2, true);
			frame.Add (table2);

			Label labelAlltitles = new Label ("Titles:");
			table2.Attach (labelAlltitles, 0, 1, 0, 1);

			Label labelAllfiles = new Label ("Files:");
			table2.Attach (labelAllfiles,0, 1, 0, 2);

			Label labelAllfolders = new Label ("Folders:");
			table2.Attach (labelAllfolders, 0, 1, 0, 3);
		
			Label labelAllsize = new Label ("Size:");
			table2.Attach (labelAllsize, 0, 1, 0, 4);
		
			Label labelAllspace = new Label ("Space:");
			table2.Attach (labelAllspace, 0, 1, 0, 5);

			Label labelAllslack = new Label ("Slack:");
			table2.Attach (labelAllslack , 0, 1, 0, 6);
	 	
			Label labelAllFreespace = new Label ("Free Space:");
			table2.Attach (labelAllFreespace , 0, 1, 0, 7);
	 	
			// Result Labels
			labelAlltitlesResult = new Label ("nbTitles");
			table2.Attach (labelAlltitlesResult, 1, 2, 0, 1);

			labelAllfilesResult = new Label ("nbFiles");
			table2.Attach (labelAllfilesResult, 1, 2, 0, 2);

			labelAllfoldersResult = new Label ("nbFolders");
			table2.Attach (labelAllfoldersResult, 1, 2, 0, 3);
		
			labelAllsizeResult = new Label ("nbSize");
			table2.Attach (labelAllsizeResult, 1, 2, 0, 4);
		
			labelAllspaceResult = new Label ("nbSpace");
			table2.Attach (labelAllspaceResult, 1, 2, 0, 5);

			labelAllslackResult = new Label ("nbSlack");
			table2.Attach (labelAllslackResult, 1, 2, 0, 6);

			labelAllFreespaceResult = new Label ("nbFreeSpace");
			table2.Attach (labelAllFreespaceResult, 1, 2, 0, 7);
		
			DLicons = new CheckButton();
			DLicons.Label = "Download icons";
			DLicons.Active = true;
			vboxinside.PackStart (DLicons, false, false, 0);
			// end the inside Vbox 
			#endregion
//=================================================
// 				NoteBook 2
			#region NoteBook 2
			
			VBox vboxnb2 = new VBox (false, 0);
	 		nb.Add(vboxnb2);
	 		nb.SetTabLabelText(vboxnb2, "Load ISO");
		
	 		Toolbar toolbar3 = CreateISOToolbar ();
			vboxnb2.PackStart (toolbar3, false, false, 0);
	 	
			// Add Vertical Frame
			VPaned vpan = new VPaned ();
			vpan.Position = 290;
			vboxnb2.PackStart (vpan, true, true, 0);
			vpan.BorderWidth = 0;

	 		// Add a scrolledWindows for the ISOList
			ScrolledWindow sw2 = new ScrolledWindow ();

	 		vpan.Add(sw2);
	 	
			// Create the treeview containing 6 string
			store2 = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string) );
	
			// sort by on name for column 0
			//store.SetSortColumnId(0, 0);
			tv2 = new TreeView (store2);
			tv2.HeadersVisible = true;

			// This is bad but if i don't it that way.
			// if i don't it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column2 = new TreeViewColumn ();
			CellRendererText text2 = new CellRendererText ();
			column2.Title = "XBE Title";
			column2.Resizable = true;
			column2.SortColumnId = 0;
	 	
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 0);
			tv2.AppendColumn(column2);

			// 2
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Size";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 1);
			tv2.AppendColumn(column2);
			
			// 3 
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Game Folder";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			column2.Sizing = TreeViewColumnSizing.Autosize;
						
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 2);
			tv2.AppendColumn(column2);
			
			// 4
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Filename";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 3);
			tv2.AppendColumn(column2);
	 	
			// 5
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Region";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 4);
			tv2.AppendColumn(column2);
	 		sw2.Add(tv2);
	 		
	 		// Add a frame with a label Title view
			Frame frame2 = new Frame (" Transfert Options ");
			frame2.BorderWidth = 4;
	 		vpan.Add(frame2);
	 	
			#region	 ISOoption
		VBox vboxnb3 = new VBox (false, 0);

	 	HBox hboxnbinfo1 = new HBox (false, 0);
	 		Label labelSize = new Label();
	 	/*	Need pango-markup
	 	 * labelSize.UseMarkup = true;
	 		labelSize.Markup = "<b>Size:</b>";
	 	*/
	 		labelSize.Text = "Size:";
	 	hboxnbinfo1.PackStart (labelSize, false, true, 5);
	 		labelR1 = new Label();
	 		labelR1.Text = "R1";
	 	hboxnbinfo1.PackStart (labelR1, false, true, 5);
	 		Label labelFiles = new Label();
	 		labelFiles.Text = "Files:";
	 	hboxnbinfo1.PackStart (labelFiles, false, true, 5);
	 		labelR2 = new Label();
	 		labelR2.Text = "R2";
	 	hboxnbinfo1.PackStart (labelR2, false, true, 5);
	 		Label labelFolders = new Label();
	 		labelFolders.Text = "Folders:";
	 	hboxnbinfo1.PackStart (labelFolders, false, true, 5);	
	 		labelR3 = new Label();
	 		labelR3.Text = "R3";
	 	hboxnbinfo1.PackStart (labelR3, false, true, 5);	 	
	 	vboxnb3.PackStart (hboxnbinfo1, true, true, 0);

	 	HBox hboxnbinfo4 = new HBox (false, 0);
 		Label labelxbe = new Label();
 		labelxbe.Text = "New Title:";
	 	hboxnbinfo4.PackStart (labelxbe, false, false, 5);
 		Entrygamexbe = new Entry();
 		Entrygamexbe.Text = "xbename";
	 	Entrygamexbe.MaxLength = 42;
	 	Entrygamexbe.WidthRequest = 255;
	 	hboxnbinfo4.PackStart (Entrygamexbe, false, false, 10);
	 	vboxnb3.PackStart (hboxnbinfo4, true, true, 0);
	 
	 	HBox hboxnbinfo2 = new HBox (false, 0);
 		Label labelMain = new Label();
 		labelMain.Text = "Main Folder:";
	 	hboxnbinfo2.PackStart (labelMain, false, false, 5);
 		Entryxboxdir = new Entry();
 		Entryxboxdir.Text = "xboxdir";
	 	Entryxboxdir.WidthRequest = 255;
	 	hboxnbinfo2.PackStart (Entryxboxdir, false, false, 10);
 		Label labelHelp = new Label();
 		labelHelp.Text = "(Evolution-X: 'E', XBMC: 'E:', Avalaunch: 'E:')";
	 	hboxnbinfo2.PackStart (labelHelp, false, false, 5);
	 	vboxnb3.PackStart (hboxnbinfo2, true, true, 0);
	 	
	 	HBox hboxnbinfo3 = new HBox (false, 0);
 		Label labelGame = new Label();
 		labelGame.Text = "Game Folder:";
	 	hboxnbinfo3.PackStart (labelGame, false, false, 5);
 		Entrygamedir = new Entry();
 		Entrygamedir.Text = "gamedir";
	 	Entrygamedir.MaxLength = 42;
	 	Entrygamedir.WidthRequest = 255;
	 	hboxnbinfo3.PackStart (Entrygamedir, false, false, 10);
	 	vboxnb3.PackStart (hboxnbinfo3, true, true, 0);
		#endregion
		
	 	frame2.Add(vboxnb3);
			#endregion
//======================================
						
			// Add a Text View
			// Maybe to make a log view better than console
			/*TextView textview = new TextView ();
			vbox.PackStart (textview, true, true, 0);*/
		
			// Bad i need to initialize the game list
			//liste = new string[0];
	 		liste = null;
			CurrentGame = new ArrayList();
			
			// Add a status bar
			statusbar = new Statusbar ();
			statusbar.Push (1, "Xbgm# ready.");
			vbox.PackStart (statusbar, false, false, 0);
			//END of first vbox 
		
		}
			catch(Exception ex){
				Console.WriteLine(ex.Message);
		}
		// Show the all window
		this.ShowAll ();
		
		// Init the FTP structure
		FTPinfo = new FTP();
		// Init the Xiso Info class
		iso = new XisoInfoClass();
		
		ReadConf();
	}
	
	void OnMyWindowDelete (object o, DeleteEventArgs args)
	{
		Application.Quit ();
	}
	
		#region CreateToolbar
		/// <summary>
		/// Create the Game Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateGameToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			
			toolbar.AppendItem ("Scans Titles",
				"Scans Titles", String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.Button),
				new Gtk.SignalFunc (OnToolbarScanTitlesClicked));
			toolbar.AppendSpace();
	
			pix = new Gdk.Pixbuf (null, "edit.xpm");
			toolbar.AppendItem ("Rename", 
				"Rename", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRenameClicked));	
			
			toolbar.AppendItem ("Launch",
				"Launch Game", String.Empty,
				new Gtk.Image (Stock.Execute, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarLaunchClicked));	
			
			toolbar.AppendItem ("Delete",
				"Delete", String.Empty,
				new Gtk.Image (Stock.Delete, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarDeleteClicked));	
		
			toolbar.AppendSpace();
			
			toolbar.AppendItem ("Save List",
				"Save List", String.Empty,
				new Gtk.Image (Stock.SaveAs, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarExportClicked));	
	
			return toolbar;
		}
		
		/// <summary>
		/// Create the ISO Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateISOToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			
			toolbar.AppendItem ("_Open",
				"Open ISO", String.Empty,
				new Gtk.Image (Stock.Open, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarOpenISOClicked));	
			
			toolbar.AppendItem ("FTP Upload ISO",
				"FTP Upload ISO", String.Empty,
				new Gtk.Image (Stock.GotoTop, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarUploadISOClicked));
		
			toolbar.AppendItem ("Extract ISO",
				"Extract ISO", String.Empty,
				new Gtk.Image (Stock.GotoFirst, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarExtractISOClicked));
			
		/*	toolbar.AppendSpace();

			toolbar.AppendItem ("_Open",
				"Open ZIP", String.Empty,
				new Gtk.Image (Stock.Open, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarOpenISOClicked));
			
			toolbar.AppendItem ("FTP Upload ZIP",
				"FTP Upload ZIP", String.Empty,
				new Gtk.Image (Stock.GotoTop, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarUploadISOClicked));
		*/
			return toolbar;
		}
		
		/// <summary>
		/// Create the TOP Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateTopToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;

			toolbar.AppendItem ("Configuration",
				"Configuration", String.Empty,
				new Gtk.Image (Stock.Preferences, IconSize.Button),
				new Gtk.SignalFunc (OnToolbarPrefClicked));
			
			toolbar.AppendSpace();	
		
			pix = new Gdk.Pixbuf (null, "xbmc.png");
			toolbar.AppendItem ("XBMC", 
				"Xbox Media Center", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarXBMCClicked));	

			toolbar.AppendSpace();	
			
			pix = new Gdk.Pixbuf (null, "shutdown.png");
			toolbar.AppendItem ("Shutdown", 
				"Shutdown Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarShutdownClicked));	
 
			pix = new Gdk.Pixbuf (null, "reboot.png");
			toolbar.AppendItem ("Reboot", 
				"Reboot Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRestartClicked));	
			
			toolbar.AppendSpace();
			
			pix = new Gdk.Pixbuf (null, "infoicon.png");
			toolbar.AppendItem ("Information", 
				"Information", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarAboutClicked));	

			return toolbar;
		}
		#endregion
		
		#region OnToolbarTopClicked
		private void OnToolbarPrefClicked ()
		{
			PrefDialog login = new PrefDialog ();
			
			if (ReadConf() == true)
			{   // set conf value to preference dialog
				login.Password = FTPinfo.pass;
				login.User = FTPinfo.user;
				login.IP = FTPinfo.IP;
				login.Port = FTPinfo.port;
				login.Dir = FTPinfo.dir;
				login.UseCache = cache;
				login.XBMCDir = XBMC;
			}
			if ((int)ResponseType.Ok == login.Run())
			{
				FTPinfo.pass  = login.Password;
				FTPinfo.user  = login.User;
				FTPinfo.IP  = login.IP;
				FTPinfo.dir  = login.Dir;		
				FTPinfo.port = login.Port;
				cache = login.UseCache;
				XBMC = login.XBMCDir;
				login.Close();			
				login = null;
				
				SaveConf();
			}
		}

		private void OnToolbarXBMCClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.xbmc;
			FtpToXbox("");
			//UpdateStatusBar("Xbox Media Center Start");
		}
		
		private void OnToolbarShutdownClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.shutdown;
			FtpToXbox("");
			//UpdateStatusBar("Xbox Shutdown");
		}

		private void OnToolbarRestartClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.reboot;
			FtpToXbox("");
			//UpdateStatusBar("Xbox Reboot");
		}
		
		private void OnToolbarAboutClicked()
		{
			System.Text.StringBuilder AuthorStringBuild = new System.Text.StringBuilder ();
		    String []authors = new String[]	{
		    	"KaYa <xbgm@kayaweed.net>",
		    	""
		    };
			
		    AuthorStringBuild.Append (NAME + " " + VERSION + "\n\n");
		    AuthorStringBuild.Append ("Xbox Game Manager.\n");
		    AuthorStringBuild.Append ("Copyright (c) 2004\n\n");
		    AuthorStringBuild.AppendFormat (
		    	"Authors:\n\t{0}\n\t{1}",
		    	authors[0],
		    	authors[1]
		    	); 
		    
		    MessageDialog md = new MessageDialog (this,
		    	DialogFlags.DestroyWithParent,
		    	MessageType.Info,
		    	ButtonsType.Ok, 
		    	AuthorStringBuild.ToString ()
		    	);
		    
		    int result = md.Run ();
		    md.Hide();
			md.Destroy();
		}
		#endregion

		#region OnToolbarGameClicked
		private void OnToolbarScanTitlesClicked ()
		{	
			ReadConf();
			
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			
			// Clear the Liststore
			store.Clear();
			
			Thread t1 = new Thread(new ThreadStart(f1));

			// Ask for cache if Avtived in configuration
	/*		if (cache == true) 
			{
				System.Text.StringBuilder StringBuild = new System.Text.StringBuilder ();
				StringBuild.Append("Do you wish to use cache?");
				
				MessageDialog md = new MessageDialog (this, 
				                                      DialogFlags.DestroyWithParent, 
				                                      MessageType.Question, 
				                                      ButtonsType.YesNo, 
				                                      StringBuild.ToString());			
				// need to check what the user choose.
				int result = md.Run ();
				md.Hide ();
				md.Dispose ();
				md.Destroy ();
				StringBuild = null;
				if (result  == (int)ResponseType.Yes)
				{
		*/				
						// So you want to use cache.
						//cache = true;
						bool ok = false;
						// Get the Game listing for the Xbox or cache			
						if(cache)
						{
							#if ( DEBUG )
								Console.WriteLine("Use cache, parse it...");
							#endif
							// if we use cache we have a titles files and icons
							ok = ParseCacheTitles();
						}
						if(!ok)
						{
							#if ( DEBUG )
								Console.WriteLine("Use cache but NOT Found launch FTP");
							#endif
							t1.Start();
						}
	/*			}
				if (result  == (int)ResponseType.No)
				{
					#if ( DEBUG )
						Console.WriteLine("NOT Use cache");
					#endif
					t1.Start();	
				}
			}
			else
			{
				#if ( DEBUG )
					Console.WriteLine("NOT ask cache");
				#endif
				t1.Start();
			}
	*/		
			// Set a  1sec timout to update the GUI
			IDtimeout = Gtk.Timeout.Add((uint)(1000), new Gtk.Function(UpdateStatusBarTimeOut));
		}

		private void f1()
		{
			xboxAction = FtpXbox.scan;
			// Do xbox stuff
			FtpToXbox(""); // Get Titles from xbox
		}

		/// <summary>
		/// Update the status bar with a timeout set to 1 sec.	
		/// Show what we are doing when getting game titles info.
		/// </summary>
		private bool UpdateStatusBarTimeOut()
		{
			if (xboxAction == FtpXbox.image)
				statusbar.Push (1 , "Getting Images....");
			else if (xboxAction == FtpXbox.scan)
				statusbar.Push (1 , "Scanning Titles....");
			else if (xboxAction == FtpXbox.ready)
			{
				statusbar.Push (1 , "XBGM# Ready.");
				Gtk.Timeout.Remove(IDtimeout);
			}
			#if ( DEBUG )
				Console.WriteLine("..");
			#endif
			return true;
		}
		
		private void OnToolbarLaunchClicked()
		{
			// Launch Game by FTP Command
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )	
				{
					Console.WriteLine(CurrentGame[0]);
					Console.WriteLine(CurrentGame[1]);
					Console.WriteLine(CurrentGame[2]);
					Console.WriteLine(CurrentGame[3]);
					Console.WriteLine("user: \"" + FTPinfo.user + "\" pass: \"" + FTPinfo.pass + "\" IP: \"" + FTPinfo.IP + "\" Dir: \"" + FTPinfo.dir + "\"");
				}
				#endif
				// DO xbox FTp stuff
				xboxAction = FtpXbox.launch;
				FtpToXbox("");
			
				// tell the user the game as been launch
				OnInfo(CurrentGame[0] + " Launched");		
			}
		}
		
		private void OnToolbarLaunchClicked(object o, EventArgs args)
		{
			OnToolbarLaunchClicked();
		}
				
		private void OnToolbarDeleteClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )
					Console.WriteLine(CurrentGame[2]);
				#endif

				DeleteDialog login = new DeleteDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got DeleteDialog");	
				#endif
				if (login.action == 1)
					deletesave = false;
				if (login.action == 2)
					deletesave = true;
				if (login.action == 3)
					deletesave = true;
				
				login.Close();
				login = null;
				if(nRc == (int)ResponseType.Ok) {
					// DO xbox FTp stuff
					xboxAction = FtpXbox.delete;
					FtpToXbox("");
				}
			}
		}		

		private void OnToolbarDeleteClicked(object o, EventArgs args)
		{
			OnToolbarDeleteClicked();
		}
		
		private void OnToolbarRenameClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				RenameDialog login = new RenameDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got RenameDialog");	
				#endif
				string newgamename  = login.Game;
				#if ( DEBUG )
					Console.WriteLine("New name: " + newgamename);
				#endif
				login.Close();
				login = null;
				
				if(nRc == (int)ResponseType.Ok) {
					// Do xbox FTP stuff
					xboxAction = FtpXbox.rename;
					FtpToXbox(newgamename);
				}
			}
		}	

		private void OnToolbarRenameClicked(object o, EventArgs args)
		{
			OnToolbarRenameClicked();
		}
		
		private void OnToolbarExportClicked ()
		{
			if(liste != null)
			{
				FileSelection fDlg = new FileSelection("Create a html file.");
	    		fDlg.Complete("*.html");
	    		int nRc = fDlg.Run();
	    		fDlg.Hide();
				
				if(nRc == (int)ResponseType.Ok) {
					Console.WriteLine(fDlg.Filename);
					ExportToHTML(fDlg.Filename);
				}
			}
		}
		#endregion
		
		#region OnToolbarISOClicked
		private void OnToolbarOpenISOClicked ()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.dir == null)
				return;
    		FileSelection fDlg = new FileSelection("Choose a ISO file.");
    		fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
			
			if(nRc == (int)ResponseType.Ok) {
				#if ( DEBUG )
					Console.WriteLine(fDlg.Filename);
				#endif
				iso.xisofilename = fDlg.Filename;
				iso.xbe = true;
				iso.Nbfiles = 0;
				iso.totfilesize = 0;
				iso.getfileiniso();
				labelR1.Text  = iso.isosize.ToString() + " MB";
				labelR2.Text = iso.Nbfiles.ToString();
				labelR3.Text = iso.Nbdir.ToString();
				Entrygamexbe.Text = iso.GameName;
				Entryxboxdir.Text = FTPinfo.dir;
				Entrygamedir.Text = iso.GameFolder;
				string[] info = null;
				if(iso.GameRegion == 1)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "NTSC"};
				else if(iso.GameRegion == 2)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "JP"};
				else if(iso.GameRegion == 4)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "PAL"};
				else
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "Mix"};
				store2.Clear();
				AddISOInfoToRow(info);
				info = null;
				//iso = null;			
			}
			fDlg = null;
		}
		
		private void OnToolbarUploadISOClicked ()
		{
			if (iso.xisofilename != null)
			{
				// Check Free space before Upload
				xboxAction = FtpXbox.freespace;
				FtpToXbox("");
				if (freespace == true) // IF OK
					ExtractXiso();
			}
		}

		private void OnToolbarExtractISOClicked ()
		{ 
			// Need to Specifed where to extract iso on HDD
			FileSelection fDlg = new FileSelection("Choose a ISO file.");
			fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
			if(nRc == (int)ResponseType.Ok) {
			  	FileSelection DirDlg = new FileSelection("Choose a Destination Directory.");
				//DirDlg.SelectionEntry.Text = System.IO.Path.GetDirectoryName(fDlg.Filename);
    			int nRdir = DirDlg.Run();
    			DirDlg.Hide();
				if(nRdir == (int)ResponseType.Ok) {
					#if ( DEBUG )
						Console.WriteLine("File : [" + fDlg.Filename + "] Dir: [" + DirDlg.Filename + "]");
					#endif
					// Save current path before hdd extracting
					string currentdir = Directory.GetCurrentDirectory();
					iso.xisofilename = fDlg.Filename;
					iso.GameRootFolder = DirDlg.Filename;
					iso.xbe = false;
					iso.Nbfiles = 0;
					iso.totfilesize = 0;
					iso.getfileiniso();
					string gameextractdir = System.IO.Path.GetFileName(fDlg.Filename);
					gameextractdir = gameextractdir.Substring(0 ,System.IO.Path.GetFileName(fDlg.Filename).LastIndexOf('.'));
					iso.GameFolder = gameextractdir;
					gameextractdir = null;
					ExtractXiso();
					// Restore the old current path
					Directory.SetCurrentDirectory(currentdir);
					currentdir = null;
					iso.xisofilename = iso.GameRootFolder = iso.GameName = iso.GameFolder = null;
				//	iso = null;				
				}
				DirDlg = null;
			}
			fDlg = null;
		}
		#endregion

		private void ExtractXiso()
		{
			// Create the GUi for the stats
			ProgressDialog progress = new ProgressDialog ();
			// Give the info to the GUI
			//Console.WriteLine(iso.xisofilename + "=" + Entryxboxdir.Text + "=" + Entrygamedir.Text + "=" + iso.Nbfiles + "=" + iso.totfilesize + "=" + FTPinfo.dir + "=" + iso.hdd);
			//Console.ReadLine();
			// Check if we got a / at the end xbox game dir.
			if (Entryxboxdir.Text.Length >= 4 && Entryxboxdir.Text.EndsWith("/") == false)
				Entryxboxdir.Text = Entryxboxdir.Text + "/";	
			// if we parse the xbe then it is extract over network
			if (iso.xbe == true)
				progress.UpdateXiso(iso.xisofilename, Entryxboxdir.Text, Entrygamedir.Text, iso.Nbfiles, iso.totfilesize, FTPinfo, false); // FTpavalaunch
			else 
				progress.UpdateXiso(iso.xisofilename, iso.GameRootFolder, iso.GameFolder, iso.Nbfiles, iso.totfilesize, FTPinfo, true); // HDD
			// Start couting time
			DateTime DtStartNow = DateTime.Now;
			// Do the job
			progress.Run();
			// Stop couting time
			DateTime DtStopNow = DateTime.Now;
			// When finish or cancel
			// Kill the dialog box
			progress.Close();
			string tmptime = (DtStopNow - DtStartNow).ToString();
			if (progress.IsCancel == false)
				OnInfo("Task completed successfully.\n\nTotal bytes transferred: " + (iso.totfilesize/1024) + " KB\nFiles Transferred: " + iso.Nbfiles + "\nElapsed time: " + tmptime.Substring(0, tmptime.LastIndexOf('.')));
			else
				OnInfo("You have cancel the operation or they have been an error.\n\nYou will need to reboot the XBOX if using Avalaunch.");
			tmptime = null;
			progress = null;
			// Can't be null, it is a global.
			// we might need later.
			// iso = null;
			// Ask to clean the memory
			System.GC.Collect();
			return;
		}
		
		#region Treeview_event_right_click
		[GLib.ConnectBefore]
		public void OnTreeviewButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("test Button click");
			#endif
			 switch (args.Event.Button)
            {
                case 3:
                        PopupMenu (args.Event);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenu (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu!");
            #endif
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
					item = new ImageMenuItem (Stock.Execute, group);
            		item.Activated += new EventHandler (OnToolbarLaunchClicked);
            		menu.Append (item);       	
            	
            		item = new Gtk.ImageMenuItem ("Edit");
            		pix = new Gdk.Pixbuf (null, "edit.xpm");
					new Gtk.Image (pix);
            		item.Image = new Gtk.Image (pix);
            		item.Activated += new EventHandler (OnToolbarRenameClicked);
				    menu.Append (item);

                    item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteClicked);
                    menu.Append (item);                                   	
            }
            
            menu.ShowAll ();
            menu.Popup (null, null, null, IntPtr.Zero,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        private void PopupMenuCb(object o, PopupMenuArgs args)
        {
            Console.WriteLine ("Popup Menu Called!");
            PopupMenu (null);
        } 
		#endregion
		
		#region OnError and OnInfo
		public void OnError(string msg)
		{
			System.Text.StringBuilder StringBuild = new System.Text.StringBuilder ();
			StringBuild.Append(msg);
			
			// This make a Warning on Win XP If using the XP theme.
			// works fine on linux on Win32 and with the win classic theme.
			MessageDialog md = new MessageDialog (this, 
				                              DialogFlags.DestroyWithParent, 
				                              MessageType.Error, 
				                              ButtonsType.Ok, 
				                              StringBuild.ToString ());
			md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
			StringBuild = null;
		}

		public void OnInfo(string msg)
		{
			System.Text.StringBuilder StringBuild = new System.Text.StringBuilder ();
			StringBuild.Append(msg);
			
			// This make a Warning on Win XP If using the XP theme.
			// works fine on linux on Win32 and with the win classic theme.
			MessageDialog md = new MessageDialog (this, 
				                              DialogFlags.DestroyWithParent, 
				                              MessageType.Info, 
				                              ButtonsType.Ok, 
				                              StringBuild.ToString ());
			md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
			StringBuild = null;
		}
		#endregion
		
		public void ExportToHTML(string filename)
		{
			StreamWriter outputFilestream = null;
			try {
				outputFilestream = new StreamWriter(filename);
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to setup output export file. " + 
					e.Message);
				return;
			}

			StringBuilder strHtml = new StringBuilder();

			strHtml.Append("<html>\n<head><title>");
			strHtml.Append("Titles list");
			strHtml.Append("</title></head>\n");
			strHtml.Append("<body>\n");
			strHtml.Append("<h1>Titles list</h1>\n");
			strHtml.Append("\t<table border=1>\n");
			strHtml.Append("\t\t<tr>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Game Titles</td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Size MB </td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Path </td>\n");
			strHtml.Append("\t\t</tr>\n");
			outputFilestream.WriteLine(strHtml.ToString());		
			strHtml = new StringBuilder();
			foreach(string toto in liste)
			{
				strHtml = new StringBuilder();
				string[] a = toto.Split('|');
				strHtml.Append("\t\t<tr>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + a[0] + "</td>\n");
				strHtml.Append("\t\t\t<td align=\"center\"> " + a[2] + " MB</td>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + a[5] + "</td>\n");
				strHtml.Append("\t\t</tr>\n");
				outputFilestream.WriteLine(strHtml.ToString());
				strHtml = null;
			}
			outputFilestream.WriteLine("\t</table>\n</body>\n</html>\n");
			strHtml = null;
			outputFilestream.Close();
			outputFilestream = null;
			#if ( DEBUG )
				Console.WriteLine("Outputting HTML file done.");
			#endif
			OnInfo("HTML file saved.");
		}
		
		#region ParseTitles
		public bool ParseCacheTitles()
		{
        		// get an character input stream to read data from .
        		StreamReader reader = null;
        		try
        		{
					reader = new StreamReader("titles.txt");
        		}
				catch(Exception e) {
					Console.WriteLine("Warning: Unable to open cache file. " + 
						e.Message);
					return false;
				}
				
				// read a line at a time
				ArrayList GameLines = new ArrayList();
				string line = null;
				int 	nbTitles = 0;
				Int64 totsizeMb = 0;
				Int64 totspaceMb = 0;
				Int64 totnbFolders = 0;
				Int64 totnbFiles = 0;	
				
				while ((line = reader.ReadLine()) != null)
				{
					//Console.WriteLine("==> " + line);
					string[] one =	line.Split('\t');
					/*	0 dir xbe /// 1 name game /// 2 Size /// 3  Space ///	4 ID 
					    5 FolDERS /// 6 FILES    /// 7 N/A  /// 8 REGION
					*/
				nbTitles ++;
				// Convert size 
				//Console.WriteLine(one[1] + " == "  + one[2]);
				Int64 tmpsize = Convert.ToInt64(one[2]);
				Int64 tmpspace = Convert.ToInt64(one[3]);
				tmpsize >>= 20;
				tmpspace >>= 20;					
				//tmpsize = tmpsize / 1024000;
				string sizeMb = tmpsize.ToString() + " MB"; 
				string spaceMb = tmpspace.ToString() + " MB"; 
				//Console.WriteLine(size.Length + "==" + size);

				totsizeMb += tmpsize;
				totspaceMb += tmpspace;
				totnbFolders += Convert.ToInt64(one[5]);
				totnbFiles += Convert.ToInt64(one[6]);
				
				string tmpdir = one[0].ToString();
				string dir = tmpdir.Substring(0, tmpdir.LastIndexOf('/')+1);
				string xbe = tmpdir.Substring(tmpdir.LastIndexOf('/')+1);	
				string showdir = tmpdir.Substring(FTPinfo.dir.Length, (tmpdir.IndexOf("default.xbe") - FTPinfo.dir.Length) - 1);
				
				string region = "N/A";
				if (one[8] == "4")
				{
					region = "PAL";
				}
				else if(one[8] == "3")
				{
					region = "Mix";
				}
				else if(one[8] == "1")
				{
					region = "NTSC";
				}
				else if(one[8] == "2")
				{
					region = "JP";
				} 
				else {
					region = "None";
				}
				//Console.WriteLine("==> " + one[1]  + " " + sizeMb  + " " + dirgame + " " + one[6]  + " " +  region);
				string[] info = new string[]{one[1], sizeMb, showdir, one[6], one[5], region};
				AddTextToRow(info);
				// So Here i create my one string with the | separator
				// That way i don't care about space in game name
				//	6 Field		// Game name, 		ID, 	       Space, 				        Slack, 						           XBE, 	, DirGame	
				string gamefield2 = one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + xbe + "|" + dir;
				GameLines.Add(gamefield2); 
				region = dir = xbe  = tmpdir = showdir = null;
				spaceMb = sizeMb = null;
				one = info = null;
				}
				try
				{
					reader.Close();
				}
				catch (IOException)
				{
				}
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = nbTitles.ToString();
			labelAllfilesResult.Text = totnbFiles.ToString();
			labelAllfoldersResult.Text = totnbFolders.ToString();
			labelAllsizeResult.Text = totsizeMb.ToString() + " MB";
			labelAllspaceResult.Text = totspaceMb.ToString() + " MB";
			labelAllslackResult.Text = (totspaceMb - totsizeMb) + " MB";
			
			line = null;
			// Save the full list in my global list
			// if any
			if (GameLines.Count > 0){
				#if ( DEBUG )
					Console.WriteLine("nb Games: " + GameLines.Count)	;
				#endif
				liste = (string[]) GameLines.ToArray(typeof(string));
			}
			return true;
		}

		public void ParseFTPTitles(string listings)
		{
				ArrayList GameLines = new ArrayList();
				int 	nbTitles = 0;
				Int64 totsizeMb = 0;
				Int64 totspaceMb = 0;
				Int64 totnbFolders = 0;
				Int64 totnbFiles = 0;
			
				//Console.WriteLine("==> [" + listings + "]");
			
				// Get nb Games
				string[] full =	listings.Split('|');
				#if ( DEBUG )
					Console.WriteLine("nb lines:["+ full[1]+ "]");
				#endif
				string[] line =	full[0].Split('\n');
				for (Int32 i = 0; i < Convert.ToInt32(full[1]); i++)
				{
					#if ( DEBUG )
						Console.WriteLine(Convert.ToInt32(full[1]) + " I:" + i + "] [" + line[i] + "]");
					#endif
					//Console.WriteLine("==> " + line);
					string[] one =	line[i].Split('\t');
					/*	0 dir xbe /// 1 name game /// 2 Size /// 3  Space ///	4 ID 
					    5 FolDERS /// 6 FILES    /// 7 N/A  /// 8 REGION
					*/
				nbTitles ++;

				// Convert size 
				//Console.WriteLine(one[1] + " == "  + one[2]);
				Int64 tmpsize = Convert.ToInt64(one[2]);
				Int64 tmpspace = Convert.ToInt64(one[3]);
				tmpsize >>= 20;
				tmpspace >>= 20;					
				string sizeMb = tmpsize.ToString() + " MB"; 
				string spaceMb = tmpspace.ToString() + " MB"; 
				//Console.WriteLine(size.Length + "==" + size);

				totsizeMb += tmpsize;
				totspaceMb += tmpspace;
				totnbFolders += Convert.ToInt64(one[5]);
				totnbFiles += Convert.ToInt64(one[6]);
								
				string tmpdir = one[0].ToString();
				string dir = tmpdir.Substring(0, tmpdir.LastIndexOf('/')+1);
				string xbe = tmpdir.Substring(tmpdir.LastIndexOf('/')+1);	
				string showdir = tmpdir.Substring(FTPinfo.dir.Length, (tmpdir.IndexOf("default.xbe") - FTPinfo.dir.Length) - 1);	
				//Console.WriteLine("==>{0} + {1} + {2} + {3} + {4}", FTPinfo.dir.Length, tmpdir, dir, tmpdir.IndexOf("default.xbe"), showdir);
				tmpdir = null;
				
				string region = "N/A";
				if (one[8] == "4")
					region = "PAL";
				else if(one[8] == "3")
					region = "Mix";
				else if(one[8] == "1")
					region = "NTSC";
				else if(one[8] == "2")
					region = "JP";
				else {
					region = "None";
				}
				//Console.WriteLine("==> " + one[1]  + " " + sizeMb  + " " + dirgame + " " + one[6]  + " " +  region);
				string[] info = new string[]{one[1], sizeMb, showdir, one[6], one[5], region};
				AddTextToRow(info);
				// So Here i create my one string with the | separator
				// That way i don't care about space in game name
				//	6 Field		// Game name, 		ID, 	       Space, 				        Slack, 						           XBE, 	, DirGame	
				string gamefield2 = one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + xbe + "|" + dir;
				GameLines.Add(gamefield2); // OK
				//Console.WriteLine(one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + xbe + "|" + dir);
				//Console.ReadLine();
				// Clean memory 
				region = dir = xbe  = tmpdir = showdir = gamefield2 = null;
				spaceMb = sizeMb = null;
				one = info = null;
				// END FOR
		        }
				// Sort title by game title
				store.SetSortColumnId(0, SortType.Ascending);
				
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = nbTitles.ToString();
			labelAllfilesResult.Text = totnbFiles.ToString();
			labelAllfoldersResult.Text = totnbFolders.ToString();
			labelAllsizeResult.Text = totsizeMb.ToString() + " MB";
			labelAllspaceResult.Text = totspaceMb.ToString() + " MB";
			labelAllslackResult.Text = (totspaceMb - totsizeMb) + " MB";		
			
			// Save the full list in my global list
			// if any
			if (GameLines.Count > 0)
			{
				#if ( DEBUG )
					Console.WriteLine("nb Games: " + GameLines.Count);
				#endif
				liste = (string[]) GameLines.ToArray(typeof(string));
			// example to get info in my list
			/*		foreach(string toto in liste)
					{
						string[] a = toto.Split('|');
						Console.WriteLine("test1: "  + a[0]);
					}
			*/
			//END IF
			}
			full = null;
			line = null;
		}
		#endregion
		
		// Each arg is a new column
		public void AddTextToRow (params string[] args)
		{	
			iter = store.AppendValues(args);
			tv.Model = store;
			
		}		
			
		// Each arg is a new column
		public void AddISOInfoToRow (params string[] args)
		{	
			iter2 = store2.AppendValues(args);
			tv2.Model = store2;
		}

		// Get single selection
		private void on_List_selection(object o, EventArgs args)
		{	
			string result;
			string sel;
			
			store.GetIterFirst(out iter);
			if (tv.Selection.IterIsSelected(iter)) 
			{
				result = (string)store.GetValue(iter, 0);
				#if ( DEBUG )
					Console.WriteLine("Result First sel: " + result);
				#endif
				FindGame(result);
			}
			
			while (store.IterNext(ref iter)) {
				if ( tv.Selection.IterIsSelected(iter)) {
					sel = (string)store.GetValue(iter, 0);
					#if ( DEBUG )
						Console.WriteLine("Result sel: " + sel);
					#endif
					FindGame(sel);
				}
			}
		}

		// Get Pixbuf from BMP image for title		
	    static Gdk.Pixbuf GetPixbufFromFile (string filename)
	    {
	        try {
	            Pixbuf p = new Pixbuf (filename);
	            return p;
	
	        } catch (GLib.GException e) {
	            Console.WriteLine (e.GetType ());
	            Console.WriteLine ("Cannot Open image file.");
	        	// Don't know but it kill the application
	            //Environment.Exit (1);
	            return null;
	        }
	
	    }
	
		// Find a game in the list form a string
		public void FindGame(string tofind)    
		{
			foreach(string toto in liste)
			{
				string[] a = toto.Split('|');
				//	Console.WriteLine("GameName: "  + a[0]);
				if (a[0].Equals(tofind))
					{
						#if ( DEBUG )
							Console.WriteLine("ok i found: "  + a[0]);
						#endif
						UpdateSelectedTitleInfo(a);
					}
			}
		}
	
		// Update Selected Title Info Label
		public void UpdateSelectedTitleInfo(string[] newgameselected)
		{
			labelIDresult.Text = newgameselected[1];
			labelSpaceresult.Text = newgameselected[2] + " MB";
			labelSlackresult.Text = newgameselected[3] + " MB";
			//Console.WriteLine("ImageFile: " + nwgameselected[1] + ".bmp");
			//image = new Image(a[1] + ".bmp");
			
			if (DLicons.Active)
			{
				try
				{
				// Bad this is growindg in memory for each image pixbuf .
				// event if the image was all ready open
				Pixbuf p = GetPixbufFromFile ("titleimage/" + newgameselected[1] + ".bmp");
				image.Pixbuf = p;
				}	
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache icon file.");
					Console.WriteLine(e.Message);
					return;
				}	
			}
	
			if (CurrentGame != null)
			{
				CurrentGame.Clear();
			}
			// Create my list of the current game with info i need 
			CurrentGame.Add(newgameselected[0]); // name
			CurrentGame.Add(newgameselected[4]); // XBE
			CurrentGame.Add(newgameselected[5]); // dir
			CurrentGame.Add(newgameselected[1]); // ID
			#if ( DEBUG )
				Console.WriteLine("Nb info in CurrentGame: " + CurrentGame.Count);
				Console.WriteLine("==> {0},{1},{2},{3}", CurrentGame[0],
				                  CurrentGame[1], CurrentGame[2],
				                  CurrentGame[3]);
			#endif
		}
		
		// Handle zip file for picture titles
		public static void ZipExtract(string args)
		{
			ZipInputStream s = null;
			try
			{
				s = new ZipInputStream(File.OpenRead(args));
	        	}
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache zip image file.");
					Console.WriteLine(e.Message);
					return;
				}
				ZipEntry theEntry;
				#if ( DEBUG )
					Console.WriteLine("Zip:" + args);
				#endif
				while ((theEntry = s.GetNextEntry()) != null) 
				{
					#if ( DEBUG )
						Console.WriteLine(theEntry.Name);
					#endif
					string directoryName = null;
					string fileName = null;
					try
					{
						directoryName = System.IO.Path.GetDirectoryName(theEntry.Name);
						fileName      = System.IO.Path.GetFileName(theEntry.Name);
					}
					catch(Exception e) {
						Console.WriteLine("Error: Unable to open zip file. Zip File is corrupt " + 
							e.Message);
						return;
					}
					// we don't want it, i will do it mself
					// create directory
					//string[] dir = directoryName.Split('\');
					
					Directory.CreateDirectory("titleimage");
					string filenames = "titleimage/" + fileName;
	
					if (fileName != String.Empty) 
					{
						FileStream streamWriter = File.Create(filenames);
					
						int size = 2048;
						byte[] data = new byte[2048];
						while (true) 
						{
							size = s.Read(data, 0, data.Length);
							if (size > 0) 
							{
								streamWriter.Write(data, 0, size);
							} 
							else 
							{
								break;
							}
						}
						streamWriter.Close();
						streamWriter = null;
					}
					fileName = null;
					directoryName = null;
				}
				s.Close();
				s = null;
			// End Zip
		}
		
		// FTP Connect then to the selected command  
		public void FtpToXbox(string newgamename)
		{
			try
			{
				//UpdateStatusBar("FTP job Start.");
				// Create socket
				//FTPClient ftp = new FTPClient(FTPinfo.IP, FTPinfo.port, null, 2);
				FTPClient ftp = new FTPClient(FTPinfo.IP, FTPinfo.port);
				#if ( DEBUG )
					ftp.DebugResponses(true);
				#endif
				// Login
				ftp.Login(FTPinfo.user, FTPinfo.pass);
				ftp.System();
				// Crash on Linux
				//ftp.Timeout = 10;
				switch(xboxAction) 
				{
					case FtpXbox.scan: // Get Titles
					{
						if (ftp.Site("FREEROOTSPACEENABLE") == false) // Check for avalaunch
						{
							Console.WriteLine("This feature requires Avalaunch, or a newer version.");
							xboxAction = FtpXbox.ready;
							break;
						}
						ftp.TransferType = FTPTransferType.BINARY;
						// Do all command and get titles game in a string[]
						// The problem of this is than i need to wait to recevied the all list of Game
						string listings = ftp.GetTitles(FTPinfo.dir);
							
						ParseFTPTitles(listings);
						listings = null;
					
						// Check if i need to DL icons
						if (DLicons.Active)
						{
							xboxAction = FtpXbox.image;
							ftp.Site("TITLEIMAGES");
							ftp.Get(@"titleimage.zip", @"/Z:/titleimage.zip");
							ZipExtract(@"titleimage.zip");
						}
						xboxAction = FtpXbox.ready;
						ftp.Site("FREEROOTSPACEENABLE");
						string[] rootspace = ftp.Dir("/", true);
						foreach(string space in rootspace)
						{
							//Console.WriteLine("Space:" + space + "]");
							string[] free = space.Split(' ');
							//Console.WriteLine("[" + free[24].ToString() +"] == [" +FTPinfo.dir.Substring(0, 2) +"]");
							if(free[24].Equals(FTPinfo.dir.Substring(0, 2)))
							{
								//Console.WriteLine("Free Space:" + free[26].ToString());
								labelAllFreespaceResult.Text = free[26].ToString() + " MB";
							}
						}
						rootspace = null;
						break;
					}
					case FtpXbox.delete: // Delete
					{
						ftp.TransferType = FTPTransferType.BINARY;
						
						// I don't know why but they do it
						ftp.Site("FREEROOTSPACEDISABLE ");			
						
													// xbe full path
						bool ok = ftp.Site("DELTREE " + CurrentGame[2]);			
						if(ok == false)
						{
							// then we do it the old way
							ftp.Rmdir(CurrentGame[2].ToString());
						}
						
						if(deletesave)
						{										//ID
							ok = ftp.Site(@"DELTREE /E:/UDATA/" + CurrentGame[3]);
							ok = ftp.Site(@"DELTREE /E:/TDATA/" + CurrentGame[3]);
						}
						break;
					}

					case FtpXbox.rename: // Rename XBE
					{
						ftp.TransferType = FTPTransferType.BINARY;
											    // xbe full path
						ftp.Site("XBERENAME \"" + CurrentGame[2] + CurrentGame[1] + "\" " + newgamename);			
						break;
					}
					case FtpXbox.launch: // Launch 
					{
						ftp.TransferType = FTPTransferType.BINARY;
											// full path      // xbe
						ftp.Site("LAUNCH " + CurrentGame[2] + CurrentGame[1]);			
						break;
					}
					case FtpXbox.shutdown: // Shutdown
					{
						ftp.Site("SHUTDOWN");			
						break;
					}
					case FtpXbox.reboot: // Restart
					{
						ftp.Site("REBOOT");			
						break;
					}
					case FtpXbox.xbmc: // Launch XBMC
					{
						ftp.TransferType = FTPTransferType.BINARY;
		
						// XBMC xbe full path
						ftp.Site("LAUNCH " + XBMC);			
						break;
					}
					case FtpXbox.freespace: // Check free space before upload
					{
						ftp.TransferType = FTPTransferType.BINARY;
		
						if (ftp.Site("FREEROOTSPACEENABLE") == true)
						{
							string[] rootspace = ftp.Dir("/", true);
							foreach(string space in rootspace)
							{
								//Console.WriteLine("Space:" + space + "]");
								string[] free = space.Split(' ');
								//Console.WriteLine("[" + free[24].ToString() +"] == [" + Entryxboxdir.Text.Substring(0, 2) +"]");
								if(free[24].Equals(Entryxboxdir.Text.Substring(0, 2)))
								{
									string[] fspace = labelR1.Text.Split(' ');
									//Console.WriteLine("we need:" + fspace[0] + " and we have:" + free[26]);
									if (Convert.ToUInt32(fspace[0]) > Convert.ToUInt32(free[26]))
										OnInfo("You don't enough free space on " + Entryxboxdir.Text.ToString());
									else
										freespace = true;
									fspace = null;
								}
								free = null;
							}
							rootspace = null;
							ftp.Site("FREEROOTSPACEDISABLE");	
						}
						else
						{ // Not using Avalaunch
							#if ( DEBUG )
								Console.WriteLine("Not using Avalaunch");
							#endif
							freespace = true;		
						}
						break;
					}					
					default:            
            			Debug.WriteLine("Invalid FTP selection. Please select scan, rename, delete, launch, xbmc, freespace, reboot or shutdown.");            
            			break;  

				}
				// The default quit wait for a reply but there is none
				// so it crash, need to catch exception
				// or do it like this, I made my own Quit with out reply
				ftp.QuitXbox();
				ftp = null;
				System.GC.Collect();
			// END try
			}
			catch (IOException ex) 
			{
				Console.WriteLine("Caught IO exception: " + ex.Message);
				// Got a problem when launch in thread
				//OnError(ex.Message);
				// TO refresh the statusbar and stop gtk timer;
				xboxAction = FtpXbox.ready;
				return ;
			}
			catch (FTPException ex) 
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				// Got a problem when launch in thread
				//OnError(ex.Message);
				// TO refresh the statusbar and stop gtk timer;
				xboxAction = FtpXbox.ready;
				return ;
			}
			catch (SocketException ex)
			{
				Console.WriteLine("Caught Socket exception: " + ex.Message);
				// Got a problem when launch in thread
				//OnError(ex.Message);
				// TO refresh the statusbar and stop gtk timer;
				xboxAction = FtpXbox.ready;
				return ;
			}
		}
		
		#region conffile
		public void SaveConf()
		{		
			StreamWriter outputConfstream = null;
			try {
				outputConfstream = new StreamWriter("xbgmsharp.conf");
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to setup conf file. " + 
					e.Message);
				return;
			}

			outputConfstream.WriteLine(FTPinfo.IP);
			outputConfstream.WriteLine(FTPinfo.port);
			outputConfstream.WriteLine(FTPinfo.dir);
			outputConfstream.WriteLine(FTPinfo.user);
			outputConfstream.WriteLine(FTPinfo.pass);
			outputConfstream.WriteLine(cache?"Y":"N");
			outputConfstream.WriteLine(XBMC);
			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
		}
		
		public bool ReadConf()
		{
			//Catch exception and exit 	if not fount WHY?
			StreamReader inputConfstream = null;
			try {
				inputConfstream = new StreamReader("xbgmsharp.conf");
			}
			catch(Exception e) {
				Debug.WriteLine("Warning: Unable to open conf file. " + 
					e.Message);
				return false;
			}
			string line = null;
			int nbline = 0;
			while((line = inputConfstream.ReadLine()) != null)
			{
				switch(nbline)
				{
					case 0:
						FTPinfo.IP = line.ToString();
						break;
					case 1:
						FTPinfo.port = Convert.ToInt32(line.ToString());
						break;
					case 2:
						FTPinfo.dir = line.ToString();
						break;
					case 3:
						FTPinfo.user = line.ToString();
						break;
					case 4:
						FTPinfo.pass = line.ToString();
						break;
					case 5:
						{
						string result = line.ToString();
						if(result.Equals("Y"))
							cache = true;
						else
							cache = false;
						break;
						}
					case 6:
						{
						XBMC = line.ToString();
						break;
						}
					default:
						Console.WriteLine("Error in conf file, Line not handle");
						break;
				}
				nbline++;
			}
			inputConfstream.Close();
			inputConfstream = null;
			#if ( DEBUG )
				Debug.WriteLine("Readconf == user: \"" + FTPinfo.user + "\" pass: \"" + FTPinfo.pass + "\" IP: \"" + FTPinfo.IP + "\" PORT: \"" + FTPinfo.port + "\" Dir: \"" + FTPinfo.dir + "\"");
			#endif
			return true;
		}
		#endregion
	}
// End NameSpace
}

