; XBGM# Win32 Installer
;
;
; Version: MPL 1.1/GPL 2.0/LGPL 2.1
;
; The contents of this file are subject to the Mozilla Public License Version 
; 1.1 (the "License"); you may not use this file except in compliance with 
; the License. You may obtain a copy of the License at 
; http://www.mozilla.org/MPL/
;
; Software distributed under the License is distributed on an "AS IS" basis,
; WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
; for the specific language governing rights and limitations under the
; License.
;
; The Initial Developer of the Original Code is
; Lacroix Francois <kaya@kayaweed.net>.
;
; Alternatively, the contents of this file may be used under the terms of
; either of the GNU General Public License Version 2 or later (the "GPL"),
; or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
; in which case the provisions of the GPL or the LGPL are applicable instead
; of those above. If you wish to allow use of your version of this file only
; under the terms of either the GPL or the LGPL, and not to allow others to
; use your version of this file under the terms of the MPL, indicate your
; decision by deleting the provisions above and replace them with the notice
; and other provisions required by the GPL or the LGPL. If you do not delete
; the provisions above, a recipient may use your version of this file under
; the terms of any one of the MPL, the GPL or the LGPL.
;

; Define your application name
!define APPNAME "XBGM#"
!define APPVERSION "0.6"
!define APPNAMEANDVERSION "XBGM# 0.6"
!define SETUPVERSION "0.5"

; Define mono .NET WEB installer
; PROJECT url
!define WEBPATH "http://www.go-mono.com/archive/1.0.2/windows/"
!define WEBFILE "mono-1.0.2-gtksharp-1.0.2-win32-0.7.exe"
	
; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\XBGM#"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "../xbgmsharp-${APPVERSION}-setup-${SETUPVERSION}.exe"

; Modern interface settings
!include "MUI.nsh"

!define MUI_BrandingText "${APPNAME} Installer v${APPVERSION}"

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN "$INSTDIR\xbgmsharp.bat"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.TXT"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "gpl.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_RESERVEFILE_LANGDLL

Function create_script
	;Get mono version path
	;ReadRegStr $1 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono" "DefaultCLR"

        ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\1.0.2" "SdkInstallRoot"
        ;ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\1.0" "SdkInstallRoot"

	FileOpen $0 "$INSTDIR\xbgmsharp.bat" "w"
	FileWrite $0 "@ECHO OFF"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "SETLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET PATH="$2";%PATH%'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_PATH="$2\lib"'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_CFG_DIR="$2\etc"'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 '"$2\lib\mono.exe" "xbgmsharp.exe" %*'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "ENDLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileClose $0
FunctionEnd



Section "XBGM#" Section1

	; Set Section properties
	SectionIn RO
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\src\bin\Release\ICSharpCode.SharpZipLib.dll"
        ;Not need anymore i generate the bat file from the version of mono install
        ;File "..\src\bin\Debug\xbgmsharp.bat"
	File "..\src\bin\Release\gtkrc"
	File "..\src\bin\Release\xbgmsharp.exe"
	File "..\README.TXT"
	
	Call create_script
	
	CreateDirectory "$SMPROGRAMS\XBGM#"
;	CreateShortCut "$DESKTOP\xbgmsharp.lnk" "$INSTDIR\xbgmsharp.bat" "1" "$INSTDIR\xbgmsharp.exe" 0
	CreateShortCut "$DESKTOP\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "$INSTDIR\xbgmsharp.exe"
;	CreateShortCut "$DESKTOP\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "C:\WINDOWS\explorer.exe" 4
	CreateShortCut "$SMPROGRAMS\XBGM#\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "$INSTDIR\xbgmsharp.exe"
	CreateShortCut "$SMPROGRAMS\XBGM#\Uninstall.lnk" "$INSTDIR\uninstall.exe"

SectionEnd

Section "Mono-1.0 & GTK#-1.0" Section2

	; Set Section properties
	;SectionIn RO
	SetOverwrite on

  SetOutPath "$INSTDIR"
    NSISDL::download "${WEBPATH}${WEBFILE}" "$TEMP\${WEBFILE}"
    Pop $0
    StrCmp $0 "success" doit abortdownload
    abortdownload:
      Abort "Error Downloading"
     doit:
	ExecWait "$TEMP\${WEBFILE} /SILENT"
;	ExecWait "$TEMP\${WEBFILE}"
        File /nonfatal /r "$TEMP\${WEBFILE}"
;    done:
      Call create_script
SectionEnd

Section -FinishSection

	WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "Install Xbox Game Manager"
	!insertmacro MUI_DESCRIPTION_TEXT ${Section2} "Download and install the setup version of Mono-1.0 and GTK#-1.0 directly from the web"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section Uninstall

	;Remove from registry...
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
	DeleteRegKey HKLM "SOFTWARE\${APPNAME}"

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\XBGM#.lnk"
	Delete "$SMPROGRAMS\XBGM#\XBGM#.lnk"
	Delete "$SMPROGRAMS\XBGM#\Uninstall.lnk"

	; Clean up XBGM#
	Delete "$INSTDIR\ICSharpCode.SharpZipLib.dll"
	Delete "$INSTDIR\xbgmsharp.bat"
	Delete "$INSTDIR\xbgmsharp.exe"
	Delete "$INSTDIR\README.TXT"
	Delete "$INSTDIR\gtkrc"
	Delete "$INSTDIR\xbgmsharp.exe.manifest"
	Delete "$INSTDIR\*"
	
	; Clean extra file
	Delete "$INSTDIR\xbgmsharp.conf"
	Delete "$INSTDIR\titles.txt"
	Delete "$INSTDIR\titleimage"

	; Remove remaining directories
	RMDir "$SMPROGRAMS\XBGM#"
	RMDir "$INSTDIR\"

SectionEnd

; eof
