/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/14 KaYa
/// first release
///
/// </summary>

using System;
using System.IO;
using System.Xml;
using System.Collections;

namespace Xbgm
{
	public class ConfigXml
	{
		private static string XmlFile = "config.xml";
		private XmlDocument xmldoc;
		private FileStream 	fs;
		
		public bool		defaut;
		public int		id;
		public string 	ip;
		public int		port;
		public string	username;
		public string	password;
		public string 	dir;
		public string	xbmcdir;
		public bool		Gdrive;
		
		public ConfigXml()
		{
			if (!System.IO.File.Exists(XmlFile))
				WriteDefaultConfig();
		}
		
		public void ConfigOpen()
		{	
			fs = new FileStream(XmlFile,FileMode.Open,FileAccess.Read, FileShare.ReadWrite);
			xmldoc = new XmlDocument();
			xmldoc.Load(fs);
		}

		public void ConfigClose()
		{	
			fs.Close();
		}

		public void DisplayGlobal()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Global");
			Console.WriteLine("Here is the list of Connection: {0}\n", xmlnode[0].ChildNodes.Count);
		   for(int i=0;i<xmlnode[0].ChildNodes.Count;i++)
		   {
				Console.WriteLine("Name: {0}\tValue: {1}", xmlnode[0].ChildNodes[i].Name, xmlnode[0].ChildNodes[i].InnerText);
				Console.WriteLine();
		   }
		}

		public void DisplayXbox()
		{
		XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Connection");
		Console.WriteLine("Here is the list of Connection: {0}\n", xmlnode[0].ChildNodes.Count);
		XmlNode root = xmlnode[0].FirstChild;
		   for(int i=0;i<xmlnode[0].ChildNodes.Count;i++) // One by Xbox	
		   {
				XmlAttributeCollection xmlattrc = root.Attributes;
				Console.Write("Id: {0}\tDefault: {1}\tXboxName: {2}\n",  
							xmlattrc[0].Value, xmlattrc[1].Value, xmlattrc[2].Value);
				//Display the contents of the child nodes.
				if (root.HasChildNodes)
				{
				Console.WriteLine("In Xbox ChildNodes.Count: {0}", root.ChildNodes.Count);
				for (int j=0; j<root.ChildNodes.Count; j++)
				{
					Console.WriteLine("Name: {0}\tValue: {1}", root.ChildNodes[j].Name, root.ChildNodes[j].InnerText);
				}
			}
			Console.WriteLine();
			root = root.NextSibling;
		   }
		} 
		
		public bool GetGlobalCacheSaveManager()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("CacheSaveManager");
			int i;
			bool boolVal = false;
			for (i=0; i < xmlnode.Count; i++)
			{   
				#if (DEBUG)
			  		Console.WriteLine("Name: {0}\tValue: {1}", xmlnode[i].Name, xmlnode[i].InnerText);
			  	#endif
				boolVal = System.Convert.ToBoolean(xmlnode[i].InnerText);
			} 
			return boolVal;
		}

		public bool GetGlobalCacheTitle()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("CacheTitle");
			int i;
			bool boolVal = false;
			for (i=0; i < xmlnode.Count; i++)
			{   
			  	#if (DEBUG)
			  		Console.WriteLine("Name: {0}\tValue: {1}", xmlnode[i].Name, xmlnode[i].InnerText);
			  	#endif
			  	boolVal = System.Convert.ToBoolean(xmlnode[i].InnerText);
			} 
			return boolVal;
		}

		public bool GetGlobalFtp()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("FtpVerbose");
			int i;
			bool boolVal = false;
			for (i=0; i < xmlnode.Count; i++)
			{   
				#if (DEBUG)
			  		Console.WriteLine("Name: {0}\tValue: {1}", xmlnode[i].Name, xmlnode[i].InnerText);
			  	#endif 
				boolVal = System.Convert.ToBoolean(xmlnode[i].InnerText);
			} 
			return boolVal;
		}

		public ArrayList GetAllXboxName()
		{
		XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Connection");
		#if (DEBUG)
			Console.WriteLine("They are {0} Connection.", xmlnode[0].ChildNodes.Count);
		#endif 
		XmlNode root = xmlnode[0].FirstChild;
		ArrayList xboxlist = new ArrayList();
		   for(int i=0;i<xmlnode[0].ChildNodes.Count;i++) // One by Xbox	
		   {
			XmlAttributeCollection xmlattrc = root.Attributes;
			#if (DEBUG)
				Console.Write("Id: {0}\tDefault: {1}\tXboxName: {2}",  
								xmlattrc[0].Value, xmlattrc[1].Value, xmlattrc[2].Value);
			#endif
			xboxlist.Add(xmlattrc[2].Value);
		/*	if (root.HasChildNodes)
			{
			Console.WriteLine("ChildNodes.Count: {0}", root.ChildNodes.Count);
			Console.WriteLine("Name: {0}\tValue: {1}", root.ChildNodes[0].Name, 
								root.ChildNodes[0].InnerText);
			}
		*/	Console.WriteLine();
			root = root.NextSibling;
		   }
		   return xboxlist;
		}

		public string GetDefaultXboxName()
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Connection");
			Console.WriteLine("Here is the list of Connection: {0}\n", xmlnode[0].ChildNodes.Count);
			XmlNode root = xmlnode[0].FirstChild;
			bool boolVal = false;
			string xboxname = String.Empty;
		   	for(int i=0;i<xmlnode[0].ChildNodes.Count;i++) // One by Xbox	
		   	{
				XmlAttributeCollection xmlattrc = root.Attributes;
				Console.Write("Id: {0}\tDefault: {1}\tXboxName: {2}\n", 
								xmlattrc[0].Value, xmlattrc[1].Value, xmlattrc[2].Value);
				boolVal = System.Convert.ToBoolean(xmlattrc[1].Value);
				xboxname = xmlattrc[2].Value;
				if (root.HasChildNodes & boolVal)
				{
				/*	Console.WriteLine("ChildNodes.Count: {0}", root.ChildNodes.Count);
					Console.WriteLine("Name: {0}\tValue: {1}", root.ChildNodes[0].Name, 
										root.ChildNodes[0].InnerText);
				*/	return xboxname;
				}
			Console.WriteLine();
			root = root.NextSibling;
		   }
		   return xboxname;
		}
		
		public void GetFtpConfigForXboxNamed(string xboxname)
		{
			XmlNodeList xmlnode = xmldoc.GetElementsByTagName("Connection");
			//Console.WriteLine("They are {0} Connection.", xmlnode[0].ChildNodes.Count);
			XmlNode root = xmlnode[0].FirstChild;
			for(int i=0;i<xmlnode[0].ChildNodes.Count;i++) // One by Xbox	
			{
				XmlAttributeCollection xmlattrc = root.Attributes;
				if (root.HasChildNodes & xmlattrc[2].Value.Equals(xboxname))
				{
					#if (DEBUG)
						Console.Write("Id: {0}\tDefault: {1}\tXboxName: {2}\n", 
										xmlattrc[0].Value, xmlattrc[1].Value, xmlattrc[2].Value);
					#endif
					defaut = System.Convert.ToBoolean(xmlattrc[1].Value);
					id = System.Convert.ToInt32(xmlattrc[0].Value);
					for (int j=0; j<root.ChildNodes.Count; j++)
					{
						#if (DEBUG)
							Console.WriteLine("Name: {0}\tValue: {1}", root.ChildNodes[j].Name, 
									root.ChildNodes[j].InnerText);
						#endif
						if (root.ChildNodes[j].Name.Equals("IP")) 
							IP = root.ChildNodes[j].InnerText;
						if (root.ChildNodes[j].Name.Equals("Port")) 
							Port = Convert.ToInt32(root.ChildNodes[j].InnerText);
						if (root.ChildNodes[j].Name.Equals("User")) 
							User = root.ChildNodes[j].InnerText;
						if (root.ChildNodes[j].Name.Equals("Pass"))
							Password = root.ChildNodes[j].InnerText;
						if (root.ChildNodes[j].Name.Equals("Directory")) 
							Dir = root.ChildNodes[j].InnerText;	
						if (root.ChildNodes[j].Name.Equals("Xbmc")) 
							XBMCDir = root.ChildNodes[j].InnerText;
						if (root.ChildNodes[j].Name.Equals("Gdrive")) 
							Gdrive = Convert.ToBoolean(root.ChildNodes[j].InnerText);
					}
				}
			root = root.NextSibling;
		   }
			#if (DEBUG)
				Console.WriteLine();
			#endif
		}

		// To get the info PASS USER IP DIR PORT after GetFtpConfigForXboxNamed()
		public string Password
		{
			get { return password; }
			set { password = value; }
		}
		
		public string User
		{
			get { return username; }
			set { username = value; }
		}

		public string IP
		{
			get { return ip; }
			set { ip = value; }
		}

		public string Dir
		{
			get { return dir; }
			set { dir = value; }
		}

		public int Port
		{
			get { return port; }
			set { port = value; }
		}
		
		public bool UseGdrive
		{
			get { return Gdrive; }
			set { Gdrive = value; }
		}
		
		public string XBMCDir
		{
			get { return xbmcdir; }
			set { xbmcdir = value; }
		}
		
		public bool Defaut
		{
			get { return defaut; }
			set { defaut = value; }
		}

		/// <summary>
		///  Write default configuration values
 		/// </summary>
		public void WriteDefaultConfig()
		{
			string defaultconf =  "<?xml version=\"1.0\"?>\n" +
			"<Xbgmsharp>\n" + 
			"\t<Connection>\n" + 
  			"\t\t<Xbox ID=\"001\" Default=\"true\" Name=\"My Xbox\">\n" + 
    		"\t\t\t<IP>10.0.0.3</IP>\n" +
    		"\t\t\t<Port>21</Port>\n" + 
    		"\t\t\t<User>xbox</User>\n" + 
    		"\t\t\t<Pass>xbox</Pass>\n" + 
    		"\t\t\t<Directory>F:/,G:/Games/</Directory>\n" +
			"\t\t\t<Xbmc>E:/XBMC/default.xbe</Xbmc>\n" +
    		"\t\t\t<Gdrive>false</Gdrive>\n" +
  			"\t\t</Xbox>\n" + 
			"\t</Connection>\n" +
			"\t<Global>\n" +
			"\t\t<CacheTitle>false</CacheTitle>\n" +
			"\t\t<FtpVerbose>true</FtpVerbose>\n" +
			"\t\t<CacheSaveManager>true</CacheSaveManager>\n" +
			"\t</Global>\n" +
			"</Xbgmsharp>\n"; 
			
			StreamWriter outputConfstream = new StreamWriter(XmlFile);
			outputConfstream.Write(defaultconf);
			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
			#if (DEBUG)
				Console.WriteLine(defaultconf);
			#endif
		}

		/// <summary>
		///  Write configuration values
 		/// </summary>
		public void WriteConfig(string conf)
		{	
			StreamWriter outputConfstream = new StreamWriter(XmlFile);
			outputConfstream.Write(conf);
			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
			#if (DEBUG)
				Console.WriteLine(conf);
			#endif
		}
		
} // Class

} // namespace
