/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/10/25 KaYa
/// first release
///
/// </summary>


/// <summary>
/// I translate xbiso code into C#
/// So here is the all xdvdfs (xbox iso) format
/// directly to the xbox via ftp 
/// </summary>
namespace Xbgm.Xiso
{
using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using EnterpriseDT.Net.Ftp;
	
	// This class support
	// *Standard FTP upload xiso
	// *FTP Avalaunch Boost MODE
	// *HDD extract
	class XisoExtractClass2
	{
		// Event send to the Main GUI
		public event EventHandler EventUpdated;
		
		// Standard FTP 
		private FTPClient ftp = null;
		// Data Boost mode
		private TcpClient client = null;
		private NetworkStream streamnetwork = null;
		// File HDD
		private BinaryWriter writerfile = null;
		
		// List of xbox extract action
		public enum ExtractISO { none = 0, hdd, ftpavalaunch, ftp};
		public ExtractISO ISOAction;
		
		// The dirent structure of a xiso
		public struct dirent
		{
		 public long	ltable;				//left entry
		 public long	rtable;				//right entry
		 public long	sector;				//sector of file
		 public long	size;				//size of file
		 public int		attribs;			//file attributes
		 public int		fnamelen;			//filename lenght
		 public string 	fname;				//filename
		 //public long	pad;				//padding (unused)
		}

		const string HEADERDATA = "MICROSOFT*XBOX*MEDIA";
		const int	 HEADERSIZE	= 20;
		const int	 HEADEROFF	= 0x10000;
		const int	 BUFFERSIZE	= 0x40000; //256k buffer
		 
		FileStream xisofs; //File Handling xiso
		StreamReader xisoReader; //Stream reader xiso

	/*	// TEST LIST TO FILE
		FileStream FileListWriter; //File Handling xiso
		StreamWriter xisoFileList; //Stream reader xiso
	*/
		public int Nbfiles = 0;
		public int Nbdir = 0;
		
		public string xisofilename = null;
		public bool docontinue = true;
		
		// Stats
		public string currentfile = null;
		public double currentsize = 0;	
		public double sendfile = 0;
		public double sendsize = 0;
		public double totsendsize = 0;
		public double sendsizefile = 0;
		public double Batchsendsizefile = 0;
		
		// TEST
		public string xboxdir2;
		public string gamedir2;
		public string IP2;
		public int port2;
		public string user2;
		public string pass2;
		public string dir2;
		
		// Action 
		public bool hdd = false;
		public bool actionftp = false;
				
		// File/Dir list of the xiso BOOST MODE
		ArrayList FileDirlist = new ArrayList(); 

		/// <summary>
		///  Check the header of the xiso.
		///  If ok go trought is not return
 		/// </summary>
		public void DoBackgroundWork(string xisofile, string xboxdir, string gamedir, 
		                       string IP, int port, string user, string pass, string dir)
		{
 			xisofilename = xisofile;
 			xboxdir2 = xboxdir;
			gamedir2 = gamedir;
			IP2 = IP;
			port2 = port;
			user2 = user;
			pass2 = pass;
			dir2 = dir;
			extractiso();
 		}
 		
 		//public void extractiso(string xisofile, string xboxdir, string gamedir, 
		//                       string IP, int port, string user, string pass, string dir)
		public void extractiso()
		{

			//Console.WriteLine("Start ISO extraction: [" + xisofile + "]");
			//Console.ReadLine();
			//xisofilename = xisofile; //TEST

	        //xisofs  = new FileStream(xisofile, FileMode.Open,
	        xisofs  = new FileStream(xisofilename, FileMode.Open,
	                             	FileAccess.Read);
	        // Create a character reader.
	        xisoReader = new StreamReader(xisofs);
			
			// init stat var
			sendsize = 0;
			sendfile = 0;
			sendsizefile = 0;
			FileDirlist.Clear();
		/*	// TEST LIST TO FILE
			FileListWriter = new FileStream(@"J:\xbox\FileList.txt", FileMode.CreateNew);
			xisoFileList = new StreamWriter(FileListWriter);
		*/	
			if(hdd)
			{
				Directory.SetCurrentDirectory(xboxdir2); //TEST 2
				// Create and change to Game directory
				Directory.CreateDirectory(gamedir2); //TEST 2
				Directory.SetCurrentDirectory(gamedir2); //TEST 2
			}

	        // Set the StreamReader file pointer to the Beginning.
	        xisoReader.BaseStream.Seek( HEADEROFF, SeekOrigin.Begin);
			byte[] bufheader = new byte[20];
			int size = xisoReader.BaseStream.Read(bufheader, 0, bufheader.Length);

			if(size != 0)
			{					
				string s = System.Text.Encoding.ASCII.GetString(bufheader,0,HEADERSIZE);
				bufheader = null;
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error file doesnt appear to be a xbox iso image");
					return;
				}
				//Sector that root directory table resides in
				byte[] buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				long sectorroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Sector root directory ["+ sectorroot + "]");
				#endif
				//Size of root directory table in bytes
				buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				int sizeroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Size root directory ["+ sizeroot + "]");
				#endif
				//discard FILETIME structure representing image creation time
				xisoReader.BaseStream.Seek( 8, SeekOrigin.Current);
				//discard unused
				xisoReader.BaseStream.Seek( 0x7c8, SeekOrigin.Current);
				buf = new byte[20];
				size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
				s = System.Text.Encoding.ASCII.GetString(buf,0,buf.Length);
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error possible corruption?");
					return;
				}
				//Done With HEADER
				buf = null;
				s = null;
				if(hdd)
				{
					ISOAction = ExtractISO.hdd;
					handling(sectorroot*2048, (int)sectorroot);
					Directory.SetCurrentDirectory(@"..");
				}
				else
				{
					ISOAction = ExtractISO.ftpavalaunch;
//					FileDirlist.Add("D," + xboxdir + gamedir);
//					handlingftplist(sectorroot*2048, (int)sectorroot, xboxdir + gamedir, xboxdir + gamedir);
				}
				if(!hdd)
				{
					try 
	  				{					
					/*	xisoFileList.Flush();
						xisoFileList.Close();
	  				*/	
//	  					#if ( DEBUG )
//							Console.WriteLine("Count:" + FileDirlist.Count);
//	  					#endif
//<<<<<<< xisothread2.cs
						//ftp = new FTPClient(IP, port); TEST
						ftp = new FTPClient(IP2, port2);
					
						//>>>>>>> 1.2//=======
						//#if ( DEBUG)
						//ftp = new FTPClient(IP, port);
						
						#if (DEBUG)
							ftp.DebugResponses(true);
						#endif
						ftp.Login(user2, pass2); //test 2
						ftp.System();
						ftp.TransferType = FTPTransferType.BINARY;
						ftp.ConnectMode = FTPConnectMode.ACTIVE;
						//Console.ReadLine();
						// Buffer to store the response bytes.
						Byte[] data = new Byte[256];
						if (ISOAction == ExtractISO.ftpavalaunch) 
						{	// Need clean if it work with unleashx
							//if (ftp.Site("FREEROOTSPACEDISABLE") == true) // Use Avalaunch
							// New XBGM# 0.9.0.8
							string dash = ftp.System();
							if (dash.StartsWith("UNIX emulation by Avalaunch"))
								ISOAction = ExtractISO.ftpavalaunch;
							else if(dash.StartsWith("UNIX emulated by FileZilla"))
								ISOAction = ExtractISO.ftp;
							else if(dash.StartsWith("UNIX emulated by UnleashX"))
								ISOAction = ExtractISO.ftpavalaunch;
							else 
								ISOAction = ExtractISO.ftp;
							if (ISOAction == ExtractISO.ftpavalaunch)
							{
								actionftp = true; // ProgessDialog title
								//FileDirlist.Add("D," + xboxdir + gamedir); //TEST
								FileDirlist.Add("D," + xboxdir2 + gamedir2);
								//handlingftplist(sectorroot*2048, (int)sectorroot, xboxdir + gamedir, xboxdir + gamedir);  //TEST 2
								 handlingftplist(sectorroot*2048, (int)sectorroot, xboxdir2 + gamedir2, xboxdir2 + gamedir2);
								#if ( DEBUG )
									Console.WriteLine("Count:" + FileDirlist.Count);
	  							#endif
	  					
								ftp.Site("BOOST SUPPORTED");
								// NB entry in list i create. but should be NbFILES + NbDIR + 1GameDIR 
								ftp.Site("BOOST START UPLOAD " + FileDirlist.Count);
								//Console.ReadLine();
								// Create the data steam for Boost mode
								int dataport = ftp.FileList(FileDirlist);
								//Console.ReadLine();						
								//client = new TcpClient(IP, dataport); //TEST
								client = new TcpClient(IP2, dataport);
								streamnetwork = client.GetStream();

								handling(sectorroot*2048, (int)sectorroot);
							/*  // String to store the response ASCII representation.
							    String responseData = String.Empty;
							
							    // Read the first batch of the TcpServer response bytes.
							    Int32 bytes = stream.Read(data, 0, data.Length);
								responseData = System.Text.Encoding.ASCII.GetString(data, 0, bytes);
								#if ( DEBUG)
			  						Console.WriteLine("Received: {0}", responseData);         
								#endif
							*/	

								data = System.Text.Encoding.ASCII.GetBytes("QUIT");
			  					streamnetwork.Write(data, 0, data.Length);
								client.Close(); 
							
							}
							else
							{
								// Standard FTP (EvolutionX, XBMC)
								//Console.ReadLine();
								ISOAction = ExtractISO.ftp;
							/*	ftp.Chdir(xboxdir);
								ftp.Mkdir(gamedir);
								ftp.Chdir(gamedir);
							*/	ftp.Chdir(xboxdir2);
								ftp.Mkdir(gamedir2);
								ftp.Chdir(gamedir2);
								Console.WriteLine("You are not using Avalaunch");
								//Console.ReadLine();
								handling(sectorroot*2048, (int)sectorroot);
							}

						}
						ftp.QuitXbox();
	  					data = null;
	  					ftp = null;
	  					client = null;
	  					streamnetwork = null;
	  					//login.Close();
					} 
					catch (ArgumentNullException e) 
					{
					   Console.WriteLine("ArgumentNullException: {0}", e);
					} 
					catch (SocketException e) 
					{
					  Console.WriteLine("SocketException: {0}", e);
					}
					catch (Exception e)
					{
						#if (DEBUG)
							Console.WriteLine("Exception (in xisothread2): " + e.Message);
						#endif
						throw e;
					}
				}	
			}
			
			Int64 tmpsizemb = (Int64)xisofs.Length;
			#if ( DEBUG)
				Console.WriteLine("End of archive size:" +  (tmpsizemb>>=20) + " file:" + Nbfiles + " nbdir:" + Nbdir);
			#endif

			xisoReader.Close();
			xisofs.Close();
			xisoReader = null;
			xisofs = null;
			System.GC.Collect();
		// End extractiso
		}
	
		#region FTPList
		/// <summary>
		/// Go trought the xiso to get info for extracting the file
		/// This make the FTP FIle/Dir list for avalaunch dashboard
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void handlingftplist(Int64 offset, Int64 dtable, string fullpath, string oldpath)
		{
			dirent cur = new dirent();
			string msg = null;
			
			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif
				
			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if((cur.fname != null) && (cur.attribs == 16)) // attribs is a DIR
			{
				#if ( DEBUG)
					Console.WriteLine("Creating directory ["  + cur.fname + "]");
				#endif
				// Then get into it...
				oldpath = fullpath;
				fullpath = fullpath + @"\" + cur.fname;
				msg = @"D," + fullpath;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
				//Nbdir++;
				//Console.WriteLine("Fullpath: ["  + fullpath + "] Oldpath: [" + oldpath + "]");
				//Console.ReadLine();
				// Call back handling
				handlingftplist(cur.sector*2048, (Int64)cur.sector, fullpath, oldpath);
				fullpath = oldpath;
				msg = @"D," + fullpath;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
			}
			else
			{
				msg = @"F," + cur.fname + "," + cur.size;
				FileDirlist.Add(msg);
				//xisoFileList.WriteLine(msg);
				#if  ( DEBUG )
					Console.WriteLine(msg);
				#endif
				//Console.ReadLine();
			}	
			
		    if(cur.rtable != 0)
		    {
		    	//Console.WriteLine("rtable" + cur.sector + "==" + cur.rtable);
		        handlingftplist(dtable*2048+(cur.rtable*4), dtable, fullpath, oldpath);
		    }
		    if (cur.ltable != 0)
		    {
		    	//Console.WriteLine("ltable" + cur.sector + "==" + cur.ltable);
		      	handlingftplist(dtable*2048+(cur.ltable*4), dtable, fullpath, oldpath);			
		    }		
		    msg = null;
		  //End handling
		}
		#endregion
		
		/// <summary>
		/// Go trought the xiso to get info 
		/// for extracting the file to correct stream (file or network).
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void handling(Int64 offset, Int64 dtable)
		{
			if (docontinue == false) {
				#if (DEBUG)
					Console.WriteLine("Cancel");
				#endif
				//Console.ReadLine();
				goto Finish;
			}
			dirent cur = new dirent();

			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif
				
			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if((cur.fname != null) && (cur.attribs == 16)) // attribs is a DIR
			{
				// Nothing to do with Boost mode
				// it has allready been create prevously
				if (ISOAction == ExtractISO.ftp)
				{
					// Create FTP the directory
					// Then get into it...
					ftp.Mkdir(cur.fname);
					ftp.Chdir(cur.fname);
				}
				else if (ISOAction == ExtractISO.hdd)
				{	
					// Create the directory
					// Then get into it...
					Directory.CreateDirectory(cur.fname);
					Directory.SetCurrentDirectory(cur.fname);
				}
				// Call back handling
				handling(cur.sector*2048, (Int64)cur.sector);
				if (ISOAction == ExtractISO.ftp)
					ftp.Chdir("..");
				else if (ISOAction == ExtractISO.hdd)
					Directory.SetCurrentDirectory(@"..");
			}
			// Send the file
			else
			{
				currentfile = cur.fname + " [" + (cur.size/1024) + " KB]";
				totsendsize = (int)cur.size;
				sendsize = 0;				
				extract(cur);
				sendfile++;
				sendsizefile += (double)cur.size;
				Batchsendsizefile += (double)cur.size;
				
				// Update after sending
				if(this.EventUpdated != null)
					this.EventUpdated(null, null); //TEST 2
				
				#if ( DEBUG)
					Console.WriteLine("Sending ["+ cur.fname + "] " + sendfile + " of " + Nbfiles);
				#endif
			}	
			
		    if(cur.rtable != 0)
		        handling(dtable*2048+(cur.rtable*4), dtable);
		    if (cur.ltable != 0)
		      	handling(dtable*2048+(cur.ltable*4), dtable);

		 Finish: return;
		  //End handling
		}


		/// <summary>
		/// Extract a file on the Xbox by FTP or on HDD
		/// </summary>
		/// <param name="cur">The current dirent structure of a file</param>
		private bool extract(dirent cur)
		{
			// Go to the right place
			xisoReader.BaseStream.Seek(cur.sector*2048, SeekOrigin.Begin);

			if (ISOAction == ExtractISO.hdd)
			{
				// Create the destination file
				System.IO.FileStream streamfile = new System.IO.FileStream(cur.fname, 
	                                                    System.IO.FileMode.Create);
				writerfile = new BinaryWriter(streamfile);
			}
			
			// Create buffer
			int chunksize = 4096;
			byte[] chunk = new byte[chunksize];
			int size = (int)cur.size;
			bool start = true;
			
			int updateCounter = 0;
			
			// read from stream iso & write to file in chunks
			while(size > 0)
			{
				//Console.WriteLine("Size =[" + size +"]");
				if (size > chunksize)
				{
					size -= chunksize;
					sendsize += chunksize;
					xisoReader.BaseStream.Read(chunk, 0, chunksize);
					if (ISOAction == ExtractISO.ftpavalaunch)
						streamnetwork.Write(chunk, 0, chunksize);
					else if (ISOAction == ExtractISO.ftp)
					{
						if (start == true)
						{
							start = false;
							ftp.PutDataSize(chunk, cur.fname, chunksize, true, false);
						}
						else
							ftp.PutDataSize(chunk, cur.fname, chunksize, false, false);
					}
					else if (ISOAction == ExtractISO.hdd)
						writerfile.Write(chunk, 0, chunksize);
				}
				else
				{
					xisoReader.BaseStream.Read(chunk, 0, size);
					if (ISOAction == ExtractISO.ftpavalaunch)
						streamnetwork.Write(chunk, 0, size);
					else if (ISOAction == ExtractISO.ftp)
					{
						if (start == true)
						{
							start = false;
							ftp.PutDataSize(chunk, cur.fname, size, true, true);
						}
						else
							ftp.PutDataSize(chunk, cur.fname, size, false, true);
					}
					else if (ISOAction == ExtractISO.hdd)
						writerfile.Write(chunk, 0, size);
					size -= size;
					sendsize += size;
				}
				
				updateCounter++;

				// Limit update frequency...
				// chunk = 4096b
				//   => Update every 1024*4096b = 4096kb = 4Mb 
				if( updateCounter > 1024 && this.EventUpdated != null)
				{
					updateCounter = 0;
					this.EventUpdated(null, null);
				}

			}
			
			sendsize = size;
			chunk = null;

			if (ISOAction == ExtractISO.hdd)
			{
				// Close the destination file
				writerfile.Close();
			}
			return true;
		}
		
	}
}
