/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/08 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using System.IO;
using Gtk;
using Gdk;
	
	/// <summary>
	/// Description of MyChooserDialog.
	/// </summary>
	public class MyChooserDialog
	{
 		private FileChooserDialog chooser;
 		//private FileSelection fDlg;
		private Gtk.Window mainwindow;
		private string Name;

		public MyChooserDialog(Gtk.Window gtkwindow)
		{
			this.mainwindow = gtkwindow;		
			/* Deprecated 
			FileSelection fDlg = new FileSelection("Choose a ISO file.");
			fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
			int nRc = fDlg.Run();
			fDlg.Hide();
			*/
		}
		
		public MyChooserDialog()
		{

		}
		
		public ResponseType OpenFileDialog (string msg)
		{
			chooser = new FileChooserDialog (msg, mainwindow,
									FileChooserAction.Open, 
									Stock.Cancel, ResponseType.Cancel, Stock.Open, ResponseType.Ok);
			chooser.SelectMultiple = false;
			FileFilter myfilter = new FileFilter();
			myfilter.Name = "Xbox iso";
			//myfilter.Name = "Xbox iso & archive";
			myfilter.AddPattern("*.iso");
			/*
			myfilter.AddPattern("*.zip");
			myfilter.AddPattern("*.rar");
			myfilter.AddMimeType("application/bzip2");
			myfilter.AddMimeType("application/x-bzip2");
			myfilter.AddMimeType("application/zip");
			myfilter.AddMimeType("application/x-zip");
			myfilter.AddMimeType("multipart/x-zip");
			myfilter.AddMimeType("application/rar");
			myfilter.AddMimeType("multipart/x-rar");
			*/
			myfilter.AddMimeType("application/x-isoview");
			chooser.AddFilter(myfilter);
			ResponseType response = (ResponseType) chooser.Run();
			if (response == ResponseType.Ok) {
				this.Name = chooser.Filename;
				#if ( DEBUG )
					Console.WriteLine("FileChooserDialog filename = '{0}'",  chooser.Filename);
				#endif
			} else {
				this.Name = "";
				#if ( DEBUG )
					Console.WriteLine("FileChooserDialog response = '{0}'", response);
				#endif
			}
			return response;
		}

		public ResponseType SaveAsDialog (string msg)
		{
			chooser = new FileChooserDialog (msg, mainwindow,
									FileChooserAction.Save, 
									Stock.Cancel, ResponseType.Cancel, Stock.SaveAs, ResponseType.Ok);
			chooser.SelectMultiple = false;
			ResponseType response = (ResponseType) chooser.Run();
			if (response == ResponseType.Ok) {
				this.Name = chooser.Filename;
				#if ( DEBUG )
					Console.WriteLine("SaveChooserDialog filename = '{0}'",  chooser.Filename);
				#endif
			} else {
				this.Name = "";
				#if ( DEBUG )
					Console.WriteLine("SaveChooserDialog response = '{0}'", response);
				#endif
			}
			return response;
		}
		
		public ResponseType SelectDirDialog (string msg)
		{
			chooser = new FileChooserDialog (msg, mainwindow,
									FileChooserAction.SelectFolder, 
									Stock.Cancel, ResponseType.Cancel, Stock.Open, ResponseType.Ok);
			chooser.SelectMultiple = false;
			ResponseType response = (ResponseType) chooser.Run();
			if (response == ResponseType.Ok) {
				this.Name = chooser.Filename;
				#if ( DEBUG )
					Console.WriteLine("DirChooserDialog filename = '{0}'",  chooser.Filename);
				#endif
			} else {
				this.Name = "";
				#if ( DEBUG )
					Console.WriteLine("DirChooserDialog response = '{0}'", response);
				#endif
			}
			return response;
		}
		
		public void Close()
		{
			Hide();
			chooser.Destroy();
			chooser = null;
		}
		
		public void Hide()
		{
			chooser.Hide ();
		}
		
		public string FileName
		{
			get { return Name; }
		}
	}
}
