/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/17 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using Gtk;
using Gdk;
using Glade;
using RecursiveFileExplorer;

	/// <summary>
	/// Description of Upload dir Galde Dialog.	
	/// </summary>
	public class UploadDirGladeDialog
	{
		private Popup popup;
		private FileExplorer FileExplorer;
		private TreeIter iter;
		private TreeIter iter2;
		private int Response;
		private int Index = -1;
		public Config config;
		
		public UploadDirGladeDialog(Xbgm.Config config, Gtk.Window parent) 
		{ 
			#if (DEBUG)
				Console.WriteLine("In UploadDirGlade::UploadDirGladeDialog");
			#endif
			this.config = config;
			this.popup = new Popup(parent);
			CreateGui();
		}
		
		[Glade.Widget] Gtk.Dialog 		dialog1;
		[Glade.Widget] Gtk.Button 		okbutton1;
		[Glade.Widget] Gtk.Button 		cancelbutton1;
		[Glade.Widget] Gtk.Button 		button1;
		[Glade.Widget] Gtk.Label 		label10;
		[Glade.Widget] Gtk.Label 		label9;
		[Glade.Widget] Gtk.Label 		label14;
		[Glade.Widget] Gtk.Entry 		entry1;
		[Glade.Widget] Gtk.ComboBox		combobox1;
		[Glade.Widget] Gtk.ComboBox		combobox2;
		
		public void CreateGui() 
		{
		 try{
				Glade.XML gxml = new Glade.XML (null, "uploaddir.glade", "dialog1", null);
				dialog1 = (Gtk.Dialog) gxml["dialog1"];
				okbutton1 = (Gtk.Button) gxml["okbutton1"];
				button1 = (Gtk.Button) gxml["button1"];
				label10 = (Gtk.Label) gxml["label10"];
				label9 = (Gtk.Label) gxml["label9"];
				label14 = (Gtk.Label) gxml["label14"];
				cancelbutton1 = (Gtk.Button) gxml["cancelbutton1"];
				combobox1 = (Gtk.ComboBox) gxml["combobox1"];
				combobox2 = (Gtk.ComboBox) gxml["combobox2"];
				entry1 = (Gtk.Entry) gxml["entry1"];
			   
				gxml.Autoconnect (this);
	
				okbutton1.Clicked += new EventHandler (Connect_Action);
				button1.Clicked += new EventHandler (Browse);
				cancelbutton1.Clicked += new EventHandler (Dialog_Cancel);
				
			   	dialog1.Title = "Upload Directory via Boost Mode";
			   	dialog1.Icon = new Pixbuf(null, "xbgmicon.png");
			   	
			   	//Make Xbox List
			   	ListStore liststore = new Gtk.ListStore (typeof(string));
			   	combobox1.Model = liststore;
				CellRendererText  cell = new Gtk.CellRendererText();
				combobox1.PackStart(cell, true);
 				combobox1.AddAttribute(cell, "text", 0);
 				for (int i = 0; i< config.xboxs.Length; i++) {
 					combobox1.AppendText(config.xboxs[i].name);
 				}
			   	
			   	//Make Drive list
			   	liststore = new Gtk.ListStore (typeof(string));
			   	combobox2.Model = liststore;
				cell = new Gtk.CellRendererText();
				combobox2.PackStart(cell, true);
 				combobox2.AddAttribute(cell, "text", 0);
			   	combobox2.AppendText("C");
			   	combobox2.AppendText("E");
			   	combobox2.AppendText("F");
			   	combobox2.AppendText("G");
			   	
			   	label10.Text = "";
				label9.Text = "";
				label14.Text = "";
			}
			catch(Exception ex){
					Console.WriteLine("Error in UploadDirGlade::CreateGui" + ex.Message);
			}
		}
		
		private void Browse (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("In UploadDirGlade::Browse");
			#endif
			MyChooserDialog chooserdialog = new MyChooserDialog();
			ResponseType response = chooserdialog.SelectDirDialog("Select a Source Directory.");
			#if (DEBUG)
			Console.WriteLine("FileChooserDialog Dir = '{0}'", chooserdialog.FileName);
			#endif
			if ((response == ResponseType.Ok) &&  chooserdialog.FileName.Length != 0) 
			{
				chooserdialog.Hide();
				//Create FileExplorer object and search root directory
				FileExplorer = new FileExplorer( chooserdialog.FileName, true);
				//Access and bind ArrayList to DataSource property of a Data Control
				//list = FileExplorer.FileList;
				//FileExplorer.FileList.Count;
				//Console.WriteLine("Nb element :{0}", FileExplorer.FileList.Count);
				Int64 Size = 0;
				foreach (FileData FileData in FileExplorer.FileList) {
					Size += FileData.Length;		
				}
				//Console.ReadLine();
				label10.Text = chooserdialog.FileName;
				label9.Text = FileExplorer.FileList.Count.ToString();
				label14.Text = (Size/1048576).ToString(".##") + " Mo"; // 1048576 = 1024 * 1024
				entry1.Text = label10.Text.Substring(label10.Text.LastIndexOf(System.IO.Path.DirectorySeparatorChar)+1);
			}
			chooserdialog.Close();
			chooserdialog = null;
		}
		
		private void Connect_Action (object o, EventArgs args) 
		{
			try 
			{
				#if (DEBUG)
					Console.WriteLine("In UploadDirGlade::Connect_Action");
				#endif
				if (label10.Text.Length == 0) {
					popup.Warning("You need to select a directory");
					return;
				}
				try 
				{
				combobox1.GetActiveIter(out iter);
				//Console.WriteLine (combobox1.Model.GetValue(iter, 0).ToString());
	
				combobox2.GetActiveIter(out iter2);
				//Console.WriteLine (combobox2.Model.GetValue(iter2, 0).ToString());
				Console.WriteLine("Sending [{0}] to [{1}] with xbox [{2}]", label10.Text,
				                	combobox2.Model.GetValue(iter2, 0).ToString() + ":/",
				               		combobox1.Model.GetValue(iter, 0).ToString());
				}
				catch (System.Exception e)
				{
					popup.Warning("You need to select 1 xbox and 1 drive");
					return;
				}

				Index = config.GetIndexByName(combobox1.Model.GetValue(iter, 0).ToString());
				//Response = (int)ResponseType.Ok;
				string dest = combobox2.Model.GetValue(iter2, 0).ToString() + ":/" + entry1.Text;
				string source = label10.Text;
				#if ( DEBUG )
				Console.WriteLine("Sending [{0}] to [{1}] with xbox [{2}]", source,
				                	dest,
				                	config.xboxs[Index].name);
				#endif
				//Console.ReadLine();
				dialog1.Hide ();
				ProgressUploadDirGlade progressuploaddirdialog = new ProgressUploadDirGlade(FileExplorer, config, Index, dest, source);
				progressuploaddirdialog.Run();
				Response = progressuploaddirdialog.Response;
				progressuploaddirdialog.Close();
				if (Response == (int)ResponseType.Ok) {
					popup.Info("Task completed successfully.\n");
				}
				progressuploaddirdialog = null;
			}
			catch (System.Exception e)
			{
				// Don't know why but i never get into that
				popup.Error("Error Uploading directory to xbox:\n" + 
		            "You may need to restart your xbox.\n");
			}
			System.GC.Collect();
		}

		private void Dialog_Cancel (object o, EventArgs args)
		{
			Response = (int)ResponseType.Cancel;
			dialog1.Hide ();
		}

		public int Run ()
		{
			dialog1.ShowAll();
			dialog1.Run();
			dialog1.Hide ();
			dialog1.Dispose ();
			return Response;
		}
		
		public void Close()
		{
			dialog1.Destroy();
		}
	}
}
