#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>
#endregion

using System;
using System.Collections;
using System.IO;
using System.Threading;
using Gtk;
using Gdk;
using GtkSharp;
using Xbgm.Xiso;
using Xbgm.Core;

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
namespace Xbgm.Gui
{

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
public class MyGui : Gtk.Window {
		const string VERSION = "0.9.1.0-26_devglade";
		const string NAME = "XBGM#";   
		const string WELCOME = ", Copyright (C) 2004-2006 KaYa <xbgm@kayaweed.net>. \nIf you have any questions, comments, or suggestions about this program, please feel free to email them to me. \nYou can always find out the latest news about XBGM# from the official website at http://xbgm.sourceforge.net/.\nXBGM# comes with ABSOLUTELY NO WARRANTY; for details, see the COPYING file. \nThis is free software, and you are welcome to redistribute it under certain conditions; for details, see the COPYING file\n";

// Info on the selected game. 4 string:  0: Name 1:xbe name 2: directory name 3: ID
		public ArrayList	CurrentGame = null;
// The XBMG configuration
		public Xbgm.Config config;
// Ftp Operations
		public FtpToXbox ftpToXbox;
// Popup message (Info & Error & Warning & Question) 
		private Popup popup;
// XisoInfoClass (get file & folders & titles and other info)
		private XisoInfoClass iso = null;
// Env OS specific
		private CheckEnvOs checkenvos;		
//	Ftp Thread
		Thread ftp_worker;
		ThreadNotify main_notify;
// Save Game Info
		public SaveInfo[] SaveInfos;

		bool deletesave = false;
		
		#region Glade Widgets
		[Glade.Widget] Gtk.Window 		window1;
		[Glade.Widget] Gtk.Image 		logo;
		[Glade.Widget] Gtk.Image 		xisologo;
		[Glade.Widget] Gtk.HBox 		transfertopionhbox;
		[Glade.Widget] Gtk.TreeView		treeview1;
		[Glade.Widget] Gtk.TreeView		treeview2;
		[Glade.Widget] Gtk.TreeView		treeview3;
		[Glade.Widget] Gtk.TreeView		treeview4;		
		// Label Manage Title
		[Glade.Widget] Gtk.Label 		labelDashboard;
		[Glade.Widget] Gtk.Label 		labelIDresult;
		[Glade.Widget] Gtk.Label 		labelSpaceresult;
		[Glade.Widget] Gtk.Label 		labelSlackresult;
		[Glade.Widget] Gtk.Label 		labelPathresult;
		[Glade.Widget] Gtk.Label 		labelAlltitlesResult;
		[Glade.Widget] Gtk.Label 		labelAllfilesResult;
		[Glade.Widget] Gtk.Label 		labelAllfoldersResult;
		[Glade.Widget] Gtk.Label 		labelAllspaceResult;
		[Glade.Widget] Gtk.Label 		labelAllslackResult;
		[Glade.Widget] Gtk.Label 		labelAllsizeResult;
		[Glade.Widget] Gtk.Label 		labelAllFreespaceResult;
		[Glade.Widget] Gtk.Label 		labelResultDriveC;
		[Glade.Widget] Gtk.Label 		labelResultDriveE;
		[Glade.Widget] Gtk.Label 		labelResultDriveF;
		[Glade.Widget] Gtk.Label 		labelResultDriveG;
		[Glade.Widget] Gtk.Label 		DriveG;
		[Glade.Widget] Gtk.CheckButton	DLicons;
		// Label Load ISO
		[Glade.Widget] Gtk.Label 		labelR1;
		[Glade.Widget] Gtk.Label 		labelR2;
		[Glade.Widget] Gtk.Label 		labelR3;
		[Glade.Widget] Gtk.Entry 		Entrygamexbe;
		[Glade.Widget] Gtk.Entry 		Entrygamedir;
		[Glade.Widget] Gtk.Entry 		Entryxboxdir;
		[Glade.Widget] Gtk.Label 		labelnbbatchentry;
		[Glade.Widget] Gtk.Label 		labelnbbatchsize;
		[Glade.Widget] Gtk.Label 		labelnbbatchfiles;
		[Glade.Widget] Gtk.CheckButton	halticons;
		[Glade.Widget] Gtk.CheckButton	rungame;
		[Glade.Widget] Gtk.ComboBox		XboxsConnectionCombo;
		// Game Manager
		[Glade.Widget] Gtk.Button		Get;
		[Glade.Widget] Gtk.Button		Push;
		[Glade.Widget] Gtk.Button		Del;
		[Glade.Widget] Gtk.Label 		savename;
		[Glade.Widget] Gtk.Label 		nbsavegame;
		[Glade.Widget] Gtk.Label 		idsavegame;
		[Glade.Widget] Gtk.Label 		dirsavegame;
		[Glade.Widget] Gtk.Label 		localsavename;
		[Glade.Widget] Gtk.Label 		localnbsavegame;
		[Glade.Widget] Gtk.Label 		localidsavegame;
		[Glade.Widget] Gtk.Label 		localdirsavegame;
		// Log view
		[Glade.Widget] Gtk.TextView		textview;
		[Glade.Widget] Gtk.TextBuffer	buf;
		// Toolbar
		[Glade.Widget] Gtk.Toolbar		Toptoolbar;
		[Glade.Widget] Gtk.Toolbar		Gametoolbar;
		[Glade.Widget] Gtk.Toolbar		ISOtoolbar;
		[Glade.Widget] Gtk.Toolbar		Logtoolbar;
		[Glade.Widget] Gtk.Toolbar		Xboxtoolbar;
		[Glade.Widget] Gtk.Toolbar		PCtoolbar;
		// Statusbar
		[Glade.Widget] Gtk.Statusbar	statusbar;
		[Glade.Widget] Gtk.EventBox		eventbox;
		// Statusbar
		private Gtk.Label 		statuslabelconnexion;
		private Gtk.Image 		OnLineStatusImg;
		// Popup Menu
		private Gtk.Menu 		menu = null;
		private ListStore 		store = null;	
		private Gtk.TreeIter 	iter;
		private Pixbuf 			pix = null;
		// Notebook2
		private ListStore 		store2 = null;
		private Gtk.TreeIter 	iter2;
		// Notebook3
		private TreeStore 		store3 = null;
		private Gtk.TreeIter 	iter3;
		private TreeStore 		store4 = null;
		private Gtk.TreeIter 	iter4;
		// Tooltips
		public  Tooltips tooltips;
		#endregion
	
	/// <summary>
	/// Create the Main GUI
	/// </summary>
	public MyGui () : base ("MyGui")
	{
	 try{
			#if (DEBUG)
				Console.WriteLine(NAME + VERSION);
			#endif
			// Check OS for configuration
			checkenvos = new CheckEnvOs();
			// Init the XBGM configuration
			config = new Config();
			// Active Connection & G Drive	
			config.SetDefaultToActive();
			int Index = config.GetIndexActive();

			CreateGui();
			
			this.popup = new Popup((Gtk.Window) this.window1.Toplevel);

			this.ftpToXbox = new FtpToXbox(ref config, popup);
			this.ftpToXbox.notifyViews += new Notifier(this.updateLabelResults);
			this.ftpToXbox.EventUpdated += new EventHandler(EventFtpThread);
			this.ftpToXbox.loggerViews += new Logger(this.LogMsg);
			this.ftpToXbox.StatusViews += new UpdateStatus(this.OnLine);
			
			// Init CurrentGame List
			CurrentGame = new ArrayList();
			// Init the Xiso Info class
			iso = new XisoInfoClass();
			// Show welcome message
			AppendText(NAME + " " + VERSION + " " + WELCOME);
			// Set active Xbox in Label Active Connection
			statuslabelconnexion.Text = config.xboxs[Index].name;
			// Set active Xbox if Use G Drive
			DriveG.Visible = config.xboxs[Index].Gdrive;
			labelResultDriveG.Visible = config.xboxs[Index].Gdrive;
		}
			catch(Exception ex){
				Console.WriteLine("Glade MyGui Init error: " + ex.Message);
		}
	}

	public void CreateGui() 
	{
	 try{
			Glade.XML gxml = new Glade.XML (null, "xbgmgui.glade", "window1", null);
			#region init glade widget
			// Remove warning
			window1 = (Gtk.Window) gxml["window1"];
			logo = (Gtk.Image) gxml["logo"];
			xisologo = (Gtk.Image) gxml["xisologo"];
			transfertopionhbox = (Gtk.HBox) gxml["hbox9"];
			labelDashboard = (Gtk.Label) gxml["labelDashboard"];
			labelIDresult = (Gtk.Label) gxml["labelIDresult"];
			labelSpaceresult = (Gtk.Label) gxml["labelSpaceresult"];
			labelSlackresult = (Gtk.Label) gxml["labelSlackresult"];
			labelPathresult = (Gtk.Label) gxml["labelPathresult"];
			labelAlltitlesResult = (Gtk.Label) gxml["labelAlltitlesResult"];
			labelAllfilesResult = (Gtk.Label) gxml["labelAllfilesResult"];
			labelAllfoldersResult = (Gtk.Label) gxml["labelAllfoldersResult"];
			labelAllspaceResult = (Gtk.Label) gxml["labelAllspaceResult"];
			labelAllslackResult = (Gtk.Label) gxml["labelAllslackResult"];
			labelAllsizeResult = (Gtk.Label) gxml["labelAllsizeResult"];
			labelAllFreespaceResult = (Gtk.Label) gxml["labelAllFreespaceResult"];
			labelResultDriveC = (Gtk.Label) gxml["labelResultDriveC"];
			labelResultDriveE = (Gtk.Label) gxml["labelResultDriveE"];
			labelResultDriveF = (Gtk.Label) gxml["labelResultDriveF"];
			labelResultDriveG = (Gtk.Label) gxml["labelResultDriveG"];
			DriveG = (Gtk.Label) gxml["DriveG"];
			DLicons = (Gtk.CheckButton) gxml["DLicons"];
			Del = (Gtk.Button) gxml["Del"];
			Push = (Gtk.Button) gxml["Push"];
			Get = (Gtk.Button) gxml["Get"];
			// Label Load ISO
			labelR1 = (Gtk.Label) gxml["labelR1"];
			labelR2 = (Gtk.Label) gxml["labelR2"];
			labelR3 = (Gtk.Label) gxml["labelR3"];
			Entrygamexbe = (Gtk.Entry) gxml["Entrygamexbe"];
			Entrygamedir = (Gtk.Entry) gxml["Entrygamedir"];
			Entryxboxdir = (Gtk.Entry) gxml["Entryxboxdir"];
			labelnbbatchentry = (Gtk.Label) gxml["labelnbbatchentry"];
			labelnbbatchsize = (Gtk.Label) gxml["labelnbbatchsize"];
			labelnbbatchfiles = (Gtk.Label) gxml["labelnbbatchfiles"];
			halticons = (Gtk.CheckButton) gxml["halticons"];
			rungame = (Gtk.CheckButton) gxml["rungame"];
			// Label Save mamager
			savename = (Gtk.Label) gxml["savename"];
			nbsavegame = (Gtk.Label) gxml["nbsavegame"];
			idsavegame = (Gtk.Label) gxml["idsavegame"];
			dirsavegame = (Gtk.Label) gxml["dirsavegame"];
			localsavename = (Gtk.Label) gxml["localsavename"];
			localnbsavegame = (Gtk.Label) gxml["localnbsavegame"];
			localidsavegame = (Gtk.Label) gxml["localidsavegame"];
			localdirsavegame = (Gtk.Label) gxml["localdirsavegame"];
			// Real need init
			Toptoolbar = (Gtk.Toolbar) gxml["toolbar1"];
			Gametoolbar = (Gtk.Toolbar) gxml["toolbar2"];
			ISOtoolbar = (Gtk.Toolbar) gxml["toolbar3"];
			Logtoolbar = (Gtk.Toolbar) gxml["toolbar4"];
			Xboxtoolbar = (Gtk.Toolbar) gxml["toolbar6"];
			PCtoolbar = (Gtk.Toolbar) gxml["toolbar7"];
			statusbar = (Gtk.Statusbar) gxml["statusbar1"];
			textview = (Gtk.TextView) gxml["textview"];
			treeview1 = (Gtk.TreeView) gxml["treeview1"];
			treeview2 = (Gtk.TreeView) gxml["treeview2"];
			treeview3 = (Gtk.TreeView) gxml["treeview3"];
			treeview4 = (Gtk.TreeView) gxml["treeview4"];
			XboxsConnectionCombo = (Gtk.ComboBox) gxml["XboxsConnectionCombo"];
			#endregion
			
			gxml.Autoconnect (this);
			// Event
			// Right Click Manage Title
	 		// Connect signals for mouse button press and popup menu are in glade file!
            // Got Left clickable Manage Title
			treeview1.Selection.Changed += new EventHandler(on_List_selection);
			// Right Click Load ISO
	 		// Connect signals for mouse button press and popup menu are in glade file!
			// Got Left clickable Load ISO
			treeview2.Selection.Changed += new EventHandler(on_ISOList_selection);
			// ISO Entry Event are in glade file!
			// Click Save Manager
	 		// Connect signals for mouse button press are in glade file!
	 		treeview3.Selection.Changed += new EventHandler (on_XboxSaveGame_selection);
	 		treeview4.Selection.Changed += new EventHandler (on_PCSaveGame_selection);			
	 		
 			// Icon
			window1.Title = NAME + " " + VERSION;
			window1.Icon = new Pixbuf(null, "xbgmicon.png");
	 		pix = new Gdk.Pixbuf (null, "xbgmsharp.png");	
	        logo.FromPixbuf = pix;
 
			//init Tooltips
			tooltips = new Tooltips();

	        // Toolbar
			MyToolbar CreateToolbar = new MyToolbar (this);
			CreateToolbar.CreateTopToolbar (Toptoolbar);
			CreateToolbar.CreateGameToolbar (Gametoolbar);
			CreateToolbar.CreateISOToolbar (ISOtoolbar);
			CreateToolbar.CreateLogToolbar (Logtoolbar);
			CreateToolbar.CreateSaveXboxToolbar (Xboxtoolbar);
			CreateToolbar.CreateSavePcToolbar (PCtoolbar);

			#region Treeview1 Manage Game
			// Manage title 
			// Create the treeview containing 5 strings visible + 1 Int64 + 5 string hiden
			store = new ListStore (typeof (string),
									typeof (Int64), // size
									typeof (string),
									typeof (Int64), // nb files
									typeof (Int64), // nb folders
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string)									
								);
			treeview1.Model = store;

			// Add Colomn to treeview1
			string [] cols = {"Title", "Size MB", "Folder", "Files", "Folders", "Region",
			"ID", "Space", "Slack", "XBE", "Dir"};
			for (int i = 0; i <= 10; i++ )
			{
				TreeViewColumn column = new TreeViewColumn ();
				CellRendererText text = new CellRendererText ();
				column.Title = cols[i];
				column.Resizable = true;
				if (i == 2 || i >= 6 && i != 10) { column.Visible = false; }
				if (i == 2) { column.MinWidth = 200; }
				else if (i == 0) { column.MinWidth = 100; }
				else { column.MinWidth = 5; }
				if (i == 10 || i <= 6) { column.SortColumnId = i; }
				else { column.SortColumnId = 0; }
				column.Sizing = TreeViewColumnSizing.Autosize;
				column.PackStart (text, true);
				column.AddAttribute (text, "text", i);
				treeview1.AppendColumn(column);
			}
			cols= null;
			#endregion

			#region Treeview2 ISO
			// Load ISO
			// Create the treeview containing 6 strings visible + 5 string hide
			store2 = new Gtk.ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),									
									typeof (string),
									typeof (bool)
								);
			treeview2.Model = store2;

			string [] cols2 = {"XBE Title", "Size", "Game Folder", "Filename", "Region", 
				"Xbox Folder", "files", "folders", "xisofullfilename", "iso.totfilesize", 
				"Xbox Connection", "XISO <= v1.10"};
			for (int i = 0; i <= 11; i++ )
			{
				TreeViewColumn column = treeview2.AppendColumn (cols2[i], new CellRendererText (), "text", i);
				column.Resizable = true;
				if (i >= 6 && i <= 9) { column.Visible = false; }
				column.SortColumnId = 0;
				column.Sizing = TreeViewColumnSizing.Autosize;
			}
			cols2 = null;
			#endregion

			#region Treeview3 Xbox save manager
			// Xbox save manager
			// Create the treeview containing 4 strings visible
			store3 = new Gtk.TreeStore (//typeof (Gdk.Pixbuf), //Icon
			                            typeof (string), //Name
										typeof (string), //NB
										typeof (string), //Id
										typeof (string) // Dir
										);
			treeview3.Model = store3;
			// Add Colomn to treeview3
			string [] cols3 = {"Name","Nb", "Id", "Dir"};
			for (int i = 0; i <= 3; i++ )
			{
				TreeViewColumn column = new TreeViewColumn ();
				CellRendererText text = new CellRendererText ();
				column.Title = cols3[i];
				column.Resizable = true;
				if (i >= 1) { column.Visible = false; }
				column.SortColumnId = 0;
				column.PackStart (text, true);
				column.AddAttribute (text, "text", i);
				treeview3.AppendColumn(column);
			}
			cols3 = null;
/*
			// Add Colomn to treeview3
			string [] cols3 = {"Icon", "Name", "Nb", "Id", "Dir"};
			for (int i = 0; i <= 4; i++ )
			{
				TreeViewColumn column;
				if (i == 0)
					column = treeview3.AppendColumn (cols3[i], new CellRendererPixbuf (), "pixbuf", i);
				else
					column = treeview3.AppendColumn (cols3[i], new CellRendererText (), "text", i);
				if (i >= 2) { column.Visible = false; }
			}
			cols3 = null;
			
			// add data to the tree store
			//Gtk.Image img = new Gtk.Image (Stock.Cdrom, IconSize.Menu);
			for(int i = 0; i < 10; i++) {
				pix = new Pixbuf(null, "xbgmicon.png");
				iter3 = store3.AppendValues (pix, "toto"+i, null, null, null);
				for(int j = 0; j < 2; j++) {
					pix = new Pixbuf(null, "xbox.png");
					store3.AppendValues (iter3, pix, "No decp", "nb"+i, i.ToString(), j.ToString());
				}
			}
*/
			treeview3.ExpandAll();

			// Same as Xbox side
			store4 = new Gtk.TreeStore (typeof (string), //Name
										typeof (string), //NB
										typeof (string), //Id
										typeof (string) // Dir
										);
			treeview4.Model = store4;
			// add data to the tree store
			string [] cols4 = {"Name", "Nb", "Id", "Dir"};
			for (int i = 0; i <= 3; i++ ){
				TreeViewColumn column = treeview4.AppendColumn (cols4[i], new CellRendererText (), "text", i);
				if (i >= 1) { column.Visible = false; }
			}
			cols4 = null;
			treeview4.ExpandAll();
			#endregion

			// Log view
			buf = textview.Buffer;

			// Status bar
			statusbar.Push (1, "Xbgm# ready.");
			statusbar.Homogeneous = false;
			statuslabelconnexion = new Label(" My Xbox ");
			statuslabelconnexion.Text = " My Xbox ";
			eventbox = new EventBox ();
			eventbox.Add (statuslabelconnexion);
			eventbox.ButtonPressEvent += new ButtonPressEventHandler (OnLabelButtonPressEvent);
			tooltips.SetTip (eventbox, " Select Active Connection ", "");
			statusbar.PackStart(eventbox, false, false, 0);
			OnLineStatusImg = new Gtk.Image(Stock.No, Gtk.IconSize.SmallToolbar);
			statusbar.PackStart(OnLineStatusImg, false, false, 0);
			// END of status bar 

			window1.ShowAll();
			transfertopionhbox.Visible = false;
			labelDashboard.Visible = false;
		}
		catch(Exception ex){
			Console.WriteLine("Error (in Gladegui::MyGui::CreateGui): " + ex.Message);
		}
	}

	/// <summary>
	/// Connect the Delete Signal defined in Glade
	/// </summary>
	public void OnMyWindowDelete (object o, DeleteEventArgs args) 
	{
	    Application.Quit();
	    args.RetVal = true;
	}

		#region OnToolbarTopClicked	 
		public void OnToolbarAboutClicked()
		{
			AboutDialog about = new AboutDialog ((Gtk.Window) this.window1.Toplevel, VERSION);
			#if ( DEBUG )
				Console.WriteLine("Got AboutDialog");
			#endif	
			about.Run();
			about.Close();
			about = null;
		}
	
		public  void OnToolbarPrefClicked ()
		{
			PrefGladeDialog Pref = new PrefGladeDialog ();

			if ((int)ResponseType.Ok == Pref.Run())
			{
				config = Pref.config; // Get the modification
				//Console.WriteLine("===============\n OnToolbarPrefClicked\n");
				//config.Print();
				// Set Default Xbox active connection
				// Active Connection & G Drive
				config.SetDefaultToActive();
				int Index = config.GetIndexActive();
				// Set active Xbox in Label Active Connection
				statuslabelconnexion.Text = config.xboxs[Index].name;
				// Set active Xbox in Use G Drive
				DriveG.Visible = config.xboxs[Index].Gdrive;
				labelResultDriveG.Visible = config.xboxs[Index].Gdrive;
				this.ftpToXbox.config = config; // Set the config modification to ftpToXbox
				//Console.WriteLine("===============\n OnToolbarPrefClicked from this.ftpToXbox.config:\n");
				//this.ftpToXbox.config.Print();
			}
			Pref.Close();
			Pref = null;
		}

		public  void OnToolbarXBMCClicked()
		{
			try 
			{
				if (labelDashboard.Text.Equals("Dashboard")) {
					popup.Error("You need to check your dashboard first.\nUse Scan Titles.");
					return;
				}
				// Do xbox Stuff
				this.ftpToXbox.ActionNotOnGame(FtpToXbox.Action.xbmc);
				AppendText("Xbox Media Center Start");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in Gladegui::OnToolbarXBMCClicked): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}
		
		public  void OnToolbarShutdownClicked()
		{
			try 
			{
				// Do xbox Stuff
				ftpToXbox.ActionNotOnGame(FtpToXbox.Action.shutdown);
				AppendText("Xbox Shutdown");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in Gladegui::OnToolbarShutdownClicked): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}

		public  void OnToolbarRestartClicked()
		{
			try 
			{
				// Do xbox Stuff
				ftpToXbox.ActionNotOnGame(FtpToXbox.Action.reboot);
				AppendText("Xbox Reboot");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in Gladegui::OnToolbarRestartClicked): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}
		#endregion

		#region OnToolbarGameClicked
		public  void OnToolbarScanTitlesClicked ()
		{	
			// Clear the Game Liststore
			store.Clear();
			// Get the Game listing for the Xbox or cache			
			if (config.cachetitles)
			{
				#if ( DEBUG )
					Console.WriteLine("Use cache, parse it...");
				#endif
				AppendText("Use cache to list Xbox Game");
				// if we use cache we have a titles files and icons
				ftpToXbox.GetTitlesCached();
				if(Convert.ToInt32(ftpToXbox.gameSummary.nbTitles) < 1 ||
					ftpToXbox.gameSummary.info == null)
				{
					#if ( DEBUG )
						Console.WriteLine("Use cache but NOT Found launch FTP");
					#endif
				} else {
					updateSummary(ftpToXbox.gameSummary);
					updateLabelResultsDash(config.GetFreeSpaceActive());
					return;
				}
			}
			
			// Default case when cache is set to false
			if(Convert.ToInt32(ftpToXbox.gameSummary.nbTitles) < 1 || config.cachetitles == false)
			{
				try
				{
					// New 0.9.0.8_dbg1
					labelDashboard.Visible = true;
					if (ftpToXbox.CheckDashboard() == false) {
						if (ftpToXbox.Rootspace != null)
							updateLabelResultsDash(ftpToXbox.Rootspace);
						popup.Error(ftpToXbox.MsgError);
						labelDashboard.Text = ftpToXbox.Msg;
						return;
					}
					labelDashboard.Text = ftpToXbox.Msg;
				}
				catch (Exception ex)
				{
					#if (DEBUG)
						Console.WriteLine("Exception (in Gladegui::OnToolbarScanTitlesClicked): " + ex.Message);
					#endif
					popup.Error(ex.Message);
					return;
				}
				ThreadStart tstart = new ThreadStart (Ftp_Thread);
				ftp_worker = new Thread (tstart);

				ftp_worker.Start();
				main_notify = new Gtk.ThreadNotify (new Gtk.ReadyEvent (UpdateSummaryThread));
			}
		}

		/// <summary>
		/// Event received from FtpToXBox.	
		/// WakeUp Main thread.
		/// </summary>
		public void EventFtpThread (object sender, EventArgs args)
		{
			#if ( DEBUG )
				Console.WriteLine("In EventFtpThread");
			#endif
			main_notify.WakeupMain();
		}
		
		/// <summary>
		/// Update GUI from the main thread.
		/// Update the status bar
		/// Show what we are doing when getting game titles info
		/// </summary>
		void UpdateSummaryThread ()
		{
			#if ( DEBUG )
				Console.WriteLine("In UpdateSummaryThread");
			#endif
			if (ftpToXbox.action == FtpToXbox.Action.image)
				statusbar.Push (1 , "Getting Images....");
			else if (ftpToXbox.action == FtpToXbox.Action.scan)
				statusbar.Push (1 , "Scanning Titles....");
			else if (ftpToXbox.action == FtpToXbox.Action.allfreespace)
				statusbar.Push (1 , "Getting FreeSpace for all Drive....");
			else if (ftpToXbox.action == FtpToXbox.Action.freespace)
				statusbar.Push (1 , "Getting FreeSpace for Game Drive....");
			else if (ftpToXbox.action == FtpToXbox.Action.refresh)
				statusbar.Push (1 , "Refreshing Game Menu....");
			else if (ftpToXbox.action == FtpToXbox.Action.getbackup)
				statusbar.Push (1 , "Getting All Xbox backup....");
			else if (ftpToXbox.action == FtpToXbox.Action.scanbackup)
				statusbar.Push (1 , "Scanning Xbox backup....");
			else if (ftpToXbox.action == FtpToXbox.Action.connect) 
			{
				int Index = config.GetIndexActive();
				statusbar.Push (1 , "Connecting to " + config.xboxs[Index].name + 
				                " with IP " + config.xboxs[Index].ip + "....");
			}
			else if (ftpToXbox.action == FtpToXbox.Action.ready)
			{
				statusbar.Push (1 , "XBGM# Ready.");
				if ( ftpToXbox.gameSummary.nbTitles != 0 & ftpToXbox.Rootspace != null 
				    & ftpToXbox.Done == false) { // Scan xbox Titles
					updateSummary(ftpToXbox.gameSummary);
					updateLabelResults(ftpToXbox.Rootspace);
					ftpToXbox.Done = true;
				}
				else if (ftpToXbox.MySaveInfo != null && ftpToXbox.Done == false)
				{ // Scan Xbox Backup
					updateBackupInformation(ftpToXbox.MySaveInfo);
					ftpToXbox.Done = true;
				}
				LogMsg(ftpToXbox.Msg);
			}
			else if (ftpToXbox.action == FtpToXbox.Action.error)
			{
				statusbar.Push (1 , "XBGM# Error.");
				popup.Error(ftpToXbox.MsgError);
				ftpToXbox.action = FtpToXbox.Action.ready;
			}
			OnLine(ftpToXbox.Online);
			while (Application.EventsPending ())
				Application.RunIteration ();
		}

		/// <summary>
		/// Launch job in ftp thread.
		/// </summary>
		private void Ftp_Thread()
		{
			try
			{
				#if ( DEBUG )
				Console.WriteLine("In Ftp_Thread");
				#endif
				ftpToXbox.Done = false;
				ftpToXbox.In_Thread = true;		
				ftpToXbox.GetTitles(DLicons.Active);
				// Kill the thread because we are done
			    ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				#if ( DEBUG )	
				Console.WriteLine("End Ftp_Thread");
				#endif
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::Ftp_Thread): " + ex.Message);
				#endif
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				// make sure we Kill the thread
				ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
				//throw e;
			}		
		}
		
		public  void OnToolbarLaunchClicked()
		{
			// Launch Game by FTP Command
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )	
				{
					Console.WriteLine(CurrentGame[0]);
					Console.WriteLine(CurrentGame[1]);
					Console.WriteLine(CurrentGame[2]);
					Console.WriteLine(CurrentGame[3]);
				}
				#endif
				// DO xbox FTp stuff
				if (ftpToXbox.LaunchGame(CurrentGame))
				{
					// tell the user the game as been launch
					popup.Info(CurrentGame[0] + " Launched");
					AppendText(CurrentGame[0] + " Launched");
				}	
			}
		}
		
		public  void OnToolbarLaunchClicked(object o, EventArgs args)
		{
			OnToolbarLaunchClicked();
		}
				
		public  void OnToolbarDeleteClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )
					Console.WriteLine(CurrentGame[2]);
				#endif

				DeleteDialog login = new DeleteDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got DeleteDialog");	
				#endif
				if (login.action == 1)
					deletesave = false;
				if (login.action == 2)
					deletesave = true;
				if (login.action == 3)
					deletesave = true;
				
				login.Close();
				login = null;
				if(nRc == (int)ResponseType.Ok) {
					// Do xbox FTP stuff
					ftpToXbox.DeleteGame(CurrentGame, deletesave);
					AppendText("Game " + CurrentGame[0].ToString() + " deleted");
					UpdateDeleteInfo();
				}
			}
		}

		private void OnToolbarDeleteClicked(object o, EventArgs args)
		{
			OnToolbarDeleteClicked();
		}
		
		public  void OnToolbarRenameClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				RenameDialog login = new RenameDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got RenameDialog");	
				#endif
				string newgamename  = login.Game;
				#if ( DEBUG )
					Console.WriteLine("New name: " + newgamename);
				#endif
				login.Close();
				login = null;
				
				if(nRc == (int)ResponseType.Ok) {
					// Do xbox FTP stuff
					if (ftpToXbox.RenameGame(CurrentGame, newgamename))
					{
						AppendText("Game " + CurrentGame[0].ToString() + " rename to " + newgamename);
					}
				}
			}
		}

		private void OnToolbarRenameClicked(object o, EventArgs args)
		{
			OnToolbarRenameClicked();
		}
		
		public  void OnToolbarExportClicked ()
		{
			store.GetIterFirst(out iter);
			if (store.IterIsValid(iter))
			{
				MyChooserDialog chooserdialog = new MyChooserDialog((Gtk.Window) this.window1.Toplevel);
				ResponseType response = chooserdialog.SaveAsDialog("Export Game List to Html.", true);
				chooserdialog.Hide();
				if ((response == ResponseType.Ok) && chooserdialog.FileName.Length != 0)
				{
					#if ( DEBUG )
						Console.WriteLine(chooserdialog.FileName);
					#endif
					ExportGladeDialog ExportDialog = new ExportGladeDialog ((Gtk.Window) this.window1.Toplevel);
					bool[] colunmlist = ExportDialog.Run();
					ExportDialog.Close();
					ExportTo exportto = new ExportTo(popup, store, iter, colunmlist);			
					exportto.HTML(chooserdialog.FileName);
					exportto = null;				
					ExportDialog = null;
				}
				chooserdialog.Close();
				chooserdialog = null;
			}
		}
		#endregion

		#region OnToolbarISOClicked
		public  void OnToolbarOpenISOClicked ()
		{
			try {
				MyChooserDialog chooserdialog = new MyChooserDialog((Gtk.Window) this.window1.Toplevel);
				ResponseType response = chooserdialog.OpenFileDialog("Choose a ISO file.");
				#if ( DEBUG )
				Console.WriteLine("FileChooserDialog filename = '{0}'", chooserdialog.FileName);
				#endif
				if ((response == ResponseType.Ok) && chooserdialog.FileName.Length != 0)
				{
					iso.xisofilename = chooserdialog.FileName;
					iso.xisocompat = chooserdialog.xisoconpatCheckBox.Active;
					chooserdialog.Hide();
					iso.xbe = true;
					iso.Nbfiles = 0;
					iso.Nbdir = 0;
					iso.totfilesize = 0;
					iso.getfileiniso();
					labelR1.Text = iso.isosize.ToString() + " MB";
					labelR2.Text = iso.Nbfiles.ToString();
					labelR3.Text = iso.Nbdir.ToString();
					Entrygamexbe.Text = iso.GameName;
					string[] dir = config.GetDirectoryActive();
					Entryxboxdir.Text = dir[0];
					Entrygamedir.Text = iso.GameFolder;
					GenerateXboxsConnectionCombo();
					string[] info = null;
					if(iso.GameRegion == 1)
						info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(iso.xisofilename), "NTSC", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString(), config.GetNameActive()};
					else if(iso.GameRegion == 2)
						info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(iso.xisofilename), "JP", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString(), config.GetNameActive()};
					else if(iso.GameRegion == 4)
						info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(iso.xisofilename), "PAL", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString(), config.GetNameActive()};
					else
						info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(iso.xisofilename), "Mix", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString(), config.GetNameActive()};
					AddISOInfoToRow(info);
					RefreshBatchInfo();
					if (Environment.OSVersion.Platform.ToString().StartsWith("Win")) {
						try 
						{
							Freeimage xpr = new Freeimage(checkenvos.bindir);
							xpr.Convert(iso.xisofilename, checkenvos.workingdir);
							Pixbuf p = GetPixbufFromFile (iso.xisofilename + ".bmp");
							xisologo.Pixbuf = p;
							p = null;
						}catch (Exception ex)
						{
							#if (DEBUG)
								Console.WriteLine("Exception (in Gladegui::OnToolbarOpenISOClicked::Freeimage): " + ex.Message);
							#endif
							Console.WriteLine("Error: Unable to open xbe icon file:\n" + ex.Message);
							AppendText(ex.Message);
						}
						System.IO.Directory.SetCurrentDirectory(checkenvos.workingdir);
					}
					info = null;
				}
				chooserdialog.Close();
				chooserdialog = null;
				treeview2.IsFocus = true;
			}catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::OnToolbarOpenISOClicked): " + ex.Message);
				#endif
				popup.Error("Error: Unable to open/read iso file:\n" + iso.ErrMsg + "\n" + ex.Message);
				AppendText(iso.ErrMsg + "\n" + ex.Message);
			}
		}

		public  void OnToolbarUploadISOClicked ()
		{
			store2.GetIterFirst(out iter2);
			if (store2.IterIsValid(iter2))
			{
				 // Comment because i don't know where to get params, should in extract xiso
		/*		// Check Free space before Upload
				bool freespace = ftpToXbox.GetFreeSpace(string xboxDir, UInt32 size)
				if (freespace == true) // IF enought space
		*/		
				if( !ExtractXiso() )
				{	// Do not refresh Avalaunch menu else xbgm# will freeze
					#if (DEBUG)
					Console.WriteLine("Extraction cancelled!");
					#endif
					return;
				}
				else 
				{
					// Refresh Avalaunch Menu
					try
					{
						ftpToXbox.ActionNotOnGame(FtpToXbox.Action.refresh);
					}
					catch (Exception ex)
					{
						#if (DEBUG)
						Console.WriteLine("Exception (in Gladegui::OnToolbarUploadISOClicked): " + ex.Message);
						#endif
						popup.Error(ex.Message);
					}
				}
				// Check if i need to Shutdown Xbox
				if (halticons.Active == true) {
					// Shutdown Xbox
					ftpToXbox.ActionNotOnGame(FtpToXbox.Action.shutdown);
					// tell the user the game as been launch
					popup.Info("Xbox Shutdown");
					AppendText("Xbox Shutdown");
				}
				// Check if i need to Run Game uploaded
				if (rungame.Active == true) {
					// Run Game upload
					string xboxdir = GetSelectedISOListInfo(true);
					string gamedir = GetSelectedISOListInfo(false);
					string fullgame = null;
					if (xboxdir != null && gamedir != null) {
						#if ( DEBUG )
							Console.WriteLine("[{0}]/[{1}]/default.xbe", xboxdir, gamedir);
						#endif
						fullgame = xboxdir + "/" + gamedir + "/default.xbe";
						ftpToXbox.LaunchGame(fullgame);
						// tell the user the game as been launch
						popup.Info("Game Launched");
						AppendText("Game Launched");
					}
					xboxdir = gamedir = fullgame = null;
				}
				#if ( DEBUG )
					Console.WriteLine("End UploadISO");
				#endif
				AppendText(buf, "End Upload xISO");
			}
			else
			{
			  AppendText(buf, "You need to select an xISO file.");
			  popup.Info("You need to select an xISO file.");
			}
		}

		public  void OnToolbarExtractISOClicked ()
		{
			MyChooserDialog chooserdialog = new MyChooserDialog((Gtk.Window) this.window1.Toplevel);
			ResponseType response = chooserdialog.OpenFileDialog("Choose a ISO file.");
			#if ( DEBUG )
				Console.WriteLine("FileChooserDialog filename = '{0}'", chooserdialog.FileName);
			#endif
			if ((response == ResponseType.Ok) &&  chooserdialog.FileName.Length != 0)
			{
				string Filename = chooserdialog.FileName;
				chooserdialog.Close();
				chooserdialog.SelectDirDialog("Choose a Destination Directory.");
				#if ( DEBUG )
					Console.WriteLine("DirChooserDialog filename = '{0}'", chooserdialog.FileName);
				#endif
				string Destdir = chooserdialog.FileName;
				chooserdialog.Hide();	
				if (Destdir.Length != 0)
				{
					#if ( DEBUG )
						Console.WriteLine("File : [" + Filename + "] Dir: [" + Destdir + "]");
					#endif
					iso.xisocompat = chooserdialog.xisoconpatCheckBox.Active;
					iso.xisofilename = Filename;
					iso.GameRootFolder = Destdir;
					iso.xbe = false;
					iso.Nbfiles = 0;
					iso.totfilesize = 0;
					iso.getfileiniso();
					string gameextractdir = System.IO.Path.GetFileName(Filename);
					gameextractdir = gameextractdir.Substring(0 ,System.IO.Path.GetFileName(Filename).LastIndexOf('.'));
					iso.GameFolder = gameextractdir;
					gameextractdir = null;
					ExtractXiso();
					// Restore the old current path
					System.IO.Directory.SetCurrentDirectory(checkenvos.workingdir);
					iso.xisofilename = iso.GameRootFolder = iso.GameName = iso.GameFolder = null;
				}
			}
			chooserdialog.Close();	
			chooserdialog = null;
		}

		public  void OnToolbarUploadDirClicked ()
		{
			UploadDirGladeDialog uploaddirdialog = new UploadDirGladeDialog(config,(Gtk.Window) this.window1.Toplevel);
			uploaddirdialog.Run();
			uploaddirdialog.Close();
			uploaddirdialog = null;
			System.GC.Collect();
		}
		
		public  void OnToolbarClearBatchClicked ()
		{ 
			store2.Clear();
			RefreshBatchInfo();
			labelR1.Text  = "0";
			labelR2.Text = "0";
			labelR3.Text = "0";
			Entrygamexbe.Text = "";
			Entryxboxdir.Text = "";
			Entrygamedir.Text = "";
			transfertopionhbox.HideAll();
		}
		#endregion

		#region OnToolbarSaveManagerClicked
		public void OnToolbarScanSaveClicked (object o, EventArgs args)
		{
			try 
			{
				Console.WriteLine("OnToolbarScanSaveClicked");
				store3.Clear();
				ThreadStart tstart = new ThreadStart (Ftp_SaveThread);
				ftp_worker = new Thread (tstart);
				ftp_worker.Start();
				main_notify = new Gtk.ThreadNotify (new Gtk.ReadyEvent (UpdateSummaryThread));
			}catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::OnToolbarScanSaveClicked): " + ex.Message);
				#endif
			}
		}

		/// <summary>
		/// Launch job in ftp thread.
		/// </summary>
		private void Ftp_SaveThread()
		{
			try
			{
				#if ( DEBUG )
				Console.WriteLine("In Ftp_SaveThread");
				#endif
				ftpToXbox.Done = false;
				ftpToXbox.In_Thread = true;		
				ftpToXbox.GetListSaveGame();
				// Kill the thread because we are done
			    ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				#if ( DEBUG )	
				Console.WriteLine("End Ftp_SaveThread");
				#endif
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::Ftp_SaveThread): " + ex.Message);
				#endif
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				// make sure we Kill the thread
				ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
			}		
		}
		
		public void OnToolbarBackupSaveClicked (object o, EventArgs args)
		{
			try 
			{
				if (SaveInfos == null)
					return;
				Console.WriteLine("OnToolbarBackupSaveClicked");
				SaveXml savexml = new SaveXml();
				savexml.SaveAll(SaveInfos);
				ThreadStart tstart = new ThreadStart (Ftp_BackupThread);
				ftp_worker = new Thread (tstart);
				ftp_worker.Start();
				main_notify = new Gtk.ThreadNotify (new Gtk.ReadyEvent (UpdateSummaryThread));
			}catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::OnToolbarBackupSaveClicked): " + ex.Message);
				#endif
			}
		}

		/// <summary>
		/// Launch job in ftp thread.
		/// </summary>
		private void Ftp_BackupThread()
		{
			try
			{
				#if ( DEBUG )
				Console.WriteLine("In Ftp_BackupThread");
				#endif
				ftpToXbox.Done = false;
				ftpToXbox.In_Thread = true;		
				ftpToXbox.BackupAllSaveGame(SaveInfos);
				// Kill the thread because we are done
			    ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				#if ( DEBUG )	
				Console.WriteLine("End Ftp_BackupThread");
				#endif
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::Ftp_BackupThread): " + ex.Message);
				#endif
				ftpToXbox.Online = false;
				ftpToXbox.action = FtpToXbox.Action.ready;
				// make sure we Kill the thread
				ftp_worker.Abort();
				ftpToXbox.In_Thread = false;
			}
		}
		
		public void OnToolbarScanPCSaveClicked (object o, EventArgs args)
		{
			try 
			{
				Console.WriteLine("OnToolbarScanPCSaveClicked");
				SaveXml savexml = new SaveXml();
				savexml.SaveOpen();
				SaveInfos = savexml.GetAllXboxGame();
				savexml.SaveClose();
				store4.Clear();
				AddSaveInfoToRow(iter4, store4, treeview4);
			}catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine("Exception (in Gladegui::OnToolbarScanPCSaveClicked): " + ex.Message);
				#endif
			}
		}
		
		public  void OnToolbarGetClicked (object o, EventArgs args)
		{ // From Xbox to PC
            Console.WriteLine("Got OnToolbarGetClicked (From Xbox to PC)");
 			FindItAddIt(treeview3, true);
		}

		public  void OnToolbarPushClicked (object o, EventArgs args)
		{ // From Local to Xbox
            Console.WriteLine("Got OnToolbarPushClicked (From Local to Xbox)");
            FindItAddIt(treeview4, false);
		}

		private void FindItAddIt(TreeView mytreeview, bool fromxbox)
		{
			try 
			{
				TreeIter iter;
	            TreeModel model;

	            if (mytreeview.Selection.GetSelected(out model, out iter))
	            {
	 				#if (DEBUG)
						Console.WriteLine((string)model.GetValue (iter, 0) + " " + (string)model.GetValue (iter, 1)  + " " +(string)model.GetValue (iter, 2));
					#endif
					if (fromxbox)
						ftpToXbox.BackupOneSaveGame((string)model.GetValue (iter, 2));
					else
						ftpToXbox.PushOneSaveGame((string)model.GetValue (iter, 2));
	            }
			}catch (Exception ex) {
				Console.WriteLine ("In FindItAddIt {0}", ex.Message);
			}
		}
		
		public  void OnToolbarDelPCSaveClicked (object o, EventArgs args)
		{
            Console.WriteLine("Got OnToolbarDelPCSaveClicked");
            FindItRemoveIt(store4, treeview4, false);
		}

		public  void OnToolbarDelXboxSaveClicked (object o, EventArgs args)
		{
            Console.WriteLine("Got OnToolbarDelXboxSaveClicked");
            FindItRemoveIt(store3, treeview3, true);
		}
		
		
		private void FindItRemoveIt(TreeStore mystore, TreeView mytreeview, bool fromxbox)
		{
			try 
			{
				TreeIter iter;
	            TreeModel model;

	            if (mytreeview.Selection.GetSelected(out model, out iter))
	            {
	 				#if (DEBUG)
						Console.WriteLine((string)model.GetValue (iter, 0) + " " + (string)model.GetValue (iter, 1)  + " " +(string)model.GetValue (iter, 2));
					#endif
					string msg = null;
					bool profil = false;
					if (mystore.IterDepth(iter) == 0) // is root
					{ 
						msg = "save game\n" + model.GetValue (iter, 0) + " and all is profil(s)";
						profil = false;
	            	}
					else { // Is child
						msg = "profil\n" + model.GetValue (iter, 0);
						profil = true;
					}
					if (RemoveSaveGame(msg, (string)model.GetValue (iter, 2), (string)model.GetValue (iter, 3), fromxbox, profil))
						mystore.Remove (ref iter);
	            }
			}catch (Exception ex) {
				Console.WriteLine ("In FindItRemoveIt {0}", ex.Message);
			}
		}

		private bool RemoveSaveGame(string game, string id, string saveprofil, bool fromxbox, bool profil)
		{
			try 
			{
				string question = null;
				if (fromxbox)
					question = "Are you sure you want to delete the " + game + " from xbox ?";
				else
					question = "Are you sure you want to delete the " + game + " ?";
				if(popup.Question(question)) 
				{
					if (fromxbox)
						ftpToXbox.DeleteSaveGame(id, saveprofil, profil);
					else{
						SaveXml savexml = new SaveXml();
						if (profil){
							// TODO Extract zip save game, remove the profil, compress to zip
							// File.Delete(@"saves" + System.IO.Path.DirectorySeparatorChar + id + ".zip");
							savexml.RemoveOne(SaveInfos, saveprofil);
						} else {
							File.Delete(@"saves" + System.IO.Path.DirectorySeparatorChar + id + ".zip");
							savexml.RemoveOne(SaveInfos, id);
						}
						savexml = null;
					}
					AppendText(game + " deleted");
					return true;
				}
				question = null;
				return false;
			}catch (Exception ex) {
				Console.WriteLine ("In RemoveSaveGame {0}", ex.Message);
				return false;
			}
		}
		#endregion

		#region Treeview_event_right_click Scan Titles
		[GLib.ConnectBefore]
		public void OnTreeviewButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("Button click");
			#endif
			 switch (eb.Button)
            {
                case 3:
                        PopupMenuGame (eb);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenuGame (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Game!");
            #endif
            menu = null; // Make sure with we rescan config
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
					item = new ImageMenuItem (Stock.Execute, group);
            		item.Activated += new EventHandler (OnToolbarLaunchClicked);
            		menu.Append (item);       	
            	
            		item = new Gtk.ImageMenuItem ("Edit", group);
            		pix = new Gdk.Pixbuf (null, "edit.png");
					new Gtk.Image (pix);
            		item.Image = new Gtk.Image (pix);
            		item.Activated += new EventHandler (OnToolbarRenameClicked);
				    menu.Append (item);

                    item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteClicked);
                    menu.Append (item);                                   	
            }
            
            menu.ShowAll ();
            menu.Popup (null, null, null,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        private void PopupMenuCb(object o, PopupMenuArgs args)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Game Cb!");
            #endif
            PopupMenuGame (null);
        } 
		#endregion

		#region Treeview event click Scan Titles
		// Get single selection click on liststore
		private void on_List_selection(object o, EventArgs args)
		{	
		    TreeIter iter;
            TreeModel model;

            if (((TreeSelection)o).GetSelected (out model, out iter))
            {
                string sel = (string)model.GetValue (iter, 0);
                labelIDresult.Text = (string)model.GetValue(iter, 6);
				labelSpaceresult.Text = (string)model.GetValue(iter, 7) + " MB";
				labelSlackresult.Text = (string)model.GetValue(iter, 8) + " MB";
				#if ( DEBUG )
					Console.WriteLine("Result selection: " + sel);
				#endif
				UpdateSelectedTitleImage((string)model.GetValue(iter, 6));
				if (CurrentGame != null)
				{
					CurrentGame.Clear();
				}
				// Create my list of the current game with info i need 
				CurrentGame.Add(sel); // name
				CurrentGame.Add((string)model.GetValue(iter, 9)); // XBE
				CurrentGame.Add((string)model.GetValue(iter, 10)); // dir
				CurrentGame.Add(labelIDresult.Text); // ID
				labelPathresult.Text = System.IO.Path.GetDirectoryName(CurrentGame[2].ToString().Substring(0, CurrentGame[2].ToString().LastIndexOf('/')-1));
				#if ( DEBUG )
					Console.WriteLine("Nb info in CurrentGame: " + CurrentGame.Count);
					Console.WriteLine("==> {0},{1},{2},{3}", CurrentGame[0],
					                  CurrentGame[1], CurrentGame[2],
					                  CurrentGame[3]);
				#endif
            }
		}

		// Get Pixbuf from BMP image for title		
	    static Gdk.Pixbuf GetPixbufFromFile (string filename)
	    {
	        try {
	            Pixbuf p = new Pixbuf (filename);
	            return p;
	        } 
	    	catch (GLib.GException e) {
	            //Console.WriteLine (e.GetType ());
	            Console.WriteLine ("Error: Cannot Open image file: {0}", filename);
	            throw e;
	        }
	
	    }

		public void UpdateSelectedTitleImage(string id)
		{
			if (DLicons.Active)
			{
				try
				{
					// Bad this is growing in memory for each image pixbuf .
					// event if the image was all ready open
					Pixbuf p = GetPixbufFromFile ("titleimage" + System.IO.Path.DirectorySeparatorChar + id + ".bmp");
					logo.Pixbuf = p;
					p = null;
				}	
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache icon file:\n" + e.Message);
					AppendText(e.Message);
					return;
				}
			}
		}
		#endregion

		#region Treeview_event_right_click Upload ISO
		[GLib.ConnectBefore]
		public void OnTreeviewUploadISOButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("Button click");
			#endif
			 switch (eb.Button)
            {
                case 3:
                        PopupMenuIso (eb);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenuIso (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Iso!");
            #endif
            menu = null; // Make sure with we rescan config
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
					item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteXisoClicked);
            		menu.Append (item);      	

            		item = new ImageMenuItem (Stock.Clear, group);
            		item.Activated += new EventHandler (OnToolbarClearBatchClicked);
                    menu.Append (item);                                   	
            }
            
            menu.ShowAll ();
            menu.Popup (null, null, null,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        // Remove a row
        public void OnToolbarDeleteXisoClicked (object o, EventArgs args)
		{
			TreeIter iter;
 			TreeModel model;

 			if (treeview2.Selection.GetSelected (out model, out iter)) {
 				store2.GetPath (iter);
 				store2.Remove (ref iter);
			}
		}

        public void OnToolbarClearBatchClicked (object o, EventArgs args)
		{
			OnToolbarClearBatchClicked();
		}

        private void PopupMenuIsoCb(object o, PopupMenuArgs args)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Iso Called!");
            #endif
            PopupMenuIso (null);
        } 
		#endregion

		#region Treeview_event_ drag & drop Save Manager
		// Get single selection click on xbox Save manager
		private void on_XboxSaveGame_selection(object o, EventArgs args)
		{
		    TreeIter iter;
            TreeModel model;

            if (((TreeSelection)o).GetSelected (out model, out iter))
			{
				savename.Text  = (string)model.GetValue (iter, 0);
				nbsavegame.Text = (string)model.GetValue (iter, 1);
				idsavegame.Text = (string)model.GetValue (iter, 2);
				dirsavegame.Text = (string)model.GetValue (iter, 3);
				#if (DEBUG) 
					Console.WriteLine((string)model.GetValue (iter, 0) + " " + (string)model.GetValue (iter, 1)  + " " +(string)model.GetValue (iter, 2));
				#endif	
			}
		}
		
		// Get single selection click on Local Save manager
		private void on_PCSaveGame_selection(object o, EventArgs args)
		{
		    TreeIter iter;
            TreeModel model;

            if (((TreeSelection)o).GetSelected (out model, out iter))
			{
				localsavename.Text  = (string)model.GetValue (iter, 0);
				localnbsavegame.Text = (string)model.GetValue (iter, 1);
				localidsavegame.Text = (string)model.GetValue (iter, 2);
				localdirsavegame.Text = (string)model.GetValue (iter, 3);
				#if (DEBUG) 
					Console.WriteLine((string)model.GetValue (iter, 0) + " " + (string)model.GetValue (iter, 1)  + " " +(string)model.GetValue (iter, 2));
				#endif	
			}
		}
		#endregion

		#region Treeview event click Load ISO
		// Each arg is a new column	
		public void RefreshBatchInfo()
		{
			int job = 0;
			int size = 0;
			int files = 0;
			string sel;
			string[] strsize;
			
			if (store2.GetIterFirst(out iter2))
			{
				job++;
				sel = (string)store2.GetValue(iter2, 1);
				strsize = sel.Split(' ');
				size = Int32.Parse(strsize[0]);
				files = Int32.Parse((string)store2.GetValue(iter2, 6));
				#if (DEBUG)
					Console.WriteLine(strsize[0].ToString() + "  " + 
				                  (string)store2.GetValue(iter2, 6) + "  " + 
				                  (string)store2.GetValue(iter2, 7));
				#endif
				while (store2.IterNext(ref iter2)) {
					#if (DEBUG) 
						Console.WriteLine((string)store2.GetValue(iter2, 1) + "  " +
					                  (string)store2.GetValue(iter2, 6) + "  " +
					                  (string)store2.GetValue(iter2, 7));
					#endif				
					job++;
					sel = (string)store2.GetValue(iter2, 1);
					strsize = sel.Split(' ');
					size = Int32.Parse(strsize[0]) + size;
					files = Int32.Parse((string)store2.GetValue(iter2, 6)) + files;
				}
			}
			labelnbbatchentry.Text = job.ToString();
			labelnbbatchsize.Text = size.ToString() + " MB";
			labelnbbatchfiles.Text = files.ToString();
			sel = null;
			strsize = null;
		}

		// When press Enter Entrygamexbe modify liststore
		private void OnEntrygamexbeActivated(object o, EventArgs args)
		{
			OnEntry(0);
		}

		// When Focus Out Entrygamexbe modify liststore
		private void OnEntrygamexbeFocus(object o, FocusOutEventArgs args)
		{
			OnEntry(0);
		}
		
		// When press Enter Entrygamedir modify liststore
		private void OnEntrygamedirActivated(object o, EventArgs args)
		{
			OnEntry(2);
		}

		// When Focus Out Entrygamedir modify liststore
		private void OnEntrygamedirFocus(object o, FocusOutEventArgs args)
		{
			OnEntry(2);
		}

		// When press Enter Entryxboxdir modify liststore
		private void OnEntryxboxdirActivated(object o, EventArgs args)
		{
			OnEntry(5);
		}
		
		// When Focus Out Entryxboxdir modify liststore
		private void OnEntryxboxdirFocus(object o, FocusOutEventArgs args)
		{
			OnEntry(5);
		}

		// Where i is the index for the iter to modify
		private void OnEntry(int i)
		{
			TreeIter iter;
            TreeModel model;

            if (treeview2.Selection.GetSelected(out model, out iter))
            {
            	 if (i == 0)
	        		model.SetValue(iter, 0, Entrygamexbe.Text.ToString());
	        	else if (i == 2)
	        		model.SetValue(iter, 2, Entrygamedir.Text.ToString());
	        	else if (i == 5)
					model.SetValue(iter, 5, Entryxboxdir.Text.ToString());
            }
		}
		
		// Get single selection click on liststore ISO
		private void on_ISOList_selection(object o, EventArgs args)
		{
		    TreeIter iter;
            TreeModel model;

            if (((TreeSelection)o).GetSelected (out model, out iter))
			{
				labelR1.Text  = (string)model.GetValue (iter, 1);
				labelR2.Text = (string)model.GetValue (iter, 6);
				labelR3.Text = (string)model.GetValue (iter, 7);
				Entrygamexbe.Text = (string)model.GetValue (iter, 0);
				Entryxboxdir.Text = (string)model.GetValue (iter, 5);
				Entrygamedir.Text = (string)model.GetValue (iter, 2);
				GenerateXboxsConnectionCombo();
				if (Environment.OSVersion.Platform.ToString().StartsWith("Win")) {
					try
					{
						Pixbuf p = GetPixbufFromFile ((string)model.GetValue (iter, 8) + ".bmp");
						xisologo.Pixbuf = p;
						p = null;
					}	
					catch(Exception e) {
						Console.WriteLine("Error: Unable to open xbe icon file:\n" + e.Message);
						AppendText(e.Message);
					}
				}
				#if (DEBUG) 
					Console.WriteLine((string)model.GetValue (iter, 1) + " " + (string)model.GetValue (iter, 7)  + " " +(string)model.GetValue (iter, 6));
				#endif	
			}
			// Show All Load ISO option
			transfertopionhbox.Visible = true;
			transfertopionhbox.ShowAll();
		}

		private string GetSelectedISOListInfo(bool xboxdir)
		{
			TreeIter iter;
            TreeModel model;

            if (treeview2.Selection.GetSelected(out model, out iter))
            {
            	if (xboxdir)
					return (string)model.GetValue (iter, 5);
	    		else
					return (string)model.GetValue (iter, 2);
            }
			return null;
		}		
		#endregion
		
		#region  ExtractXiso
		private bool ExtractXiso()
		{
			// Create the GUI for the stats
			//ProgressDialog progress = new ProgressDialog (config);
			ProgressDialogGlade progress = new ProgressDialogGlade (config);
			// if we parse the xbe then it is extract over network
			double totsizebatchxiso = 0;
			if (iso.xbe == true)
			{
				// Send ListStore Gtk.TreeIter to ProgressDialog
				progress.xISOAdd(store2, iter2);
				// Generate tot size batch iso
				totsizebatchxiso = Convert.ToDouble((string)store2.GetValue(iter2, 9));
				while (store2.IterNext(ref iter2))
				{
					totsizebatchxiso += Convert.ToDouble((string)store2.GetValue(iter2, 9));
				}	
			/*	// Check if we got a / at the end xbox game dir.
				if (Entryxboxdir.Text.Length >= 4 && Entryxboxdir.Text.EndsWith("/") == false)
					Entryxboxdir.Text = Entryxboxdir.Text + "/";
				int Index = config.GetIndexByName((string)store2.GetValue(iter2, 12));
				progress.UpdateFTPinfo(config, Index, Entryxboxdir.Text);
			*/
				//Console.WriteLine("totsifebatchxiso ==>" + totsizebatchxiso + "\n");
				// Set Stats for Batch upload Xiso
				progress.UpdateStatBatchXisos(totsizebatchxiso,
				                              Convert.ToDouble(labelnbbatchentry.Text),
				                              false); // FTpavalaunch
				// Set first Xiso for Batch upload Xiso
				progress.SelectXisoInBatchXisos(false);
			}
			else
			{
				// Set Xiso and batch value for extraction on local
				progress.UpdateXiso(iso.xisofilename, iso.GameRootFolder, iso.GameFolder, iso.Nbfiles, iso.totfilesize, true, iso.xisocompat); // HDD
			}
			// Start timer
			DateTime DtStartNow = DateTime.Now;
			// Do the job
			progress.Run();
			// Stop timer
			DateTime DtStopNow = DateTime.Now;
			// When finish or cancel
			// Kill the dialog box
			progress.Close();
			string tmptime = (DtStopNow - DtStartNow).ToString();
			if (iso.xbe == true)
			{ 	// FTP mode
				if (progress.IsCancel == false)
					popup.Info("Task completed successfully.\n\nTotal xISO: " + labelnbbatchentry.Text + "\nFiles transferred: " + labelnbbatchfiles.Text + "\nTotal bytes transferred: " + (totsizebatchxiso/1024).ToString("####") + " Kb\nElapsed time: " + tmptime.Substring(0, tmptime.LastIndexOf('.')) 
					           + "\nAverage speed: " + (10000000/1024 * totsizebatchxiso/(DtStopNow.Ticks - DtStartNow.Ticks)).ToString(".##") + " kb/s");
			}
			else
			{	// HDD Mode
				if (progress.IsCancel == false)
					popup.Info("Task completed successfully.\n\nTotal bytes transferred: " + (iso.totfilesize/1024) + " KB\nFiles Transferred: " + iso.Nbfiles + "\nElapsed time: " + tmptime.Substring(0, tmptime.LastIndexOf('.')) 
						+ "\nAverage speed: " + 10000000/1024 * iso.totfilesize/(DtStopNow.Ticks - DtStartNow.Ticks) + " kb/s");
			}
			if (progress.IsCancel != false)
			{	// if eror while tranferring.
				popup.Info("You cancelled the operation or there has been an error.\n\n" +
							"You will need to reboot the XBOX if your dashboard is Avalaunch.");
				tmptime = null;
				progress = null;
				System.GC.Collect();
				Console.WriteLine("Aborted xISO extraction.\n");
				return false;
			}
			tmptime = null;
			progress = null;
			// Can't be null, it is a global.
			// we might need later.
			// iso = null;
			// Ask to clean the memory
			System.GC.Collect();
			#if ( DEBUG )
				Console.WriteLine("End Extract xISO\n");
			#endif
			return true;
		}
		#endregion

		#region Insert TextToRow in Treeview
		// Each arg is a new column
		public void AddTextToRow (params string[] args)
		{	
			try {
				iter = store.AppendValues(args[0], Convert.ToInt64(args[1]), args[2], 
									Convert.ToInt64(args[3]), Convert.ToInt64(args[4]),
				                         args[5], args[6], args[7], args[8], args[9], args[10]);
				treeview1.Model = store;
			}
			catch(Exception e) {
				#if ( DEBUG )
					Console.WriteLine("Error In Gladegui::AddTextToRow\n{0}", e.Message);
				#endif
				AppendText(e.Message);
				return;
			}
		}
		
		public void AddISOInfoToRow (params string[] args)
		{	
			//iter2 = store2.AppendValues(args);
			iter2 = store2.AppendValues(args[0], args[1], args[2], args[3],
									args[4], args[5], args[6], args[7],
									args[8], args[9], args[10], iso.xisocompat);
			treeview2.Model = store2;
		}
		
		public void AddSaveInfoToRow (TreeIter myiter,  TreeStore mystore, TreeView mytreeview)
		{
			if (SaveInfos != null) {
				for(int i = 0; i < SaveInfos.Length; i++) {
					if (SaveInfos[i].profil != null && SaveInfos[i].profil.Count != 0) {
						myiter = mystore.AppendValues (SaveInfos[i].Name, (SaveInfos[i].profil.Count/2).ToString(), SaveInfos[i].Id, null);
						for(int j = 0; j < SaveInfos[i].profil.Count; j = j+2) {
							mystore.AppendValues (myiter, SaveInfos[i].profil[j+1].ToString(), (SaveInfos[i].profil.Count/2).ToString(), SaveInfos[i].Id, SaveInfos[i].profil[j].ToString());
						} 
					}
					else
						myiter = mystore.AppendValues (SaveInfos[i].Name, "0", SaveInfos[i].Id, null);
					mytreeview.Model = mystore;
				}
				mytreeview.ExpandAll();
			}
			// Sort title by name game
			mystore.SetSortColumnId(0, SortType.Ascending);	
		}
		#endregion
		
		#region Statusbar Label Button Connection Press Event
		[GLib.ConnectBefore]
		private void OnLabelButtonPressEvent (object o, ButtonPressEventArgs args)
		{
			Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("Button OnLabelButtonPressEvent click!");
			#endif
			 switch (eb.Button)
            {
                case 3:
                       PopupConnexion(eb);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First OnLabelButtonPressEvent click!");
            			#endif
        				break;
            } 
		}
				
        private void PopupConnexion (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("In PopupPopupConnexion!");
            #endif
            menu = null; // Make sure with we rescan config 
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		
					for(int i = 0; i < config.xboxs.Length; i++){
                    	//Console.WriteLine("Active : " + config.xboxs[i].active + " Name: " + config.xboxs[i].name);
						if (config.xboxs[i].active) { // Active Xbox with icon
							//config.xboxs[i].active = true; // Set to active
							ImageMenuItem item = new Gtk.ImageMenuItem (config.xboxs[i].name, group);
							item.Image = new Gtk.Image (Stock.Apply, IconSize.Menu);
							item.Activated += new EventHandler (OnSwichActiveConnectionClicked);
							menu.Append (item);
						}
						else {
							// Other Xbox with simple menu as Text
			                MenuItem item2 = new MenuItem (config.xboxs[i].name);
			        		item2.Activated += new EventHandler (OnSwichActiveConnectionClicked);
			                menu.Append (item2);                                   	
						}
					}			
            }
            menu.ShowAll ();
            menu.Popup (null, null, null,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		}
        
        private void OnSwichActiveConnectionClicked (object o, EventArgs args)
		{
        	#if ( DEBUG )
        		Console.WriteLine ("In OnSwichActiveConnectionClicked!");
            #endif
        	string s = null;
			if (o is MenuItem)
			  s = ((o as MenuItem).Child as Label).Text;
			// Switch Label Text to the active xbox connection
			if (s != null) {
				statuslabelconnexion.Text = s;
				for (int i = 0; i < config.xboxs.Length; i++) {
					// Clean any active connection
					 config.xboxs[i].active = false;
					 if (config.xboxs[i].name.Equals(s)) {
						// Set select connection to Active
						config.xboxs[i].active = true;
						// Use G Drive
						DriveG.Visible = config.xboxs[i].Gdrive;
						labelResultDriveG.Visible = config.xboxs[i].Gdrive;
					}
				}
				#if ( DEBUG )
				Console.WriteLine ("ActiveConnection: {0}", s);
				#endif
			}
		}
        
		private void OnLine (bool online)
		{
		  	#if ( DEBUG )
            	Console.WriteLine ("In OnLine :" + online);
            #endif
            if (online) {
				OnLineStatusImg.Stock = Stock.Yes;
            } else
				OnLineStatusImg.Stock = Stock.No;
		}
        #endregion

		#region OnToolbarLogClicked
		public  void OnToolbarClearLogClicked()
		{
			textview.Buffer.Clear();
		}
		
		public  void OnToolbarSaveLogClicked ()
		{
			MyChooserDialog chooserdialog = new MyChooserDialog((Gtk.Window) this.window1.Toplevel);
			ResponseType response = chooserdialog.SaveAsDialog("Export Log view to Text.", false);
			chooserdialog.Hide();
			if ((response == ResponseType.Ok) && chooserdialog.FileName.Length != 0)
			{
				#if ( DEBUG )
					Console.WriteLine(chooserdialog.FileName);
				#endif
				StreamWriter outputFilestream = null;
				try {
					outputFilestream = new StreamWriter(chooserdialog.FileName);
				}
				catch(Exception e) {
					Console.WriteLine("Error: Unable to create output log file. " + e.Message);
					return;
				}
				outputFilestream.WriteLine(textview.Buffer.Text);		
				outputFilestream.Close();
				outputFilestream = null;
				#if ( DEBUG )
					Console.WriteLine("Outputting log to file done.");
				#endif
				popup.Info("Log message save to file \n" + System.IO.Path.GetFileName(chooserdialog.FileName));
				AppendText("Log message save to file " + System.IO.Path.GetFileName(chooserdialog.FileName));
			}
			chooserdialog.Close();
			chooserdialog = null;
		}
		#endregion

		#region Append Text to Log View
		private void LogMsg(string msg)
		{
			AppendText(msg);
		}
				
		void AppendText (string text) 
		{
			AppendText (buf, text);
		}
		
		public void AppendTextWithoutScroll (TextBuffer buffer, string text) 
		{
			TextIter iter;
			buffer.MoveMark(buf.InsertMark, buffer.EndIter);
			if(text != null) 
			{
				if (text.Equals ("") == false) 
				{				
					iter = buffer.EndIter;
					buffer.Insert (ref iter, "["+DateTime.Now.ToShortTimeString()+"] >> " + text);
				}
			}
			iter = buffer.EndIter;
			buffer.Insert (ref iter, "\n");
		}

		// WriteLine() to output text to Log TextView
		// for displaying result sets and logging messages
		public void AppendText (TextBuffer buffer, string text) 
		{
			AppendTextWithoutScroll(buffer,text);
			while (Application.EventsPending ()) 
				Application.RunIteration ();
			//textview.ScrollToMark (buf.InsertMark, 0.4, true, 0.0, 1.0);
		}
		#endregion	

		#region UpdateLabel Game
		//
		// **** NEW ******
		// since 0.8.0 
		public void updateSummary(Parser.Summary s)
		{
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = s.nbTitles.ToString();
			labelAllfilesResult.Text = s.totnbFiles.ToString();
			labelAllfoldersResult.Text = s.totnbFolders.ToString();
			labelAllsizeResult.Text = s.totSizeMb;
			labelAllspaceResult.Text = s.totSpaceMb;
			labelAllslackResult.Text = s.slackMb;
			
			updateGameInformation(s.info);
		}
		
		private void updateGameInformation(ArrayList info)
		{
			// Sort title by game title
			store.SetSortColumnId(0, SortType.Ascending);
			
			#if (DEBUG)
				Console.WriteLine("Number of games: " + info.Count);
			#endif
			
			foreach(string[] game in info)
			{
				AddTextToRow(game);
			}
		}
		
		private void updateLabelResults(string[] rootspace)
		{
			int Index = config.GetIndexActive();
			foreach(string space in rootspace)
			{
				//Console.WriteLine("Space:[" + space + "]");
				string[] free = space.Split(' ');
				if(free[24].Equals("C:"))
				{
					labelResultDriveC.Text = free[26].ToString() + " MB";
				}
				else if(free[24].Equals("E:"))
				{
					labelResultDriveE.Text = free[26].ToString() + " MB";
				}
				else if(free[24].Equals("F:"))
				{
					labelResultDriveF.Text = free[26].ToString() + " MB";
				}
				else if(free[24].Equals("G:"))
				{
					if (config.xboxs[Index].Gdrive == true) {
						//Console.WriteLine("Space for G:[" + free[26].ToString() + "]");
						labelResultDriveG.Text = free[26].ToString() + " MB";
						labelResultDriveG.Visible = true;
						DriveG.Visible = true;
					} else {
						labelResultDriveG.Visible = false;
						DriveG.Visible = false;
					}
				}
				free = null;
			}
			config.SaveFreeSpaceActive(rootspace);
		}
		
		//
		// **** NEW ******
		// since 0.9.1.0 UnleachX XBMC
		private void updateLabelResultsDash(string[] rootspace)
		{
			if (rootspace == null)
				return;
			try {
				int Index = config.GetIndexActive();
				if (!rootspace[0].EndsWith("B")) { //UnleachX
					Int64 size = Convert.ToInt64(rootspace[0]);
					size >>= 20;
					labelResultDriveC.Text = size.ToString() + " MB";
				} else { //XBMC
					labelResultDriveC.Text = rootspace[0].ToString();
				}
				
				if (!rootspace[1].EndsWith("B")) {
					Int64 size = Convert.ToInt64(rootspace[1]);
					size >>= 20;
					labelResultDriveE.Text = size.ToString() + " MB";
				} else {
					labelResultDriveE.Text = rootspace[1].ToString();
				}
				
				if (!rootspace[2].EndsWith("B")) {
					Int64 size = Convert.ToInt64(rootspace[2]);
					size >>= 20;
					labelResultDriveF.Text = size.ToString() + " MB";
				} else {
					labelResultDriveF.Text = rootspace[2].ToString();
				}
				
				if (config.xboxs[Index].Gdrive == true) {
					labelResultDriveG.Visible = true;
					DriveG.Visible = true;
					if (!rootspace[3].EndsWith("B")) {
						Int64 size = Convert.ToInt64(rootspace[3]);
						size >>= 20;
						labelResultDriveG.Text = size.ToString() + " MB";
					} else {
						labelResultDriveG.Text = rootspace[3].ToString();
					}
				} else {
					labelResultDriveG.Visible = false;
					DriveG.Visible = false;
				}
			}catch (Exception ex) {
					Console.WriteLine ("In updateLabelResultsDash {0}", ex.Message);
			}
		}

		/// <summary>
		/// Get last selected game to remove it from the list
		/// Update all titles info 
		/// Deleted stats of the current game
		/// Deleted the current game logo
		/// </summary>
		private void UpdateDeleteInfo () 
		{
			TreeIter myiter;
 			TreeModel model;

			string[] size = labelAllsizeResult.Text.Split(' ');
			string[] space = labelAllspaceResult.Text.Split(' ');
			string[] slack = labelAllslackResult.Text.Split(' ');
 			if (treeview1.Selection.GetSelected (out model, out myiter)) {
				labelAlltitlesResult.Text = labelAll(labelAlltitlesResult.Text, 1);
				labelAllfilesResult.Text = labelAll(labelAllfilesResult.Text, (Int64) model.GetValue (myiter, 3));
				labelAllfoldersResult.Text = labelAll(labelAllfoldersResult.Text, (Int64) model.GetValue (myiter, 4));
				labelAllsizeResult.Text = labelAll(size[0], (Int64) model.GetValue (myiter, 1)) + " MB";
				labelAllspaceResult.Text = labelAll(space[0], (string) model.GetValue (myiter, 7)) + " MB";
				labelAllslackResult.Text = labelAll(slack[0], (string) model.GetValue (myiter, 8)) + " MB";
 				store.GetPath (myiter);
 				store.Remove (ref myiter);
			}
			labelIDresult.Text = "";
			labelSpaceresult.Text = "";
			labelSlackresult.Text = "";
			labelPathresult.Text = "";
			pix = new Gdk.Pixbuf (null, "xbgmsharp.png");	
	        logo.Pixbuf = pix;
	        ftpToXbox.CheckDashboard();
	        System.GC.Collect();
		}

		private string labelAll (string nb1, string nb2)
		{
			int result = Convert.ToInt32(nb1) - Convert.ToInt32(nb2);
			return result.ToString();
		}

		private string labelAll (string nb1, Int64 nb2)
		{
			Int64 result = Convert.ToInt64(nb1) - nb2;
			return result.ToString();
		}
		
		private void updateBackupInformation(SaveInfo[] MySaveInfo)
		{
			this.SaveInfos = MySaveInfo;
			#if (DEBUG)
				Console.WriteLine("in updateBackupInformation");
			#endif
			AddSaveInfoToRow(iter3, store3, treeview3);
		}
		#endregion

		#region XboxsConnectionCombo
		/// <summary>
		/// Create the Xbox Connection Option Menu
		/// </summary>
		/// <returns>OptionMenu</returns>
		private void GenerateXboxsConnectionCombo() 
		{
		   	//Clear and Make Xbox List
			ListStore store = (ListStore)XboxsConnectionCombo.Model;
			store.Clear();
			int Index = config.GetIndexActive();
			for (int i = 0; i< config.xboxs.Length; i++) {
				XboxsConnectionCombo.AppendText(config.xboxs[i].name);
				if (Index == i)
					XboxsConnectionCombo.Active = i;
			}
			XboxsConnectionCombo.Changed += new EventHandler (OnConnectionComboActivated);
		}

		private void OnConnectionComboActivated (object o, EventArgs args) 
		{
			Gtk.TreeIter xboxsiter;
			
			XboxsConnectionCombo.GetActiveIter(out xboxsiter);		
		  	#if ( DEBUG )
				Console.WriteLine (XboxsConnectionCombo.Model.GetValue(xboxsiter, 0).ToString());
            #endif
			TreeIter iter;
            TreeModel model;

            if (treeview2.Selection.GetSelected(out model, out iter))
            {
            	model.SetValue(iter, 10, XboxsConnectionCombo.Model.GetValue(xboxsiter, 0).ToString());
            }
		}
		#endregion
}
}
