/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/08 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using System.IO;
using Gtk;
using Gdk;

	/// <summary>
	/// Description of MyToolbar.
	/// </summary>
	public class MyToolbar
	{
		private Pixbuf pix;
		private MyWindow mainwindow;

		/// <summary>
		/// Default contructor
		/// </summary>
		public MyToolbar(MyWindow gtkwindow)
		{
			this.mainwindow = gtkwindow;
		}
		
		/// <summary>
		/// Create the Game Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateGameToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem (String.Format (_("Scans Titles")),
				String.Format (_("Scans Titles on xbox")), String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarScanTitlesClicked));
			toolbar.AppendSpace();
	
			pix = new Gdk.Pixbuf (null, "edit.png");
			toolbar.AppendItem (String.Format (_("Rename")), 
				String.Format (_("Rename Game")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarRenameClicked));	
			 
			pix = new Gdk.Pixbuf (null, "play.png");
			//new Gtk.Image (Stock.Execute, IconSize.Menu),
			//new Gtk.Image (pix),
			toolbar.AppendItem (String.Format (_("Launch")),
				String.Format (_("Launch Game")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarLaunchClicked));	
			
			toolbar.AppendItem (String.Format (_("Delete")),
				String.Format (_("Delete Game")), String.Empty,
				new Gtk.Image (Stock.Delete, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarDeleteClicked));	
		
			toolbar.AppendSpace();
			
			toolbar.AppendItem (String.Format (_("Save List")),
				String.Format (_("Save Game List to HTML")), String.Empty,
				new Gtk.Image (Stock.Save, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarExportClicked));	
	 			
			return toolbar;
		}
		
		/// <summary>
		/// Create the ISO Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateISOToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem (String.Format (_("_Open")),
				String.Format (_("Open ISO")), String.Empty,
				new Gtk.Image (Stock.Open, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarOpenISOClicked));	
			
			toolbar.AppendItem (String.Format (_("Upload ISO")),
				String.Format (_("FTP Upload ISO")), String.Empty,
				new Gtk.Image (Stock.GotoTop, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarUploadISOClicked));
		
			toolbar.AppendItem (String.Format (_("Extract local ISO")),
				String.Format (_("Extract ISO ")), String.Empty,
				new Gtk.Image (Stock.GotoFirst, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarExtractISOClicked));
			
			toolbar.AppendSpace();

			toolbar.AppendItem (String.Format (_("Upload Directory")),
				String.Format (_("FTP Upload Directory")), String.Empty,
				new Gtk.Image (Stock.Open, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarUploadDirClicked));

			toolbar.AppendSpace();

			toolbar.AppendItem (String.Format (_("Clear")),
				String.Format (_("Clear Batch")), String.Empty,
				new Gtk.Image (Stock.Clear, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarClearBatchClicked));
			
			return toolbar;
		}

		/// <summary>
		/// Create the Save Manager Xbox side (right) Toolbar 
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateSaveXboxToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
	/*
			toolbar.AppendItem ("Connect",
				"Scans Titles", String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarScanTitlesClicked));		
			
			toolbar.AppendItem ("Refresh",
				"Scans Titles", String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarScanTitlesClicked));
	*/		 
			return toolbar;
		}		

			/// <summary>
		/// Create the Save Manager PC Side (left) Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateSavePcToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			

			
			return toolbar;
		}	
		
		/// <summary>
		/// Create the LOG Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateLogToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem (String.Format (_("Clear view")),
				String.Format (_("Clear log view")), String.Empty,
				new Gtk.Image (Stock.Clear, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarClearLogClicked));	
			
			toolbar.AppendItem (String.Format (_("Save log as")),
				String.Format (_("Save log as Text")), String.Empty,
				new Gtk.Image (Stock.SaveAs, IconSize.Menu),
				new Gtk.SignalFunc (mainwindow.OnToolbarSaveLogClicked));
		
			return toolbar;
		}
		
		/// <summary>
		/// Create the TOP Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		public Toolbar CreateTopToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;

			toolbar.AppendItem (String.Format (_("Configuration")),
				String.Format (_("Set Configuration")), String.Empty,
				new Gtk.Image (Stock.Preferences, IconSize.Button),
				new Gtk.SignalFunc (mainwindow.OnToolbarPrefClicked));
			
			toolbar.AppendSpace();	

			pix = new Gdk.Pixbuf (null, "xbmc.png");
			toolbar.AppendItem (String.Format (_("XBMC")), 
				String.Format (_("Xbox Media Center")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarXBMCClicked));	

			toolbar.AppendSpace();	
			
			pix = new Gdk.Pixbuf (null, "shutdown.png");
			toolbar.AppendItem (String.Format (_("Shutdown")), 
				String.Format (_("Shutdown Xbox")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarShutdownClicked));	
 
			pix = new Gdk.Pixbuf (null, "reboot.png");
			toolbar.AppendItem (String.Format (_("Reboot")), 
				String.Format (_("Reboot Xbox")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarRestartClicked));	
			
			toolbar.AppendSpace();
			
			pix = new Gdk.Pixbuf (null, "infoicon.png");
			toolbar.AppendItem (String.Format (_("Information")), 
				String.Format (_("About XBGM#")), String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (mainwindow.OnToolbarAboutClicked));	

			return toolbar;
		}
		/// <summary>
		/// hooking up a function that is called from gettext before trying to find a suitable
		///	string. If the hook resolves it, return that one.
		/// </summary>
		/// <param name="key">string to transalte</param>
		/// <returns>string</returns>
		static string _ (string key)
		{
			return ResMan.GetString (key);
		}
	}
}
