/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-19 at 17:56

using System;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;

namespace Xbgm.Core
{
	public class Zip
	{
		// Handle zip file for picture titles
		public static void Extract(string args, string dir, bool full)
		{
			ZipInputStream s = null;
			try	{ s = new ZipInputStream(File.OpenRead(args)); }
			catch(Exception e)
			{
				Console.WriteLine("Error: Unable to open cache zip image file.");
				Console.WriteLine(e.Message);
				return;
			}
			
			ZipEntry theEntry;
			#if ( DEBUG )
				Console.WriteLine("Zip:" + args);
			#endif

			Directory.CreateDirectory(dir);
			
			while ((theEntry = s.GetNextEntry()) != null) 
			{
				#if ( DEBUG )
					Console.WriteLine(theEntry.Name);
				#endif

				string directoryName = null;
				string fileName = null;
				try
				{
					directoryName = System.IO.Path.GetDirectoryName(theEntry.Name);
					fileName      = System.IO.Path.GetFileName(theEntry.Name);
					// It depends of the version of ICSharpCode.SharpZipLib and the OS
					// So it doubt we do it twice
					fileName = fileName.Substring(fileName.LastIndexOf(@"\")+1);
					#if ( DEBUG )
						Console.WriteLine(dir + Path.DirectorySeparatorChar + fileName);
					#endif
				}
				catch(Exception e)
				{
					Console.WriteLine(
						"Error: Unable to open zip file. Zip File is corrupt " + 
						e.Message);
					return;
				}
						
				if (fileName != String.Empty && full) { 
					Directory.CreateDirectory(directoryName);
					CreateFile(directoryName + Path.DirectorySeparatorChar + fileName, s);
				}
				else if (fileName != String.Empty) { CreateFile(dir + Path.DirectorySeparatorChar + fileName, s); }
				fileName = directoryName = null;
			}
			s.Close();
			s = null;
		} // End of Constructor
		
		private static void CreateFile(string filename, ZipInputStream input)
		{
			FileStream streamWriter = File.Create(filename);
		
			int size = 2048;
			byte[] data = new byte[2048];
			while (true) 
			{
				size = input.Read(data, 0, data.Length);
				
				if (size > 0) { streamWriter.Write(data, 0, size); } 
				else { break; }
			}
			streamWriter.Close();
			streamWriter = null;
		}
	}
}
