/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-19 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-19 at 22:05

using System;
using System.Collections;
using System.IO;

namespace Xbgm.Core
{
	public class Parser
	{
		public 	string 	dir;
		private Summary summary;
		
		public Parser()
		{
			this.summary.info = new ArrayList();
		}

		public struct Summary
		{
			public ArrayList info;
			public Int64 nbTitles;
			public Int64 totnbFiles;
			public Int64 totnbFolders;
			public Int64 totSize;
			public Int64 totSpace;
			
			public string totSizeMb
			{
				get	{ return totSize.ToString() + " Mb"; }
			}
			
			public string totSpaceMb
			{
				get	{ return totSpace.ToString() + " Mb"; }
			}

			public string slackMb
			{
				get	{ return (totSpace - totSize).ToString() + " Mb"; }
			}
			 
			public Summary(Int64 nbTitles,
							Int64 totnbFiles,
							Int64 totnbFolders,
							Int64 totSize,
							Int64 totSpace)
			{
				this.info = new ArrayList();
				this.nbTitles = nbTitles;
				this.totnbFiles = totnbFiles;
				this.totnbFolders = totnbFolders;
				this.totSize = totSize;
				this.totSpace = totSpace;
			}
		}
		
		public Summary Titles(string listings, bool init)
		{
			if (init)
				ReInitializeGameSummary();
					
			//Console.WriteLine("==> [" + listings + "]");
		
			// Get nb Games
			string[] full =	listings.Split('|');
			#if ( DEBUG )
				Console.WriteLine("nb lines:["+ full[1]+ "]");
			#endif
			string[] line =	full[0].Split('\n');
						
			for (Int32 i = 0; i < Convert.ToInt32(full[1]); i++)
			{
				ParseGame(line[i]);
	        }
				
			full = null;
			line = null;

			return this.summary;		
		}
		
		public Summary TitlesCached()
		{
			ReInitializeGameSummary();
			
		    // get an character input stream to read data from .
    		StreamReader reader = null;
    		try
    		{
				reader = new StreamReader("titles.txt");
    		}
			catch(Exception e) {
				Console.WriteLine("Warning: Unable to open cache file. " + 
					e.Message);
				return new Summary();
			}
			
			// read a line at a time
			string line = null;
			
			#if (DEBUG)
				Console.WriteLine("Reading cache file.");
			#endif
			
			while ((line = reader.ReadLine()) != null)
			{
				ParseGame(line);
			}

			try
			{
				reader.Close();
			}
			catch (IOException)
			{
			}
			
			line = null;

			return this.summary;		
		}
		
		private void ReInitializeGameSummary()
		{
			this.summary.nbTitles = 0;
			this.summary.totSize = 0;
			this.summary.totSpace = 0;
			this.summary.totnbFolders = 0;
			this.summary.totnbFiles = 0;
			this.summary.info.Clear();	
		}
		
		private void ParseGame(string game)
		{
			this.summary.nbTitles ++;

			#if (DEBUG)
				Console.WriteLine("Reading GameInfo for game #" + this.summary.nbTitles.ToString());
			#endif

			GameInfo gi = ParseGameInfo(game.Split('\t'));
			
			this.summary.totSize += gi.size;
			this.summary.totSpace += gi.space;
			this.summary.totnbFolders += gi.nbFolders;
			this.summary.totnbFiles += gi.nbFiles;
			
			string showdir = gi.path.Substring( dir.Length,
					(gi.path.IndexOf("default.xbe") - dir.Length) - 1);
		
		/*	string showdir =
				gi.path.Substring(
					this.con.Length,
					(gi.path.IndexOf("default.xbe") - this.cfg.getFtpInfo().getDirectory().Length) - 1);
		*/	
			this.summary.info.Add(new string[]
							{
								gi.name,
								gi.SizeMB(),
								showdir,
								gi.nbFiles.ToString(),
								gi.nbFolders.ToString(),
								gi.region,
								gi.id,
								gi.SpaceMB(),
								Convert.ToString(gi.space - gi.size),
								gi.Xbe(),
								gi.Directory()
							}
					);

			showdir = null;
		}
		
		private GameInfo ParseGameInfo(string[] gameInfo)
		{
			GameInfo gi;

			/*	0 dir xbe /// 1 name game /// 2 Size /// 3  Space ///	4 ID 
			    5 FolDERS /// 6 FILES    /// 7 N/A  /// 8 REGION
			*/

			gi.name = gameInfo[1];
			gi.id = gameInfo[4];
			
			// Convert size 
			gi.size = Convert.ToInt64(gameInfo[2]);
			gi.space = Convert.ToInt64(gameInfo[3]);
			gi.size >>= 20;
			gi.space >>= 20;

			gi.path = gameInfo[0].ToString();
			gi.nbFolders = Convert.ToInt64(gameInfo[5]);
			gi.nbFiles = Convert.ToInt64(gameInfo[6]);

			switch(Convert.ToInt64(gameInfo[8]))
			{
				case 4:
					gi.region = "PAL";
					break;
				case 3:
					gi.region = "Mix";
					break;
				case 1:
					gi.region = "NTSC";
					break;
				case 2:
					gi.region = "JP";
					break;
				default:
					gi.region = "None";
					break;
			}

			return gi;
		}
	}
}
