/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/12/12 KaYa
/// first release
///
/// </summary>

using System;
using System.Text;
using System.IO;

/// <summary>
/// Configuration stuff 
/// Read and Write Conf to File.
/// </summary>
namespace Xbgm
{
	public class Configuration
	{		
		public void SaveConf()
		{		
			StreamWriter outputConfstream = null;
			try {
				outputConfstream = new StreamWriter("xbgmsharp.conf");
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to setup conf file. " + 
					e.Message);
				return;
			}

			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
		}
		
		public bool ReadConf()
		{
			//Catch exception and exit 	if not fount 
			StreamReader inputConfstream = null;
			try {
				inputConfstream = new StreamReader("xbgmsharp.conf");
			}
			catch(Exception e) {
				Console.WriteLine("Warning: " + 
					e.Message);
				return false;
			}
			string line = null;
			int nbline = 0;
			while((line = inputConfstream.ReadLine()) != null)
			{
				switch(nbline)
				{
	/*				case 0:
						FTPinfo.IP = line.ToString();
						break;
					case 1:
						FTPinfo.port = Convert.ToInt32(line.ToString());
						break;
					case 2:
						FTPinfo.dir = line.ToString();
						break;
					case 3:
						FTPinfo.user = line.ToString();
						break;
					case 4:
						FTPinfo.pass = line.ToString();
						break;
					case 5:
						{
						string result = line.ToString();
						if(result.Equals("Y"))
							cache = true;
						else
							cache = false;
						break;
						}
					case 6:
						{
						XBMC = line.ToString();
						break;
						}
					default:
						Console.WriteLine("Error in conf file, Line not handle");
						AppendText("Error in conf file, Line not handle");
						break;
		*/		}
				nbline++;
			}
			inputConfstream.Close();
			inputConfstream = null;
			#if ( DEBUG )
				//Console.WriteLine("Readconf == user: \"" + FTPinfo.user + "\" pass: \"" + FTPinfo.pass + "\" IP: \"" + FTPinfo.IP + "\" PORT: \"" + FTPinfo.port + "\" Dir: \"" + FTPinfo.dir + "\"");
			#endif
			return true;
		}
	}
}
