/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Diagnostics;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.InteropServices;

using Gtk;
using Gdk;
using GtkSharp;
using Glade;

using EnterpriseDT.Net.Ftp;
using ICSharpCode.SharpZipLib.Zip;
using Xbgm.Xiso;

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
namespace Xbgm.Gui
{

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
public class MyGui : Gtk.Window {
		const string VERSION = "0.7.0.3";
		const string NAME = "XBGM#";   
		const string WELCOME = ", Copyright (C) 2004-2005 KaYa <xbgm@kayaweed.net>. \nIf you have any questions, comments, or suggestions about this program, please feel free to email them to me. \nYou can always find out the latest news about XBGM# from the official website at http://xbgm.sourceforge.net/.\nXBGM# comes with ABSOLUTELY NO WARRANTY; for details, see the COPYING file. \nThis is free software, and you are welcome to redistribute it under certain conditions; for details, see the COPYING file\n";
		
// Define Linux OS for no thread
		bool 		Linux = false;
// Info on the selected game. 4 string:  0: Name 1:xbe name 2: directory name 3: ID
		ArrayList	CurrentGame = null;
// Define if i use cache or not to show game list
		bool		cache = true;
// Define if i use Gdrive or not to show free space
		bool		Gdrive = true;		
// Xbox Media Center Full path + xbe
		string		XBMC = null;

/// The FTP structure of a FTP connection
		public struct FTP
		{
			public string		IP;
			public Int32		port;
			public string		dir;
			public string		user;
			public string		pass;
		}
		public FTP FTPinfo;
	
		private XisoInfoClass iso = null;

// List of xbox action on FTP
		enum FtpXbox { ready, scan, 
						rename, delete, 
						launch, reboot, 
						shutdown, xbmc, 
						image, freespace, 
						allfreespace, format, refresh};
						
		FtpXbox xboxAction;
		
		bool freespace = false;
		bool deletesave = false;
		
		public uint	IDtimeout = 0;
		
		#region Glade Widgets
	
		[Widget] Gtk.Window window1;

		#endregion
		
		public Tooltips tooltips;
	//Notebook1
		public OptionMenu DriveScanFolder;
		private HPaned top;
		private Menu menu = null;
		private ListStore store = null;	
		private Gtk.TreeIter iter;
		private Gtk.TreeView tv;

		private Gtk.Image image;
		private Pixbuf pix;
	
		private Label labelIDresult;
		private Label labelSpaceresult;
		private Label labelSlackresult;
		//private Label labelAllFreespace;
		private Label labelAlltitlesResult;
		private Label labelAllfilesResult;
		private Label labelAllfoldersResult;
		private Label labelAllspaceResult;
		private Label labelAllslackResult;
		private Label labelAllsizeResult;
		private Label labelAllFreespaceResult;
		
		private Label labelResultDriveC;
		private Label labelResultDriveE;
		private Label labelResultDriveF;
		private Label labelResultDriveG;
		private Label DriveG;
		
		private CheckButton DLicons;
	
	//Notebook2
		private ListStore store2 = null;
		private Gtk.TreeIter iter2;
		private Gtk.TreeView tv2;
		
		private Label labelR1;
		private Label labelR2;
		private Label labelR3;
		private Entry Entrygamexbe;
		private Entry Entrygamedir;
		private Entry Entryxboxdir;

		private Label labelnbbatchentry;
		private Label labelnbbatchsize;
		private Label labelnbbatchfiles;
		
		private CheckButton	halticons;
			
	//Notebook3
		public OptionMenu DriveOptionMenu;
		public int DriveSelected = 0;

	//Notebook4
		public TextView textview;
		public TextBuffer buf;		

		private Statusbar statusbar;

	/// <summary>
	/// Create the Main GUI
	/// </summary>
	public MyGui () : base ("MyGui")
	{
	 try{
			Glade.XML gxml = new Glade.XML (null, "xbgmgui.glade", "window1", null);
		    gxml.Autoconnect (this);
		}
			catch(Exception ex){
				Console.WriteLine("Glade GUI error: " + ex.Message);
		}
		
		// Init the FTP structure
		FTPinfo = new FTP();
		// Init the Xiso Info class
		iso = new XisoInfoClass();
		
		//If linux no thread in game manager
		if (Environment.OSVersion.Platform.ToString().StartsWith("Win"))
			Linux = false;
		else
			Linux = true;
	}
	
	/// <summary>
	/// Connect the Delete Signal defined in Glade
	/// </summary>
	public void OnMyWindowDelete (object o, DeleteEventArgs args) 
	{
	    Application.Quit();
	    args.RetVal = true;
	} 
	 
	public void OnToolbarAboutClicked(object o, EventArgs args)
	{
		System.Text.StringBuilder AuthorStringBuild = new System.Text.StringBuilder ();
	    String []authors = new String[]	{
	    	"KaYa <xbgm@kayaweed.net>",
	    	""
	    };
		String []web = new String[]	{
	    	"http://xbgm.sourceforge.net",
	    	""
	    };
		
	    AuthorStringBuild.Append (NAME + " " + VERSION + "\n\n");
	    AuthorStringBuild.Append ("Xbox Game Manager.\n");
	    AuthorStringBuild.Append ("Copyright (c) 2004-2005\n\n");
	    AuthorStringBuild.AppendFormat (
	    	"Authors:\n\t{0}\n\t{1}",
	    	authors[0],
	    	authors[1]
    	); 
	    AuthorStringBuild.AppendFormat (
	    	"\nWebsite:\n\t{0}\n\t{1}",
	    	web[0],
	    	web[1]
    	); 
	    
	    MessageDialog md = new MessageDialog (this,
	    	DialogFlags.DestroyWithParent,
	    	MessageType.Info,
	    	ButtonsType.Ok, 
	    	AuthorStringBuild.ToString ()
	    	);
	    
	    int result = md.Run ();
	    md.Hide();
		md.Destroy();
		return;
	}
}
}

