//This console application program calculates the size of the 
//directory or the file which is passed as an argument.
//The program will recursively go into the subfolders and the size.
//You will learn the usage of the abstract class FileSystemInfo 
//and using its methods.
//
//Usage: showDirSize <path>
//example:showDirSize D:\
//
//My Info: 
//		Name: Srinivas Varukala
//	    Education: Masters in C#

using System;
using System.IO;
using System.Runtime.InteropServices;
using Xbgm.Gui;

namespace Xbgm.Xiso
{
	//Inherits FileSystemInfo to use the methods to get file size.
	class XisoCreateClass : FileSystemInfo 
	{
		static long totsize = 0;// a STATIC variable to hold the total size of the directory.	
		static long totFilesize = 0;
		static long totDirsize = 0;
		static long totFile = 0;
		static string fileName = "J:\\test-xiso.iso";

//static  n_sectors( size )				( ( size ) / XISO_SECTOR_SIZE + ( ( size ) % XISO_SECTOR_SIZE ? 1 : 0 ) )
static 	string XBGMVERSION					= "0.7";
static 	int VERSION_LENGTH					= 3;
static 	string XISO_HEADER_DATA				= "MICROSOFT*XBOX*MEDIA";
static 	int XISO_HEADER_DATA_LENGTH			= 20;
static 	int XISO_HEADER_OFFSET				= 0x10000;
static 	int XISO_FILE_MODULUS				= 0x10000;
static 	int  XISO_ROOT_DIRECTORY_SECTOR		= 0x108;
static 	int XISO_OPTIMIZED_TAG_OFFSET		= 31337;
static 	string XISO_OPTIMIZED_TAG			= "XBGM" + XBGMVERSION;
static 	int XISO_OPTIMIZED_TAG_LENGTH		= ( 8 + VERSION_LENGTH );
static 	int XISO_OPTIMIZED_TAG_LENGTH_MIN	= 7;
static 	int XISO_ATTRIBUTES_SIZE			= 1;
static 	int XISO_FILENAME_LENGTH_SIZE		= 1;
static 	int XISO_TABLE_OFFSET_SIZE			= 2;
static 	int XISO_SECTOR_OFFSET_SIZE			= 4;
static 	int XISO_DIRTABLE_SIZE				= 4;
static 	int XISO_FILESIZE_SIZE				= 4;
static 	int XISO_DWORD_SIZE					= 4;
static 	int XISO_FILETIME_SIZE				= 8;
static 	int XISO_SECTOR_SIZE				= 2048;
static 	int XISO_UNUSED_SIZE				= 0x7c8;
static 	int XISO_FILENAME_OFFSET			= 14;
static 	int XISO_FILENAME_LENGTH_OFFSET		= ( XISO_FILENAME_OFFSET - 1 );
static 	int XISO_FILENAME_MAX_CHARS			= 255;
static 	int XISO_ATTRIBUTE_RO				= 0x01;
static 	int XISO_ATTRIBUTE_HID				= 0x02;
static 	int XISO_ATTRIBUTE_SYS				= 0x04;
static 	int XISO_ATTRIBUTE_DIR				= 0x10;
static 	int XISO_ATTRIBUTE_ARC				= 0x20;
static 	int XISO_ATTRIBUTE_NOR				= 0x80;
static 	int XISO_PAD_BYTE					= 0xff;
static 	int XISO_PAD_SHORT					= 0xffff;
static 	string XISO_MEDIA_ENABLE			= "\xe8\xca\xfd\xff\xff\x85\xc0\x7d";
static 	int XISO_MEDIA_ENABLE_BYTE			= '\xeb';
static 	int XISO_MEDIA_ENABLE_LENGTH		= 8;
static 	int XISO_MEDIA_ENABLE_BYTE_POS		= 7;

		FileStream xisofs; //File Handling xiso
		StreamWriter xisoWriter; //Stream reader xiso

		public void calculate(string args)
		{   
			XisoCreateClass obj = new XisoCreateClass();
			Console.WriteLine();
			obj.displayFileInfo(args);
			Console.WriteLine();
			Console.WriteLine("----------------------");
			//Console.WriteLine("Total Size = {0}", totsize);
			Console.WriteLine("Total File = {0} Size = {1}", totFile, totsize);
			//Console.WriteLine("Total Size = {0}", totDirsize);
			Console.WriteLine("----------------------");
			if(!File.Exists(fileName))
			{
				//xisofs  = new FileStream(fileName, FileMode.CreateNew, FileAccess.Write);
				//xisoWriter = new StreamWriter(xisofs);
				BinaryWriter binWriter = new BinaryWriter(File.Open(fileName, FileMode.Create));
				try
				{
					// Header offset
					byte[] dataArray = new byte[XISO_HEADER_OFFSET];
					binWriter.Write(dataArray, 0, XISO_HEADER_OFFSET);
					// Add Header XISO_HEADER_DATA
					binWriter.Write(XISO_HEADER_DATA);
					//Sector that root directory table resides in
					dataArray = new byte[XISO_SECTOR_OFFSET_SIZE];
					binWriter.Write(dataArray, 0, XISO_SECTOR_OFFSET_SIZE);
					//Size of root directory table in bytes
					dataArray = new byte[XISO_DIRTABLE_SIZE];
					binWriter.Write(dataArray, 0, XISO_DIRTABLE_SIZE);
					//FILETIME structure representing image creation time
					// a date from 1601 in nano secondes
					DateTime dt = DateTime.Now;
					long filetime = dt.ToFileTime();
				/*	FILETIME ft = new FILETIME();
					long hFT1 = DateTime.Now.ToFileTimeUtc();
					ft.dwLowDateTime = (int) (hFT1 & 0xFFFFFFFF);
					ft.dwHighDateTime = (int) (hFT1 >> 32);
				*/	
					binWriter.Write(filetime);
					//unused
					dataArray = new byte[XISO_UNUSED_SIZE];
					binWriter.Write(dataArray, 0, XISO_UNUSED_SIZE);
					// Add XISO_HEADER_DATA
					binWriter.Write(XISO_HEADER_DATA);
					//Done With HEADER
				}
				catch(EndOfStreamException e)
				{
					Console.WriteLine("{0} caught and ignored. " + 
						"Using default values.", e.GetType().Name);
				}
				finally
				{
					binWriter.Close();
				}
			}
		}

		protected void displayFileInfo(String path)
		{	
			
			try
			{
				if(!Directory.Exists(path))
				{
					Console.WriteLine("invalid path");
				}
				else
				{
					try
					{
						string[] fileList = Directory.GetFiles(path);
						for(int i=0; i<fileList.Length; i++)
						{
					
							if(File.Exists(fileList[i]))
							{						
								FileInfo finfo =  new FileInfo(fileList[i]);
								totsize += finfo.Length;
								totFilesize += finfo.Length;
								totFile++;
								Console.WriteLine("FILE: "+fileList[i]+" : Size>"+ finfo.Length); 
							}
						}
						totDirsize += totFilesize;
						Console.WriteLine("DIR: "+path+" : Size>"+ totDirsize);
						totDirsize = totFilesize= 0;
					}
					catch( System.NotSupportedException e1)
					{
						Console.WriteLine("Error1:"+ e1.Message);
					}

					try
					{
						string[] dirList = Directory.GetDirectories(path);
						for(int i=0; i<dirList.Length; i++)
						{
							Console.WriteLine();
							Console.WriteLine("DIRECTORY CHANGED:" + dirList[i]); 
							//Call the function recursively to get the file sizes in the subfolder.
							displayFileInfo(dirList[i]);
						}
					}
					catch( System.NotSupportedException e2)
					{
						Console.WriteLine("Error2:"+ e2.Message);
					}
				}
			}
			catch(System.UnauthorizedAccessException e)
			{
				Console.WriteLine("Error:"+ e.Message);
			}
		}

		//The following are the overrided functions since we inherited
		//the Abstract class FileSystemInfo.
		public override void Delete()
		{
		}
		
		public override bool Exists
		{
			get{ return true; }
		}

		public override string Name
		{
			get{ return "";}
		}

	/*
	 * 	public int n_sectors( int size )
		{
			int sizebt = ( size ) / XISO_SECTOR_SIZE + ( ( size ) % XISO_SECTOR_SIZE ? 1 : 0 );
			return sizebt;
		}
	*/
	}
}
