/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/13 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Reflection;
using System.Data;
using System.Text;
using System.IO;
using Gtk;
using Gdk;
using Glade;

	/// <summary>
	/// Description of Pref Galde Dialog.	
	/// </summary>
	public class PrefGladeDialog
	{
		private int Response;
		private int Index = -1;
		private ListStore storexbox;
		private Gdk.Pixbuf pix;
		public Config config;
		
		public PrefGladeDialog() 
		{ 
			#if (DEBUG)
				Console.WriteLine("In PrefGlade::PrefGladeDialog");
			#endif
			pix = new Pixbuf(null, "xbox.png");
			this.config = new Config();
			CreateGui();
			SetGlobalPref();
		}
		
		[Glade.Widget] Gtk.Dialog 		dialog1;
		[Glade.Widget] Gtk.Button 		button4;
		[Glade.Widget] Gtk.Button 		cancelbutton1;
		[Glade.Widget] TreeView 		treeview1;
		[Glade.Widget] Gtk.Entry 		entry1;
		[Glade.Widget] Gtk.SpinButton	spinbutton1;
		[Glade.Widget] Gtk.Entry 		entry2;
		[Glade.Widget] Gtk.Entry 		entry3;
		[Glade.Widget] Gtk.Entry 		entry4;
		[Glade.Widget] Gtk.Entry 		entry5;
		[Glade.Widget] Gtk.Entry 		entry6;
		[Glade.Widget] Gtk.Button 		button2;
		[Glade.Widget] Gtk.Button 		button3;
		[Glade.Widget] Gtk.CheckButton	checkbutton7;
		[Glade.Widget] Gtk.CheckButton	checkbutton6;
		[Glade.Widget] Gtk.CheckButton	checkbutton5;
		[Glade.Widget] Gtk.CheckButton	checkbutton4;
		[Glade.Widget] Gtk.CheckButton	checkbutton2;
		
		public void CreateGui() 
		{
		 try{
				Glade.XML gxml = new Glade.XML (null, "pref.glade", "dialog1", null);
				dialog1 = (Gtk.Dialog) gxml["dialog1"];
				treeview1 = (Gtk.TreeView) gxml["treeview1"];
				button2 = (Gtk.Button) gxml["button2"];
				button3 = (Gtk.Button) gxml["button3"];
				button4 = (Gtk.Button) gxml["button4"];
				cancelbutton1 = (Gtk.Button) gxml["cancelbutton1"];
				checkbutton7 = (Gtk.CheckButton) gxml["checkbutton7"];
				checkbutton6 = (Gtk.CheckButton) gxml["checkbutton6"];
				checkbutton2 = (Gtk.CheckButton) gxml["checkbutton2"];
				checkbutton5 = (Gtk.CheckButton) gxml["checkbutton5"];
				checkbutton4 = (Gtk.CheckButton) gxml["checkbutton4"];
				entry1 = (Gtk.Entry) gxml["entry1"];
				entry2 = (Gtk.Entry) gxml["entry2"];
				entry3 = (Gtk.Entry) gxml["entry3"];
				entry4 = (Gtk.Entry) gxml["entry4"];
				entry5 = (Gtk.Entry) gxml["entry5"];
				entry6 = (Gtk.Entry) gxml["entry6"];
				spinbutton1 = (Gtk.SpinButton) gxml["spinbutton1"];;
			    gxml.Autoconnect (this);
	
				button4.Clicked += new EventHandler (Connect_Action);
				button2.Clicked += new EventHandler (Add_Connection);
				button3.Clicked += new EventHandler (Del_Connection);
				cancelbutton1.Clicked += new EventHandler (Dialog_Cancel);
			   	dialog1.Title = "Connection Manager";
			   	dialog1.Icon = new Pixbuf(null, "xbgmicon.png");
			   	
				storexbox = CreateModel ();
				
				treeview1.AppendColumn ("Icon", new CellRendererPixbuf (), "pixbuf", 0);
				treeview1.AppendColumn ("Name", new CellRendererText (), "text", 1);
				treeview1.Model = storexbox;
				
				treeview1.Selection.Mode = Gtk.SelectionMode.Single;
				treeview1.Selection.Changed += new EventHandler (SelectionChanged);
			
			}
			catch(Exception ex){
					Console.WriteLine("Error in PrefGlade::CreateGui" + ex.Message);
			}
		}
		
		private ListStore CreateModel ()
		{
			ListStore store = new Gtk.ListStore (typeof (Gdk.Pixbuf), typeof(string));
			// Put data from config
			for(int i = 0; i < config.xboxs.Length; i++){
				store.AppendValues (pix, config.xboxs[i].name);
				#if (DEBUG)
					Console.WriteLine("xboxname:" + config.xboxs[i].name);
				#endif
			}		
			return store;
		}
		
		private void SetGlobalPref() 
		{
		 try{
				checkbutton2.Active = config.cachetitles;
				checkbutton5.Active = config.ftpverbose;
				checkbutton4.Active = config.cachesave;
			}
			catch(Exception ex){
				Console.WriteLine("Error in PrefGlade::SetGlobalPref" + ex.Message);
			}
		}
		
		private void SelectionChanged (object o, EventArgs args)
		{
			#if (DEBUG)
				Console.WriteLine("In PrefGlade::SelectionChanged");
			#endif	
			SaveCurrentConnection();
			//Console.WriteLine("Back In PrefGlade::SelectionChanged\n====================================");
			//Console.ReadLine();
			TreeSelection selection = (treeview1.Selection);
			TreeIter iter;
			TreeModel model;
				//Console.WriteLine("End selection\n====================================");
				//Console.ReadLine();
			if (selection.GetSelected (out model, out iter)) {
				string name = (string) model.GetValue (iter, 1);
				//Console.WriteLine("If  GetValue\n====================================");
				//Console.ReadLine();
				for(int i = 0; i < config.xboxs.Length; i++){
					if (config.xboxs[i].name.Equals(name)) {
						entry1.Text = config.xboxs[i].name;
						entry2.Text = config.xboxs[i].ip;
						spinbutton1.Value = config.xboxs[i].port;
						entry3.Text = config.xboxs[i].username;
						entry4.Text = config.xboxs[i].password;
						entry5.Text = config.xboxs[i].dir;
						entry6.Text = config.xboxs[i].xbmc;
						checkbutton7.Active = config.xboxs[i].Gdrive;
						checkbutton6.Active = config.xboxs[i].defaut;
						Index = i;
					}
				}
			}
		}
		
		private void Add_Connection (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("In PrefGlade::Add_Connection");
			#endif
			TreeIter iter;
			int nbiter = 1;
			storexbox.GetIterFirst(out iter);
			while (storexbox.IterNext(ref iter)) { nbiter++; } 
			//storexbox.Insert(nbiter);
			//Console.WriteLine("Position:{0}", nbiter);		
			storexbox.InsertAfter(iter);
			storexbox.AppendValues (pix, "New Xbox" + nbiter);
			config.AddNewConnection("New Xbox" + nbiter);
			SaveCurrentConnection();
		}
		
		private void Del_Connection (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("In PrefGlade::Del_Connection");
			#endif
			if (config.xboxs.Length > 1) { // We need at least one xbox in config
				TreeSelection selection = (treeview1.Selection);
				TreeIter iter;
				TreeModel model2;
				
				storexbox.GetIterFirst(out iter);
				if (selection.IterIsSelected(iter))
				{
					string name = (string) storexbox.GetValue (iter, 1);
					storexbox.Remove(ref iter);
					config.DelConnection(name); // This throw selection change event
				}
				while (storexbox.IterNext(ref iter)) 
				{		
					if (selection.GetSelected (out model2, out iter)) {
						string name = (string) storexbox.GetValue (iter, 1);
						storexbox.Remove(ref iter);
						config.DelConnection(name); // This throw selection change event
					}
				}
			}
		}
		
		private void Connect_Action (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("In PrefGlade::Connect_Action");
			#endif
			// Save xbox config
			SaveCurrentConnection();
			//config.Print();
			// Save global config
			config.cachetitles = checkbutton2.Active;
			config.ftpverbose = checkbutton5.Active;
			config.cachesave = checkbutton4.Active;
			config.WriteToXml();
			Response = (int)ResponseType.Ok;
			dialog1.Hide ();
		}

		private void SaveCurrentConnection()
		{
			TreeIter iter;	
			
			//Console.WriteLine("Index:"+ Index + " config.xboxs.Length" + config.xboxs.Length);
			//config.Print();
			//Console.WriteLine("End Print\n====================================");
			//Console.ReadLine();
			if (Index != -1 && Index < config.xboxs.Length ) {
				// Found last selected to change is xbox name
				storexbox.GetIterFirst(out iter);
				string name = (string) storexbox.GetValue (iter, 1);
				if (config.xboxs[Index].name.Equals(name)) {	
					//Console.WriteLine("cfg name:" + name + " last Index:" + Index);
					storexbox.SetValue(iter, 1, entry1.Text);
					// Save modification before loading other xbox in list
					config.xboxs[Index].name = entry1.Text;
					config.xboxs[Index].ip = entry2.Text;
					config.xboxs[Index].port = Convert.ToInt32(spinbutton1.Value);
					config.xboxs[Index].username = entry3.Text;
					config.xboxs[Index].password = entry4.Text;
					config.xboxs[Index].dir = entry5.Text;
					config.xboxs[Index].xbmc = entry6.Text;
					config.xboxs[Index].Gdrive = checkbutton7.Active;
					config.xboxs[Index].defaut = checkbutton6.Active;			
				}	
				while (storexbox.IterNext(ref iter)) 
				{	
					name = (string) storexbox.GetValue (iter, 1);
					if (config.xboxs[Index].name.Equals(name)) {	
						storexbox.SetValue(iter, 1, entry1.Text);
						//Console.WriteLine("cfg name:" + name + "Index:" + Index);
						// Save modification before loading other xbox in list
						config.xboxs[Index].name = entry1.Text;
						config.xboxs[Index].ip = entry2.Text;
						config.xboxs[Index].port = Convert.ToInt32(spinbutton1.Value);
						config.xboxs[Index].username = entry3.Text;
						config.xboxs[Index].password = entry4.Text;
						config.xboxs[Index].dir = entry5.Text;
						config.xboxs[Index].xbmc = entry6.Text;
						config.xboxs[Index].Gdrive = checkbutton7.Active;
						config.xboxs[Index].defaut = checkbutton6.Active;	
					}
				}
			}	
		}
		
		private void Dialog_Cancel (object o, EventArgs args)
		{
			Response = (int)ResponseType.Cancel;
			dialog1.Hide ();
		}

		public int Run ()
		{
			dialog1.ShowAll();
			checkbutton4.Visible = false; // hidden not handle in Gui code yet.
			checkbutton4.Hide();
			dialog1.Run();
			dialog1.Hide ();
			dialog1.Dispose ();
			return Response;
		}
		
		public void Close()
		{
			dialog1.Destroy();
		}
	}
}
