/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2006/08/29 KaYa
/// first release
///
/// </summary>

using System;
using System.Reflection;
using System.Collections;
using System.IO;
using System.Threading;
using Xbgm.Xiso;
using Xbgm.Core;
#if (TEXT)
using Mono.GetOptions;
[assembly: Mono.UsageComplement("-use-xbox <id> [-[lx]] -f <file1.xiso>")]
[assembly: Mono.About("XBGM# 0.9.0.7_text")]
[assembly: Mono.Author("KaYa <xbgm@kayaweed.net>")]
#endif

/// <summary>
/// So here is the All XBGM TEXT MODE
/// </summary>
namespace Xbgm.Text
{
/// <summary>
/// So here is the All XBGM TEXT MODE
/// </summary>
public class MyText {
	const string VERSION = "0.9.0.7_text";
	const string NAME = "XBGM#";
	const string WELCOME = ", Copyright (C) 2004-2006 KaYa <xbgm@kayaweed.net>. \nIf you have any questions, comments, or suggestions about this program, please feel free to email them to me. \nYou can always find out the latest news about XBGM# from the official website at http://xbgm.sourceforge.net/.\nXBGM# comes with ABSOLUTELY NO WARRANTY; for details, see the COPYING file. \nThis is free software, and you are welcome to redistribute it under certain conditions; for details, see the COPYING file\n";

// The XBMG configuration
	public Xbgm.Config config;
	
// Ftp Operations
	public FtpToXbox ftpToXbox;
	
	private XisoInfoClass iso = null;
	private XisoExtractClass2 Extractiso = null;

	/// <summary>
	/// Create the Main TEXT mode
	/// </summary>
	public MyText (string[] args)
	{
		#if (DEBUG)
			Console.WriteLine(NAME + VERSION);
		#endif
		// CheckOS to get config file
		string curdir = System.IO.Directory.GetCurrentDirectory();
		CheckEnvOs checkenvos = new CheckEnvOs();
		checkenvos = null;
		// Init the XBGM configuration
		config = new Config();
		System.IO.Directory.SetCurrentDirectory(curdir);
		#if (DEBUG)
			Console.WriteLine("Working Directory: {0}\n", curdir);
		#endif
		// Active Connection & G Drive	
		config.SetDefaultToActive();
		int Index = config.GetIndexActive();
		string[] dir = config.GetDirectoryActive();
		
		SampleOptions options = new SampleOptions ();
        options.ProcessArgs (args);
        #if (DEBUG)
        Console.WriteLine ("Specified Program Options:");
        Console.WriteLine ("\t			xiso: {0}", options.file);
        Console.WriteLine ("\t			directory: {0}", options.directory);
		Console.WriteLine ("\t			list: {0}", options.list);
		Console.WriteLine ("\t			extract: {0}", options.extract);
        Console.WriteLine ("\t			quiet: {0}", options.quiet);
        Console.WriteLine ("\t			silent: {0}", options.silent);
        Console.WriteLine ("\t			xbox id: {0}", options.use_xboxid);
        Console.WriteLine ("Remaining Program Options:");
        foreach (string s in options.RemainingArguments) {
            Console.WriteLine ("\t{0}", s);
        } 
        Console.WriteLine ("\n");     
        #endif

        // Init the Xiso Info class
		iso = new XisoInfoClass();
        
		//Init xisothread class
		Extractiso = new XisoExtractClass2();
        
        try 
        {
        	Console.WriteLine ("config.xboxs.Length {0}", config.xboxs.Length);
        	if (options.use_xboxid != 0 && options.use_xboxid <= config.xboxs.Length)
        	{
        		Index = options.use_xboxid - 1; // to match id
       			config.xboxs[Index].active = true;
        	    Console.WriteLine ("Using Xbox paramaters: ");
        		config.Print();
        		// extract to Xbox
        		Extractiso.hdd = false;
        	}
        	else 
        	{	// extract to HDD
        		Extractiso.hdd = true;
        		if (options.use_xboxid != 0){
        			Console.WriteLine ("Do you which to extract xiso localy ?");
        			Console.WriteLine ("Did you miss the xbox id ?");
				    return;
        		}
        	}
        if (options.file != null)
        {
        	#if (DEBUG)
        	Console.WriteLine ("\nDEBUG File xiso");
        	#endif
        	Console.WriteLine ("Xiso file {0}", options.file);
        	Console.WriteLine ("extracting to {0}", dir[0].ToString());
        }
        
        if (options.list)
        {
        	#if (DEBUG)
        	Console.WriteLine ("\nDEBUG List xiso");
        	#endif
	       	//string xisofile = System.IO.Path.GetFullPath(options.file);
	       	Console.WriteLine ("Xiso file {0}", options.file);
        	iso.xisofilename = options.file;
        	Console.WriteLine ("Xiso file {0}", iso.xisofilename);
    		iso.xbe = false;
			iso.Nbfiles = 0;
			iso.Nbdir = 0;
			iso.totfilesize = 0;
        	iso.getfileiniso();
        }
        
        if (options.extract)
        {
        	/*
        	 * Extract localy don't nened xbox id and localname dir
        	 * Extract on xbox will requiered a dest dir
        	 */
        	#if (DEBUG)
        	Console.WriteLine ("\nDEBUG Extract xiso");
        	#endif
			// Save current path before hdd extracting
			string currentdir = Directory.GetCurrentDirectory();
			iso.xisofilename = options.file;
			if (options.directory != null)
				iso.GameRootFolder = options.directory;
			else
			{
				if (Extractiso.hdd == false)
					iso.GameRootFolder = dir[0];
				else
					iso.GameRootFolder = currentdir;
			}
			/*
			iso.xbe = false;
			iso.Nbfiles = 0;
			iso.totfilesize = 0;
			iso.getfileiniso();
			*/
			string gameextractdir = System.IO.Path.GetFileName(options.file);
			gameextractdir = gameextractdir.Substring(0 ,System.IO.Path.GetFileName(options.file).LastIndexOf('.'));
			iso.GameFolder = gameextractdir;
			gameextractdir = null;
			if (Extractiso.hdd == true)
			{
			Console.WriteLine("\nxisofilename:{0}\niso.GameRootFolder:{1}\nGameFolder:{2}\n",
		                       iso.xisofilename, iso.GameRootFolder, iso.GameFolder);
			Extractiso.DoBackgroundWork(iso.xisofilename, iso.GameRootFolder, iso.GameFolder,
								null,0,null,null,null);
			}else { 
			Console.WriteLine("\nxisofilename:{0}\niso.GameRootFolder:{1}\nGameFolder:{2}\nip:{3}\nport:{4}\nusername:{5}\npassword:{6}\ndir:{6}",
		                       iso.xisofilename, iso.GameRootFolder, iso.GameFolder,
		                       config.xboxs[Index].ip, 
		                       config.xboxs[Index].port, 
		                       config.xboxs[Index].username, 
		                       config.xboxs[Index].password, 
		                       config.xboxs[Index].dir);
			Extractiso.DoBackgroundWork(iso.xisofilename, iso.GameRootFolder, iso.GameFolder,
		                       config.xboxs[Index].ip, 
		                       config.xboxs[Index].port, 
		                       config.xboxs[Index].username, 
		                       config.xboxs[Index].password, 
		                       config.xboxs[Index].dir);
			}
			// Restore the old current path
			Directory.SetCurrentDirectory(currentdir);
			currentdir = null;
			iso.xisofilename = iso.GameRootFolder = iso.GameName = iso.GameFolder = null;
        }       

        }catch(Exception ex)	{ Console.WriteLine("Stupid Exception: {0}", ex.Message); }
	}
} // End Class MyText

#if (TEXT)
class SampleOptions : Options
{
    // Long option is the variable name ("--file"), short option is -f
   [Option ("xiso(s)", 'f')]
    public string file;
     
    [Option ("expand xiso in <directory>", 'd')]
    public string directory;
    
    [Option ("List files in xiso(s)", 'l')]
    public bool list;
    
    // Long option is the variable name ("--quiet"), short option is -q
    [Option ("Don't print all non-error to stdout", 'q')]
    public bool quiet;
    
    // Long option is the variable name ("--quiet"), short option is -q
    [Option ("Suppress all output", 's')]
    public bool silent;  
   
    [Option ("Extract xiso(s)", 'x')]
    public bool extract;  

    // Long option is as specified ("--use-int"), no short option
    [Option ("Xbox connexion Id from config.xml (start at 1)", "use-xbox")]
    public int use_xboxid;

    public SampleOptions ()
    {
		ParsingMode = OptionsParsingMode.Both;
		BreakSingleDashManyLettersIntoManyOptions = false;
		EndOptionProcessingWithDoubleDash = true;

		if (System.IO.Path.DirectorySeparatorChar.CompareTo('/') == 0)
			ParsingMode = OptionsParsingMode.Linux;
    }
} // End Class SampleOptions
#endif

} // End NameSpace
