/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-20 Kaya
/// - initial version
///
/// </summary>

using System;
using System.Text;
using System.Collections;
using System.IO;
using Gtk;

namespace Xbgm.Core
{

	public class ExportTo
	{
		private Messages msg;
		
		public ExportTo(Messages msg)
		{
			this.msg = msg;
		}

		public void HTML(string filename, Gtk.ListStore mystore, Gtk.TreeIter myiter)
		{
			string DestDir = Path.GetDirectoryName(filename);
			string FullPath = Directory.GetCurrentDirectory();
			
			if (File.Exists(filename))
			{
				if (!msg.Question(filename + " already exists!\nOverwrite?") )
					return;	
			}
			
			StreamWriter outputFilestream = null;
			try {
				outputFilestream = new StreamWriter(filename);
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to write export file: " + filename + ". " + 
					e.Message);
				return;
			}

			StringBuilder strHtml = new StringBuilder();

			strHtml.Append("<html>\n<head><title>");
			strHtml.Append("Titles list");
			strHtml.Append("</title></head>\n");
			strHtml.Append("<body>\n");
			strHtml.Append("<h1>Titles list</h1>\n");
			strHtml.Append("\t<table border=1>\n");
			strHtml.Append("\t\t<tr>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Thumbnail</td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Game Titles</td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Size MB </td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Path </td>\n");
			strHtml.Append("\t\t</tr>\n");
			outputFilestream.WriteLine(strHtml.ToString());
			
			strHtml = new StringBuilder();
			
			mystore.GetIterFirst(out myiter);
			strHtml.Append("\t\t<tr>\n");
			strHtml.Append("\t\t\t<td align=\"center\"> " + "<img src=\"titleimage/" + (string)mystore.GetValue(myiter, 6)  + ".bmp\"" + "</td>\n");
			strHtml.Append("\t\t\t<td align=\"left\"> " + (string)mystore.GetValue(myiter, 0) + "</td>\n");
			strHtml.Append("\t\t\t<td align=\"center\"> " + (string)mystore.GetValue(myiter, 7) + " MB</td>\n");
			strHtml.Append("\t\t\t<td align=\"left\"> " + (string)mystore.GetValue(myiter, 10) + "</td>\n");
			strHtml.Append("\t\t</tr>\n");
			outputFilestream.WriteLine(strHtml.ToString());
			strHtml = null;

			while (mystore.IterNext(ref myiter)) {
				strHtml = new StringBuilder();
				strHtml.Append("\t\t<tr>\n");
				strHtml.Append("\t\t\t<td align=\"center\"> " + "<img src=\"titleimage/" + (string)mystore.GetValue(myiter, 6)  + ".bmp\"" + "</td>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + (string)mystore.GetValue(myiter, 0) + "</td>\n");
				strHtml.Append("\t\t\t<td align=\"center\"> " + (string)mystore.GetValue(myiter, 7) + " MB</td>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + (string)mystore.GetValue(myiter, 10) + "</td>\n");
				strHtml.Append("\t\t</tr>\n");
				outputFilestream.WriteLine(strHtml.ToString());
				strHtml = null;
			}
			outputFilestream.WriteLine("\t</table>\n</body>\n</html>\n");
			strHtml = null;
			outputFilestream.Close();
			outputFilestream = null;
			
				string sourcedir = FullPath + Path.DirectorySeparatorChar + "titleimage";
				string output = DestDir + Path.DirectorySeparatorChar + "titleimage" + Path.DirectorySeparatorChar;
			    //Checks if the path is valid or not
			    if(!Directory.Exists(output))
			    {
			      Console.WriteLine("invalid path");
			      Directory.CreateDirectory(output);
			    }
		    	try
				 {
			        //Directory.GetFiles() returns an array 
			        //of strings which are not just
			        //the file/directory name but the whole path to that
			        //file folder.
			        string[] fileList = Directory.GetFiles(sourcedir);
			        for(int i=0; i < fileList.Length; i++) {
			          if(File.Exists(fileList[i]))
			          {
					    #if ( DEBUG )
							Console.WriteLine("Copy file {0} to {1}",
					                      fileList[i], output + System.IO.Path.GetFileName(fileList[i]) );
						#endif 
						File.Copy(fileList[i], output + System.IO.Path.GetFileName(fileList[i]) , true);
			          }
			        }
			        fileList = null;
			      }
			      catch(Exception ex)
			      {
			        Console.WriteLine("Error (in ExportTo::HTML)\n" + ex.Message);
			      }
			      msg.Info("Exporting to HTML file done.\n" + filename);
			DestDir = null;
			sourcedir = null;
			FullPath = null;
			output = null;
		/*	
		 * 	
			// Output file, the html file.
			string output = DestDir + Path.DirectorySeparatorChar + "titleimage.zip";
			 
			#if ( DEBUG )
				Console.WriteLine("Copy file {0} to {1}",
					FullPath + Path.DirectorySeparatorChar + "titleimage.zip",
					output );
			#endif 

			if (File.Exists(output))
			{
				if (!msg.Question("File " + output + " already exists!\nOverwrite?") )
					return;	
				Console.WriteLine("You choose to overwrite.");
				File.Copy(FullPath + Path.DirectorySeparatorChar + "titleimage.zip",
							output, true);
			} else {
				File.Copy(FullPath + Path.DirectorySeparatorChar + "titleimage.zip",
							output);
			}
						
			Directory.SetCurrentDirectory(DestDir + Path.DirectorySeparatorChar);
			Zip.Extract(output);
			File.Delete(output);
			Directory.SetCurrentDirectory(FullPath);
		
			DestDir = null;
			FullPath = null;
			output = null;
		*/		
			#if ( DEBUG )
				Console.WriteLine("Outputting HTML file done.");
			#endif 
		}
	}
}
		
