/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/14 KaYa
/// first release
///
/// </summary>

using System;
using System.IO;
using System.Xml;
using System.Collections;
using Xbgm.Core;

namespace Xbgm
{		
	public class Config
	{
		private ConfigXml configxml;

		public struct connection
		{
			public bool 	active;
			public bool 	defaut;
			public int		id;
			public string 	name;
			public string 	ip;
			public int		port;
			public string	username;
			public string	password;
			public string 	dir;
			public string	xbmc;
			public bool		Gdrive;
		}		
		public connection[] xboxs;
		
		/// Define if i use cache or not to show game list
		public bool cachetitles;
		/// Define if i log ftp communication
		public bool ftpverbose;
		/// Define if i use save manager cache
		public bool cachesave;
		
		public Config()
		{
			#if (DEBUG)
				Console.WriteLine("Loading XML configuration.");
			#endif
			configxml = new ConfigXml();
			configxml.ConfigOpen();
			// Set global value
			cachetitles = configxml.GetGlobalCacheTitle();
			ftpverbose = configxml.GetGlobalFtp();
			cachesave = configxml.GetGlobalCacheSaveManager();
			// Load xbox list with param
			ArrayList xboxlist = configxml.GetAllXboxName();
			xboxs = new connection[xboxlist.Count];
			int i = 0;
			foreach (string xboxname in xboxlist){
				configxml.GetFtpConfigForXboxNamed(xboxname);
				xboxs[i].name = xboxname;
				xboxs[i].defaut = configxml.Defaut;
				xboxs[i].ip = configxml.IP;
				xboxs[i].port = configxml.Port;
				xboxs[i].username = configxml.User;
				xboxs[i].password = configxml.Password;
				xboxs[i].dir = configxml.Dir;
				xboxs[i].xbmc = configxml.XBMCDir;
				xboxs[i].Gdrive = configxml.Gdrive;
				xboxs[i].defaut = configxml.defaut;
				i++;
			}
			configxml.ConfigClose();
		}		
		
		
		public void AddNewConnection(string name)
		{
			int i = xboxs.Length + 1;
			connection[] xboxstmp = new connection[i];
			for (i = 0; i<xboxs.Length;i++) {
				xboxstmp[i] = xboxs[i];
			}
			xboxstmp[i].name = name;
			xboxstmp[i].ip = "192.168.0.1"; 
			xboxstmp[i].port = 21;
			xboxstmp[i].username = "xbox";
			xboxstmp[i].password = "xbox";
			xboxstmp[i].dir = "F:/,E:/Games/";
			xboxstmp[i].xbmc = "E:/XBMC/default.xbe";
			xboxstmp[i].Gdrive = false;
			xboxstmp[i].defaut = false;
			xboxs = xboxstmp;
		}
		
		public void DelConnection(string name)
		{
			int j = xboxs.Length - 1;
			connection[] xboxstmp = new connection[j];
			j = 0;
			for (int i = 0; i<xboxs.Length;i++) {
				 if (!xboxs[i].name.Equals(name)) {
					xboxstmp[j] = xboxs[i];
					j++;
				 }
			}
			xboxs = xboxstmp;
		}

		public int GetIndexActive()
		{
			for(int i = 0; i < xboxs.Length; i++){
				if (xboxs[i].active) { 
					return i; // Return Active Xbox Index
				}
			}
			return -1;
		}

		public void SetDefaultToActive()
		{		
			for(int i = 0; i < xboxs.Length; i++){
				if (xboxs[i].defaut) { // Default Xbox
					// Set Default Xbox to active
					xboxs[i].active = true; 
				}
			}
		}
		
		public string GetNameActive()
		{		
			for(int i = 0; i < xboxs.Length; i++){
				if (xboxs[i].active) { 
					return xboxs[i].name; // Return string from Active Xbox Index
				}
			}
			return null;
		}
		
		public string[] GetDirectoryActive()
		{		
			for(int i = 0; i < xboxs.Length; i++){
				if (xboxs[i].active) { 
					return xboxs[i].dir.Split(','); // Return dir[] from Active Xbox Index
				}
			}
			return null;
		}
		
		public int GetIndexByName(string name)
		{
			for (int i = 0; i<xboxs.Length;i++) {
				 if (xboxs[i].name.Equals(name)) {
					return i;
				 }
			}
			return 0;
		}
		
		public void Print ()
		{
			for (int i = 0; i < xboxs.Length;i++) {
				Console.WriteLine("Name: " + xboxs[i].name +
									"IP: " + xboxs[i].ip + 
									" Port: " + xboxs[i].port +
									"\nUser: " + xboxs[i].username +
									" Passwd: " + xboxs[i].password  +
									"\nDir: " +	xboxs[i].dir + 
									" XBMCDir: " +	xboxs[i].xbmc +
									" Gdrive: " + xboxs[i].Gdrive );
			}
		}
		
		public void WriteToXml()
		{
			string conf =  "<?xml version=\"1.0\"?>\n<Xbgmsharp>\n\t<Connection>\n";
			for (int i = 0; i < xboxs.Length;i++) {
				// here we replace '\' by '/' and add a '/' if not present.
				// this way no more cfg pb.
				string[] mydir = xboxs[i].dir.Split(',');
				for (int j = 0; j < mydir.Length; j++) {
					mydir[j] = mydir[j].Replace("\\", "/");
					if (mydir[j].ToString().EndsWith("/")== true)
						mydir[j] = mydir[j];
					else
						mydir[j] = mydir[j] + "/";
				}
				xboxs[i].dir = "";
				for (int j = 0; j < mydir.Length; j++) {
					if (j != 0)
						xboxs[i].dir = xboxs[i].dir + "," + mydir[j];
					else
						xboxs[i].dir = mydir[j];
				}
				conf = conf +	"\t\t<Xbox ID=\"" + i + 
							"\" Default=\"" + xboxs[i].defaut + 
							"\" Name=\"" + xboxs[i].name + "\">\n" +
				    		"\t\t\t<IP>" + xboxs[i].ip + "</IP>\n" +
				    		"\t\t\t<Port>" + xboxs[i].port + "</Port>\n" + 
				    		"\t\t\t<User>" + xboxs[i].username + "</User>\n" + 
				    		"\t\t\t<Pass>" + xboxs[i].password  + "</Pass>\n" + 
				    		"\t\t\t<Directory>" + xboxs[i].dir + "</Directory>\n" +
							"\t\t\t<Xbmc>" +	xboxs[i].xbmc + "</Xbmc>\n" +
				    		"\t\t\t<Gdrive>"+  xboxs[i].Gdrive + "</Gdrive>\n" +
				  			"\t\t</Xbox>\n";
				mydir = null;
			}
			conf = conf + "\t</Connection>\n\t<Global>\n" +
							"\t\t<CacheTitle>" + cachetitles + "</CacheTitle>\n" +
							"\t\t<FtpVerbose>" + ftpverbose + "</FtpVerbose>\n" +
							"\t\t<CacheSaveManager>" + cachesave + "</CacheSaveManager>\n" +
							"\t</Global>\n</Xbgmsharp>\n"; 
			configxml.WriteConfig(conf);
			conf = null;
		}
	}
}
