/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2005  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/03/19 KaYa
/// first release
///
/// </summary>
 
namespace Xbgm.Gui
{
using System;
using System.Text;
using Gtk;

/// <summary>
/// Description of AboutDialog.	
/// Show when click on About icon.
/// </summary>
public class AboutDialog
{
	MessageDialog md;
	
	public AboutDialog(Gtk.Window main_window, string version)
	{
		// For GTK 2.0 "KaYa &lt;xbgm@kayaweed.net&gt;",
		System.Text.StringBuilder AuthorStringBuild = new System.Text.StringBuilder ();
	    String []authors = new String[]	{
	    	"KaYa &lt;xbgm@kayaweed.net&gt;",
	    	""
	    };
		String []contrib = new String[]	{
	    	"Pascal Giard &lt;evilynux@gmail.com&gt;",
	    	""
	    };
		String []web = new String[]	{
	    	"http://xbgm.sourceforge.net",
	    	"http://sourceforge.net/projects/xbgm",
	    	""
	    };
		String []forum = new String[]	{
	    	"http://sourceforge.net/forum/?group_id=80034",
	    	""
	    };
		
	    AuthorStringBuild.Append ("XBGM# " + version + "\n\n");
	    AuthorStringBuild.Append ("Xbox Game Manager.\n");
	    AuthorStringBuild.Append ("Copyright (c) 2004-2006\n\n");
		AuthorStringBuild.AppendFormat (
	    	"Authors:\n\t{0}\n\t{1}",
	    	authors[0],
	    	authors[1]
    	); 
		AuthorStringBuild.AppendFormat (
	    	"\nContributors:\n\t{0}\n\t{1}",
	    	contrib[0],
	    	contrib[1]
    	); 
	    AuthorStringBuild.AppendFormat (
	    	"\nWebsite:\n\t{0}\n\t{1}\n\t{2}",
	    	web[0],
	    	web[1],
	    	web[2]
    	); 
	    AuthorStringBuild.AppendFormat (
	    	"\nForum:\n\t{0}\n\t{1}",
	    	forum[0],
	    	forum[1]
    	); 
	    
	    md = new MessageDialog (main_window,
	    	DialogFlags.DestroyWithParent,
	    	MessageType.Info,
	    	ButtonsType.Ok, 
	    	AuthorStringBuild.ToString()
	    	);

	}

	public void Run ()
	{
		md.Run();
	}
	
	public void Close()
	{
		md.Hide ();
		md.Destroy();
		md = null;
	}
}
//End namespace
}
