/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

using System;
using System.IO;
using System.Text;
using System.Data;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using System.Threading;
using System.Diagnostics;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.InteropServices;
using Gtk;
using Gdk;
using GtkSharp;

using EnterpriseDT.Net.Ftp;
using ICSharpCode.SharpZipLib.Zip;
using Xiso;

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
namespace GUI
{
	
public class MyWindow : Gtk.Window {
	
// That is bad i know but i need a full liste of the game in memory.
 		string[]	liste;
// Info on the selected game. 4 string:  0: Name 1:xbe name 2: directory name 3: ID
		ArrayList	CurrentGame = null;
// Define if i use cache or not to show game list
		bool		cache = true;
		string		XBMC = null;
// The FTP structure of a FTP connection
		public struct FTP
		{
			public string		IP;
			public Int32		port;
			public string		dir;
			public string		user;
			public string		pass;
		}
		public FTP FTPinfo;
// Debug bool using build mode
// I now use the Build option DEBUG or RELEASE
		/*#if ( DEBUG )
			bool debug = true;
			bool debugFTP = true;
		#else
			bool debug = false;
			bool debugFTP = false;
		#endif
		*/

// List of xbox action on FTP
		enum FtpXbox { scan, rename, delete, launch, reboot, shutdown, xbmc };
		FtpXbox xboxAction;
	
		bool deletesave = false;
		string xisofilename = null;
	//Notebook1
/*		private Window window; To be remove when GUI will be fixed
		private VPaned vpaned;*/
		private HPaned top;
/*		private Frame left;
		private Frame rightup;
		private Frame rightdown; To be remove when GUI will be fixed
		private Frame right;
		private Frame bottom;
		private	Table table;*/
		private Menu menu = null;
		private ListStore store = null;	
		private Gtk.TreeIter iter;
		private Gtk.TreeView tv;

		private Gtk.Image image;
		private Pixbuf pix;
	
		private Label labelIDresult;
		private Label labelSpaceresult;
		private Label labelSlackresult;
		//private Label labelAllFreespace;
		private Label labelAlltitlesResult;
		private Label labelAllfilesResult;
		private Label labelAllfoldersResult;
		private Label labelAllspaceResult;
		private Label labelAllslackResult;
		private Label labelAllsizeResult;
		private Label labelAllFreespaceResult;
		 
		private CheckButton DLicons;
	
	//Notebook2
		private ListStore store2 = null;
		private Gtk.TreeIter iter2;
		private Gtk.TreeView tv2;
		private Label labelR1;
		private Label labelR2;
		private Label labelR3;
		private Entry Entrygamedir;
		private Entry Entryxboxdir;
	
	
		private Statusbar statusbar;

	public MyWindow () : base ("MyWindow")
	{
		const string VERSION = "0.3";
		const string NAME = "XBGM#";

	 try{
			this.SetDefaultSize (840, 560);
			this.Title = NAME + " " + VERSION;
			this.DeleteEvent += new DeleteEventHandler (OnMyWindowDelete);
			this.BorderWidth = 2;
	 	
	 		// Set the icon
	 		Gdk.Pixbuf Icon = new Gdk.Pixbuf(null, "xbgmicon.png");
			this.Icon = Icon;

			// 1 first split in line		
			VBox vbox = new VBox (false, 0); 
			this.Add (vbox);
	 	
			// Create the Top Toolbar.
			Toolbar Toptoolbar = CreateTopToolbar ();
			vbox.PackStart (Toptoolbar, false, false, 0);

//=================================================
// 				NoteBook 1
			#region NoteBook 1
			Notebook nb = new Notebook ();
	 		VBox vboxnb1 = new VBox (false, 0);
	 		nb.Add(vboxnb1);
	 		nb.SetTabLabelText(vboxnb1, "Manage Titles On Xbox");
	 		vbox.PackStart (nb, true, true, 0);
	 	
			// Create the Toolbar.
			Toolbar Gametoolbar = CreateGameToolbar ();
			vboxnb1.PackStart (Gametoolbar, false, false, 0);

			// Add Horizontal Frame
			top = new HPaned ();
			top.Position = 680;
			vboxnb1.PackStart (top, true, true, 0);
			top.BorderWidth = 0;
			
			// Add a scrolledWindows for the GameList
			ScrolledWindow sw = new ScrolledWindow ();
			top.Add1 (sw);
			
			// Create the treeview containing 6 string
			store = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string) );
	
			// sort by on name for column 0
			//store.SetSortColumnId(0, 0);
			tv = new TreeView (store);
			tv.HeadersVisible = true;
	 		// I don't know what that but why not?
			//tv.Reorderable = true;
	 		
	 		// Right Click 
	 		// Connect signals for mouse button press and popup menu
            tv.ButtonPressEvent += new ButtonPressEventHandler (OnTreeviewButtonPressEvent);
            tv.PopupMenu += new PopupMenuHandler (PopupMenuCb); 
	 	
			// Got leftt clickable
			// This crash if not using the mono command line on WIN32
			// Suppress the crash by catch exception but the GUi it is not fulle functional.
			tv.Selection.Changed += 
				new EventHandler(on_List_selection);
	 	
			// This is bad but if i don't it that way.
			// it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column = new TreeViewColumn ();
			CellRendererText text = new CellRendererText ();
			column.Title = "Title";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 0);
			tv.AppendColumn(column);

			// 2
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Size";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 1);
			tv.AppendColumn(column);
			
			// 3 
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folder";
			column.Resizable = true;
			column.SortColumnId = 0;
			// specified the size of the column Folder
			column.Sizing = TreeViewColumnSizing.Fixed;
			column.FixedWidth = 260;
						
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 2);
			tv.AppendColumn(column);
			
			// 4
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Files";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 3);
			tv.AppendColumn(column);
			
			// 5
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folders";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 4);
			tv.AppendColumn(column);

			// 5
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Region";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 5);
			tv.AppendColumn(column);

			sw.Add(tv);
						
			// Split for the right view 			
			VBox vboxinside = new VBox (false, 0); 
			//vboxinside.Visible = true;
			vboxinside.Visible = false;
			top.Add2 (vboxinside);					
		
			// Now that is split 
			// Add the image view
			// Don't show image if check box not Active.
			// Old way to get image from file V0.1
			//pix = GetPixbufFromFile ("xbgm.png"); 
	 		// New way to get image from resource V0.2
	 		pix = new Gdk.Pixbuf (null, "xbgm.png");	
	        image = new Gtk.Image (pix);  // OK
	 	
			vboxinside.PackStart (image);
			
			// Add a frame with a label Title view
			Frame frame = new Frame (" Selected Title ");
			frame.BorderWidth = 4;
			vboxinside.PackStart (frame);

			Table table = new Table (3, 2, true);
			frame.Add (table);

			Label labelID = new Label ("ID:");
			table.Attach (labelID, 0, 1, 0, 1);

			Label labelSpace = new Label ("Space:");
			table.Attach (labelSpace,0, 1, 0, 2);

			Label labelSlack = new Label ("Slack:");
			table.Attach (labelSlack, 0, 1, 0, 3);
		
			labelIDresult = new Label ("00000000");
			table.Attach (labelIDresult, 1, 2, 0, 1);
		
			labelSpaceresult = new Label ("nb Space");
			table.Attach (labelSpaceresult, 1, 2, 0, 2);

			labelSlackresult = new Label ("nb Slack");
			table.Attach (labelSlackresult, 1, 2, 0, 3);
		
			// Add a frame label All Titles
			frame = new Frame (" All Titles ");
			frame.BorderWidth = 4;
		
			vboxinside.PackStart (frame);
			
			Table table2 = new Table (7, 2, true);
			frame.Add (table2);

			Label labelAlltitles = new Label ("Titles:");
			table2.Attach (labelAlltitles, 0, 1, 0, 1);

			Label labelAllfiles = new Label ("Files:");
			table2.Attach (labelAllfiles,0, 1, 0, 2);

			Label labelAllfolders = new Label ("Folders:");
			table2.Attach (labelAllfolders, 0, 1, 0, 3);
		
			Label labelAllsize = new Label ("Size:");
			table2.Attach (labelAllsize, 0, 1, 0, 4);
		
			Label labelAllspace = new Label ("Space:");
			table2.Attach (labelAllspace, 0, 1, 0, 5);

			Label labelAllslack = new Label ("Slack:");
			table2.Attach (labelAllslack , 0, 1, 0, 6);
	 	
			Label labelAllFreespace = new Label ("Free Space:");
			table2.Attach (labelAllFreespace , 0, 1, 0, 7);
	 	
			// Result Labels
			labelAlltitlesResult = new Label ("nbTitles");
			table2.Attach (labelAlltitlesResult, 1, 2, 0, 1);

			labelAllfilesResult = new Label ("nbFiles");
			table2.Attach (labelAllfilesResult, 1, 2, 0, 2);

			labelAllfoldersResult = new Label ("nbFolders");
			table2.Attach (labelAllfoldersResult, 1, 2, 0, 3);
		
			labelAllsizeResult = new Label ("nbSize");
			table2.Attach (labelAllsizeResult, 1, 2, 0, 4);
		
			labelAllspaceResult = new Label ("nbSpace");
			table2.Attach (labelAllspaceResult, 1, 2, 0, 5);

			labelAllslackResult = new Label ("nbSlack");
			table2.Attach (labelAllslackResult, 1, 2, 0, 6);

			labelAllFreespaceResult = new Label ("nbFreeSpace");
			table2.Attach (labelAllFreespaceResult, 1, 2, 0, 7);
		
			DLicons = new CheckButton();
			DLicons.Label = "Download icons";
			DLicons.Active = true;
			vboxinside.PackStart (DLicons, false, false, 0);
			// end the inside Vbox 
			#endregion
//=================================================
// 				NoteBook 2
			#region NoteBook 2
			
			VBox vboxnb2 = new VBox (false, 0);
	 		nb.Add(vboxnb2);
	 		nb.SetTabLabelText(vboxnb2, "Load ISO");
		
	 		Toolbar toolbar3 = CreateISOToolbar ();
			vboxnb2.PackStart (toolbar3, false, false, 0);
	 	
			// Add Vertical Frame
			VPaned vpan = new VPaned ();
			vpan.Position = 290;
			vboxnb2.PackStart (vpan, true, true, 0);
			vpan.BorderWidth = 0;

	 		// Add a scrolledWindows for the ISOList
			ScrolledWindow sw2 = new ScrolledWindow ();

			//vboxnb2.PackStart (sw2, false, false, 0);
	 		vpan.Add(sw2);
	 	
			// Create the treeview containing 6 string
			store2 = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string) );
	
			// sort by on name for column 0
			//store.SetSortColumnId(0, 0);
			tv2 = new TreeView (store2);
			tv2.HeadersVisible = true;

			// This is bad but if i don't it that way.
			// it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column2 = new TreeViewColumn ();
			CellRendererText text2 = new CellRendererText ();
			column2.Title = "XBE Title";
			column2.Resizable = true;
			column2.SortColumnId = 0;
	 	
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 0);
			tv2.AppendColumn(column2);

			// 2
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Size";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 1);
			tv2.AppendColumn(column2);
			
			// 3 
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Game Folder";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			column2.Sizing = TreeViewColumnSizing.Autosize;
						
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 2);
			tv2.AppendColumn(column2);
			
			// 4
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Filename";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 3);
			tv2.AppendColumn(column2);
	 	
			// 5
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Region";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 4);
			tv2.AppendColumn(column2);
	 		sw2.Add(tv2);
	 		
	 		// Add a frame with a label Title view
			Frame frame2 = new Frame (" Transfert Options ");
			frame2.BorderWidth = 4;
			//vboxnb2.PackStart (frame2);
	 		vpan.Add(frame2);
	 	
			#region	 ISOoption
	 		Fixed fix = new Fixed();
	 		Label labelSize = new Label();
	 		labelSize.Text = "Size:";
	 		fix.Put(labelSize, 20, 15);
	 	
	 		labelR1 = new Label();
	 		labelR1.Text = "R1";
	 		fix.Put(labelR1, 55, 15);
	 		
	 		Label labelFiles = new Label();
	 		labelFiles.Text = "Files:";
	 		fix.Put(labelFiles, 100, 15);
	 	
	 		labelR2 = new Label();
	 		labelR2.Text = "R2";
	 		fix.Put(labelR2, 135, 15);
	 		
	 		Label labelFolders = new Label();
	 		labelFolders.Text = "Folders:";
	 		fix.Put(labelFolders, 180, 15);
	 	
	 		labelR3 = new Label();
	 		labelR3.Text = "R3";
	 		fix.Put(labelR3, 230, 15);

	 		Label labelMain = new Label();
	 		labelMain.Text = "Main Folder:";
	 		fix.Put(labelMain, 20, 50);
	 	
	 		Entryxboxdir = new Entry();
	 		Entryxboxdir.Text = "xboxdir";
	 		fix.Put(Entryxboxdir, 90, 50);

	 		Label labelGame = new Label();
	 		labelGame.Text = "Game Folder:";
	 		fix.Put(labelGame, 20, 90);
	 	
	 		Entrygamedir = new Entry();
	 		Entrygamedir.Text = "gamedir";
	 		fix.Put(Entrygamedir, 90, 90);

			#endregion

	 		frame2.Add (fix);
			#endregion
//======================================
						
			// Add a Text View
			// Maybe to make a log view better than console
			/*TextView textview = new TextView ();
			vbox.PackStart (textview, true, true, 0);*/
		
			// Bad i need to initialize the game list
			//liste = new string[0];
	 		liste = null;
			CurrentGame = new ArrayList();
			
			// Add a status bar
			statusbar = new Statusbar ();
			statusbar.Push (1, "Xbgm# ready.");
			vbox.PackStart (statusbar, false, false, 0);
			//END of first vbox 
		
		}
			catch(Exception ex){
				Console.WriteLine(ex.Message);
		}
		// Show the all window
		this.ShowAll ();
		
		// Init the FTP structure
		FTPinfo = new FTP();
		//Gtk.Timeout.Add((uint)(1000), new Gtk.Function(UpdateStatusBarTimeOut));
		ReadConf();
		//notify = new ThreadNotify (new ReadyEvent (ready));
	}
	
	void OnMyWindowDelete (object o, DeleteEventArgs args)
	{
		// None work if not using mono command line
/*			window.Hide (); //A tester sous Win32 si ca crash pas
			window.Destroy (); //Pariel pour les 2 platform*/
			
		Application.Quit ();
	}
	
		#region CreateToolbar
		// To create the Game Toolbar
		private Toolbar CreateGameToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			
			toolbar.AppendItem ("Scans Titles",
				"Scans Titles", String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarScanTitlesClicked));
			toolbar.AppendSpace();
	
			pix = new Gdk.Pixbuf (null, "edit.xpm");
			toolbar.AppendItem ("Rename", 
				"Rename", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRenameClicked));	
			
			toolbar.AppendItem ("Launch",
				"Launch Game", String.Empty,
				new Gtk.Image (Stock.Execute, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarLaunchClicked));	
			
			toolbar.AppendItem ("Delete",
				"Delete", String.Empty,
				new Gtk.Image (Stock.Delete, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarDeleteClicked));	
		
			toolbar.AppendSpace();
			
			toolbar.AppendItem ("Save List",
				"Save List", String.Empty,
				new Gtk.Image (Stock.SaveAs, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarExportClicked));	
	
			return toolbar;
		}
		
		// To create ISO Toolbar
		private Toolbar CreateISOToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			
			toolbar.AppendItem ("_Open",
				"Open ISO", String.Empty,
				new Gtk.Image (Stock.Open, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarOpenISOClicked));	
			
			toolbar.AppendItem ("FTP Upload ISO",
				"FTP Upload ISO", String.Empty,
				new Gtk.Image (Stock.GotoTop, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarUploadISOClicked));
		
			toolbar.AppendItem ("Extract ISO",
				"Extract ISO", String.Empty,
				new Gtk.Image (Stock.GotoFirst, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarExtractISOClicked));
			
			return toolbar;
		}
		
		// To create Top Toolbar
		private Toolbar CreateTopToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;

			toolbar.AppendItem ("Configuration",
				"Configuration", String.Empty,
				new Gtk.Image (Stock.Preferences, IconSize.SmallToolbar),
				new Gtk.SignalFunc (OnToolbarPrefClicked));
			
			toolbar.AppendSpace();	
		
			pix = new Gdk.Pixbuf (null, "xbmc.png");
			toolbar.AppendItem ("XBMC", 
				"Xbox Media Center", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarXBMCClicked));	

			toolbar.AppendSpace();	
			
			pix = new Gdk.Pixbuf (null, "shutdown.png");
			toolbar.AppendItem ("Shutdown", 
				"Shutdown Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarShutdownClicked));	
 
			pix = new Gdk.Pixbuf (null, "reboot.png");
			toolbar.AppendItem ("Reboot", 
				"Reboot Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRestartClicked));	
			
			return toolbar;
		}
		#endregion
		
		#region OnToolbarTopClicked
		private void OnToolbarPrefClicked ()
		{
			PrefDialog login = new PrefDialog ();
			
			if (ReadConf() == true)
			{   // set conf value to preference dialog
				login.Password = FTPinfo.pass;
				login.User = FTPinfo.user;
				login.IP = FTPinfo.IP;
				login.Port = FTPinfo.port;
				login.Dir = FTPinfo.dir;
				login.UseCache = cache;
				login.XBMCDir = XBMC;
			}
			login.Run();
			
			FTPinfo.pass  = login.Password;
			FTPinfo.user  = login.User;
			FTPinfo.IP  = login.IP;
			FTPinfo.dir  = login.Dir;		
			FTPinfo.port = login.Port;
			cache = login.UseCache;
			XBMC = login.XBMCDir;
			login.Close();			
			login = null;
			
			SaveConf();
		}

		private void OnToolbarXBMCClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.xbmc;
			FtpToXbox("");
			UpdateStatusBar("Xbox Media Center Start");
		}
		
		private void OnToolbarShutdownClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.shutdown;
			FtpToXbox("");
			//FtpToXbox(4, ""); // Shutdown
			UpdateStatusBar("Xbox Shutdown");
		}

		private void OnToolbarRestartClicked()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			// Do xbox Stuff
			xboxAction = FtpXbox.reboot;
			FtpToXbox("");
			//FtpToXbox(5, ""); // Restart
			UpdateStatusBar("Xbox Reboot");
		}
		#endregion

		#region OnToolbarGameClicked
		private void OnToolbarScanTitlesClicked ()
		{	
			ReadConf();
			
			// Check Conf
			if(FTPinfo.IP == null)
				return;
			
			// Clear the Liststore
			store.Clear();
			
		/*	// Ask for cache
			// Give me GTk error!!!!
			MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent, 
			                                      MessageType.Question, 
			                                      ButtonsType.YesNo, 
			                                      "Do you wish to use cache?");			
			// need to check what the user choose.
			int result = md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
			if (result  == (int)ResponseType.Yes)
		*/
			bool ok = false;			
			// Get the Game listing for the Xbox or cache			
			if(cache)
			{	// if we use cache we  have titles files and icons
				ok = ParseCacheTitles();
			}
			if(!ok)
			{
				UpdateStatusBar("Scanning Titles... Please Wait");
				xboxAction = FtpXbox.scan;
				// Do xbox stuff
				FtpToXbox(""); // Get Titles from xbox
			}
			
			UpdateStatusBar("XBGM# Ready.");		
		}

		private void OnToolbarLaunchClicked()
		{
			// Launch Game by FTP Command
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )	
				{
					Console.WriteLine(CurrentGame[0]);
					Console.WriteLine(CurrentGame[1]);
					Console.WriteLine(CurrentGame[2]);
					Console.WriteLine(CurrentGame[3]);
					Console.WriteLine("user: \"" + FTPinfo.user + "\" pass: \"" + FTPinfo.pass + "\" IP: \"" + FTPinfo.IP + "\" Dir: \"" + FTPinfo.dir + "\"");
				}
				#endif
				// DO xbox FTp stuff
				xboxAction = FtpXbox.launch;
				FtpToXbox("");
				UpdateStatusBar("Xbox game " + CurrentGame[0] + " Launched");			
			
			// tell the user the game as been launch
			// Got a GTk warning each time i use MessageDialog 
			// (found the same problem in other project)
			//(<unknown>:1288): Gdk-WARNING **: [Invalid UTF-8] gdkwindow-win32.c:1636: SetWindowLong failed: Accs refus.
		/*	MessageDialog md = new MessageDialog (this, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Info,
			                                      ButtonsType.Close, 
			                                      "The game " + CurrentGame[0] + " has been launch.");
			md.Run ();
			md.Hide ();
			md.Dispose ();
			md.Destroy ();
		*/
			}
		}
		
		private void OnToolbarLaunchClicked(object o, EventArgs args)
		{
			OnToolbarLaunchClicked();
		}
				
		private void OnToolbarDeleteClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )
					Console.WriteLine(CurrentGame[2]);
				#endif

				DeleteDialog login = new DeleteDialog (CurrentGame[0].ToString());
				login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got DeleteDialog");	
				#endif
				if (login.action == 1)
					deletesave = false;
				if (login.action == 2)
					deletesave = true;
				if (login.action == 3)
					deletesave = true;
				
				login.Close();
				login = null;

				// DO xbox FTp stuff
				xboxAction = FtpXbox.delete;
				FtpToXbox("");
				//FtpToXbox(1, ""); // Delete
			}
		}		

		private void OnToolbarDeleteClicked(object o, EventArgs args)
		{
			OnToolbarDeleteClicked();
		}
		
		private void OnToolbarRenameClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				RenameDialog login = new RenameDialog (CurrentGame[0].ToString());
				login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got RenameDialog");	
				#endif
				string newgamename  = login.Game;
				#if ( DEBUG )
					Console.WriteLine("New name: " + newgamename);
				#endif
				login.Close();
				login = null;
				// DO xbox FTp stuff
				xboxAction = FtpXbox.rename;
				FtpToXbox(newgamename);
				//FtpToXbox(2, newgamename); // Delete
			}
		}	

		private void OnToolbarRenameClicked(object o, EventArgs args)
		{
			OnToolbarRenameClicked();
		}
		
		private void OnToolbarExportClicked ()
		{
			if(liste != null)
			{
				FileSelection fDlg = new FileSelection("Create a html file.");
	    		fDlg.Complete("*.html");
	    		int nRc = fDlg.Run();
	    		fDlg.Hide();
				
				if(nRc == (int)ResponseType.Ok) {
					Console.WriteLine(fDlg.Filename);
					ExportToHTML(fDlg.Filename);
				}
			}
		}
		#endregion
		
		#region OnToolbarISOClicked
		private void OnToolbarOpenISOClicked ()
		{
			ReadConf();
			// Check Conf
			if(FTPinfo.dir == null)
				return;
    		FileSelection fDlg = new FileSelection("Choose a ISO file.");
    		fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
			
			if(nRc == (int)ResponseType.Ok) {
				#if ( DEBUG )
					Console.WriteLine(fDlg.Filename);
				#endif
				xisofilename = fDlg.Filename;
				XisoClass iso = new XisoClass();
				iso.getfileiniso(fDlg.Filename);
				labelR1.Text  = iso.isosize.ToString() + " MB";
				labelR2.Text = iso.Nbfiles.ToString();
				labelR3.Text = iso.Nbdir.ToString();
				Entryxboxdir.Text = FTPinfo.dir;
				Entrygamedir.Text = iso.GameFolder;
				string[] info = null;
/*				directoryName = System.IO.Path.GetDirectoryName(theEntry.Name);
				fileName      = System.IO.Path.GetFileName(theEntry.Name);
*/				if(iso.GameRegion == 1)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "NTSC"};
				else if(iso.GameRegion == 2)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "JP"};
				else if(iso.GameRegion == 4)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "PAL"};
				else
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "Mix"};
				store2.Clear();
				AddISOInfoToRow(info);
				info = null;
				iso = null;			
			}
		}
		
		private void OnToolbarUploadISOClicked ()
		{
			if(xisofilename != null)
			{
				XisoClass iso = new XisoClass();
				iso.hdd = false;
				iso.extractiso(xisofilename, Entryxboxdir.Text, 
				               Entrygamedir.Text, 
				               FTPinfo.IP, FTPinfo.port, 
				               FTPinfo.user, FTPinfo.pass, FTPinfo.dir);
				iso = null;	
			}
		}

		private void OnToolbarExtractISOClicked ()
		{ 
			// Need to Specifed where to extract iso on HDD
			FileSelection fDlg = new FileSelection("Choose a ISO file.");
			fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
			if(nRc == (int)ResponseType.Ok) {
			  	FileSelection DirDlg = new FileSelection("Choose a Destination Directory.");
				DirDlg.SelectionEntry.Text = System.IO.Path.GetDirectoryName(fDlg.Filename);
    			int nRdir = DirDlg.Run();
    			DirDlg.Hide();
				if(nRdir == (int)ResponseType.Ok) {
					#if ( DEBUG )
						Console.WriteLine("File : [" + fDlg.Filename + "] Dir: [" + DirDlg.Filename + "]");
					#endif
					XisoClass iso = new XisoClass();
					iso.hdd = true;
					iso.getfileiniso(fDlg.Filename);
					string gameextractdir = System.IO.Path.GetFileName(fDlg.Filename);
					gameextractdir = gameextractdir.Substring(0 ,gameextractdir.LastIndexOf('.'));
					iso.extractiso(fDlg.Filename, DirDlg.Filename, 
					               gameextractdir, 
					               "", 0, "", "", "");
					gameextractdir = null;
					iso = null;	
				}
				DirDlg = null;
			}
			fDlg = null;
		}
		#endregion

		[GLib.ConnectBefore]
		public void OnTreeviewButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("test Button click");
			#endif
			 switch (args.Event.Button)
            {
                case 3:
                        PopupMenu (args.Event);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenu (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu!");
            #endif
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
					item = new ImageMenuItem (Stock.Execute, group);
            		item.Activated += new EventHandler (OnToolbarLaunchClicked);
            		menu.Append (item);
            	
            	
            		item = new Gtk.ImageMenuItem ("Edit");
            		pix = new Gdk.Pixbuf (null, "edit.xpm");
					new Gtk.Image (pix);
            		item.Image = new Gtk.Image (pix);
            		item.Activated += new EventHandler (OnToolbarRenameClicked);
				    menu.Append (item);

                    item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteClicked);
                    menu.Append (item);                                   	
            }
            
            menu.ShowAll ();
            menu.Popup (null, null, null, IntPtr.Zero,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        private void PopupMenuCb(object o, PopupMenuArgs args)
        {
            Console.WriteLine ("Popup Menu Called!");
            PopupMenu (null);
        } 

		public void ExportToHTML(string filename)
		{
			StreamWriter outputFilestream = null;
			try {
				outputFilestream = new StreamWriter(filename);
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to setup output export file. " + 
					e.Message);
				return;
			}

			StringBuilder strHtml = new StringBuilder();

			strHtml.Append("<html>\n<head><title>");
			strHtml.Append("Titles list");
			strHtml.Append("</title></head>\n");
			strHtml.Append("<body>\n");
			strHtml.Append("<h1>Titles list</h1>\n");
			strHtml.Append("\t<table border=1>\n");
			strHtml.Append("\t\t<tr>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Game Titles</td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Size MB </td>\n");
			strHtml.Append("\t\t\t<td align=\"center\">Path </td>\n");
			strHtml.Append("\t\t</tr>\n");
			outputFilestream.WriteLine(strHtml.ToString());		
			strHtml = new StringBuilder();
			foreach(string toto in liste)
			{
				strHtml = new StringBuilder();
				string[] a = toto.Split('|');
				strHtml.Append("\t\t<tr>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + a[0] + "</td>\n");
				strHtml.Append("\t\t\t<td align=\"center\"> " + a[2] + " MB</td>\n");
				strHtml.Append("\t\t\t<td align=\"left\"> " + a[5] + "</td>\n");
				strHtml.Append("\t\t</tr>\n");
				outputFilestream.WriteLine(strHtml.ToString());
				strHtml = null;
			}
			outputFilestream.WriteLine("\t</table>\n</body>\n</html>\n");
			strHtml = null;
			outputFilestream.Close();
			outputFilestream = null;
			Console.WriteLine("Outputting HTML file done.");		
		}
		
		#region ParseTitles
		public bool ParseCacheTitles()
		{
        		// get an character input stream to read data from .
        		StreamReader reader = null;
        		try
        		{
					reader = new StreamReader("titles.txt");
        		}
				catch(Exception e) {
					Console.WriteLine("Warning: Unable to open cache file. " + 
						e.Message);
					return false;
				}
				
				// read a line at a time
				ArrayList GameLines = new ArrayList();
				string line = null;
				int 	nbTitles = 0;
				Int64 totsizeMb = 0;
				Int64 totspaceMb = 0;
				Int64 totnbFolders = 0;
				Int64 totnbFiles = 0;	

				// an empty array of files for 150
				//string[] liste = new string[0];
				
				while ((line = reader.ReadLine()) != null)
				{
					//Console.WriteLine("==> " + line);
					string[] one =	line.Split('\t');
					/*	0 dir xbe /// 1 name game /// 2 Size /// 3  Space ///	4 ID 
					    5 FolDERS /// 6 FILES    /// 7 N/A  /// 8 REGION
					*/
				nbTitles ++;
				string[] directory = one[3].Split('/');
				// Convert size 
				//Console.WriteLine(one[1] + " == "  + one[2]);
				Int64 tmpsize = Convert.ToInt64(one[2]);
				Int64 tmpspace = Convert.ToInt64(one[3]);
				tmpsize >>= 20;
				tmpspace >>= 20;					
				//tmpsize = tmpsize / 1024000;
				string size = tmpsize.ToString();
				string space = tmpspace.ToString();
				//Console.WriteLine(size.Length + "==" + size);
				string sizeMb = "";
				string spaceMb = "";
				sizeMb = size + " MB"; 
				spaceMb = space + " MB"; 

				totsizeMb += tmpsize;
				totspaceMb += tmpspace;
				totnbFolders += Convert.ToInt64(one[5]);
				totnbFiles += Convert.ToInt64(one[6]);
				
				string[] dirtmp = one[0].Split('/');
				//string dirgame = "/" + dirtmp[1] + "/" + dirtmp[2];
				string dirgame = dirtmp[1];
				
				string region = "N/A";
				if (one[8] == "4")
				{
					region = "PAL";
				}
				else if(one[8] == "3")
				{
					region = "Mix";
				}
				else if(one[8] == "1")
				{
					region = "NTSC";
				}
				else if(one[8] == "2")
				{
					region = "JP";
				} 
				else {
					region = "None";
				}
				//Console.WriteLine("==> " + one[1]  + " " + sizeMb  + " " + dirgame + " " + one[6]  + " " +  region);
				string[] info = new string[]{one[1], sizeMb, dirgame, one[6], one[5], region};
				AddTextToRow(info);
				///			6 Field			// Game name, 		ID, 	Space, 				Slack, 						XBE, 												DirGame	
				//string[] gamefield = new String[]{one[1], one[4], tmpspace.ToString(), (tmpspace - tmpsize).ToString(), "/" + dirtmp[1] + "/" + dirtmp[2] + "default.xbe", "/" + dirtmp[1] + "/" + dirtmp[2]};
				// So Here i create my one string with the | separator
				// That way i don't care about space in game name
				//Console.WriteLine("==> " + one[1]  + " " + one[4]);
				string gamefield2 = one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + "/" + dirtmp[0] + "/" + dirtmp[1] + "/" + dirtmp[2] + "|" + FTPinfo.dir + "/" + dirtmp[1] + "/";				//GameLines.Add(gamefield.ToString());
				GameLines.Add(gamefield2); // OK
				//GameLines.Add(one[1]);
				//TheList[nbTitles][0] = gamefield.ToString();
				//GamesArray[nbTitles].SetValue(gamefield);
				//Console.WriteLine("Add field " + gamefield2); // OK
				//Console.WriteLine("Add field " + gamefield[0] +"  =  "+ gamefield[1].ToString());
				}
				try
				{
					reader.Close();
				}
				catch (IOException)
				{
				}
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = nbTitles.ToString();
			labelAllfilesResult.Text = totnbFiles.ToString();
			labelAllfoldersResult.Text = totnbFolders.ToString();
			labelAllsizeResult.Text = totsizeMb.ToString() + " MB";
			labelAllspaceResult.Text = totspaceMb.ToString() + " MB";
			labelAllslackResult.Text = (totspaceMb - totsizeMb) + " MB";
			
			
			// Save the full list in my global list
			// if any
			if (GameLines.Count > 0){
				#if ( DEBUG )
					Console.WriteLine("nb Games: " + GameLines.Count)	;
				#endif
				liste = (string[]) GameLines.ToArray(typeof(string));
		// Should be the same result as nb Games
		// Console.WriteLine("lenght liste: " + liste.Length);
		
		
		// example to get info in my list of game
		/*		foreach(string toto in liste)
				{
					string[] a = toto.Split('|');
					Console.WriteLine("test1: "  + a[0]);
				}
		*/
			}
			return true;
		}

		public void ParseFTPTitles(string listings)
		{
				ArrayList GameLines = new ArrayList();
				int 	nbTitles = 0;
				Int64 totsizeMb = 0;
				Int64 totspaceMb = 0;
				Int64 totnbFolders = 0;
				Int64 totnbFiles = 0;
			
				//Console.WriteLine("==> [" + listings + "]");
			
				// Get nb Games
				string[] full =	listings.Split('|');
				#if ( DEBUG )
					Console.WriteLine("nb lines:["+ full[1]+ "]");
				#endif
				string[] line =	full[0].Split('\n');
				for (Int32 i = 0; i < Convert.ToInt32(full[1]); i++)
				{
					#if ( DEBUG )
						Console.WriteLine(Convert.ToInt32(full[1]) + " I:" + i + "] [" + line[i] + "]");
					#endif
					//Console.WriteLine("==> " + line);
					string[] one =	line[i].Split('\t');
					/*	0 dir xbe /// 1 name game /// 2 Size /// 3  Space ///	4 ID 
					    5 FolDERS /// 6 FILES    /// 7 N/A  /// 8 REGION
					*/
				nbTitles ++;

				// Convert size 
				//Console.WriteLine(one[1] + " == "  + one[2]);
				Int64 tmpsize = Convert.ToInt64(one[2]);
				Int64 tmpspace = Convert.ToInt64(one[3]);
				tmpsize >>= 20;
				tmpspace >>= 20;					
				string size = tmpsize.ToString();
				string space = tmpspace.ToString();
				//Console.WriteLine(size.Length + "==" + size);
				string sizeMb = size + " MB";
				string spaceMb = space + " MB";

				totsizeMb += tmpsize;
				totspaceMb += tmpspace;
				totnbFolders += Convert.ToInt64(one[5]);
				totnbFiles += Convert.ToInt64(one[6]);
								
				string tmpdir = one[0].ToString();
				string dir = tmpdir.Substring(0, tmpdir.LastIndexOf('/')+1);
				string xbe = tmpdir.Substring(tmpdir.LastIndexOf('/')+1);	
				string showdir = tmpdir.Substring(FTPinfo.dir.Length, (tmpdir.IndexOf("default.xbe") - FTPinfo.dir.Length) - 1);	
				//Console.WriteLine("==>{0} + {1} + {2} + {3} + {4}", FTPinfo.dir.Length, tmpdir, dir, tmpdir.IndexOf("default.xbe"), showdir);
				tmpdir = null;
				
				string region = "N/A";
				if (one[8] == "4")
					region = "PAL";
				else if(one[8] == "3")
					region = "Mix";
				else if(one[8] == "1")
					region = "NTSC";
				else if(one[8] == "2")
					region = "JP";
				else {
					region = "None";
				}
				//Console.WriteLine("==> " + one[1]  + " " + sizeMb  + " " + dirgame + " " + one[6]  + " " +  region);
				string[] info = new string[]{one[1], sizeMb, showdir, one[6], one[5], region};
				AddTextToRow(info);
				// So Here i create my one string with the | separator
				// That way i don't care about space in game name
				//	6 Field		// Game name, 		ID, 	       Space, 				        Slack, 						           XBE, 	, DirGame	
				string gamefield2 = one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + xbe + "|" + dir;
				GameLines.Add(gamefield2); // OK
				//Console.WriteLine(one[1] + "|" + one[4] + "|" +  tmpspace.ToString() + "|" + (tmpspace - tmpsize).ToString() + "|" + xbe + "|" + dir);
				//Console.ReadLine();
				// Clean memory 
				dir = xbe  = showdir = null;
				spaceMb = sizeMb = null;
			// END FOR
		        }
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = nbTitles.ToString();
			labelAllfilesResult.Text = totnbFiles.ToString();
			labelAllfoldersResult.Text = totnbFolders.ToString();
			labelAllsizeResult.Text = totsizeMb.ToString() + " MB";
			labelAllspaceResult.Text = totspaceMb.ToString() + " MB";
			labelAllslackResult.Text = (totspaceMb - totsizeMb) + " MB";		
			
			// Save the full list in my global list
			// if any
			if (GameLines.Count > 0)
			{
				#if ( DEBUG )
					Console.WriteLine("nb Games: " + GameLines.Count);
				#endif
				liste = (string[]) GameLines.ToArray(typeof(string));
		// Should be the same result as nb Games
		// Console.WriteLine("lenght liste: " + liste.Length);
		
		
			// example to get info in my list
			/*		foreach(string toto in liste)
					{
						string[] a = toto.Split('|');
						Console.WriteLine("test1: "  + a[0]);
					}
			*/
			//END IF
			}

		// Function
		}
		#endregion
		
		public void UpdateStatusBar(string msg) //Unse maybe in Next release
		{
			statusbar.Push (1 , msg);
		}
	
		public bool UpdateStatusBarTimeOut() //Unse maybe in Next release
		{
			statusbar.Push (1 , "Coucou update");
			return true;	// must return true from timeout to keep it active
		}
	
		// Each arg is a new column
		public void AddTextToRow (params string[] args)
		{	
			iter = store.AppendValues(args);
			tv.Model = store;
			//store.Reorder();
		}		
			
		// Each arg is a new column
		public void AddISOInfoToRow (params string[] args)
		{	
			iter2 = store2.AppendValues(args);
			tv2.Model = store2;
		}

		// Get single selection
		private void on_List_selection(object o, EventArgs args)
		{	
			string result;
			string sel;
			
			store.GetIterFirst(out iter);
			if (tv.Selection.IterIsSelected(iter)) 
			{
				result = (string)store.GetValue(iter, 0);
				#if ( DEBUG )
					Console.WriteLine("Result First sel: " + result);
				#endif
				FindGame(result);
			}
			
			while (store.IterNext(ref iter)) {
				if ( tv.Selection.IterIsSelected(iter)) {
					sel = (string)store.GetValue(iter, 0);
					#if ( DEBUG )
						Console.WriteLine("Result sel: " + sel);
					#endif
					FindGame(sel);
				}
			}
		}

		// Get Pixbuf from BMP image for title		
	    static Gdk.Pixbuf GetPixbufFromFile (string filename)
	    {
	        try {
	            Pixbuf p = new Pixbuf (filename);
	            return p;
	
	        } catch (GLib.GException e) {
	            Console.WriteLine (e.GetType ());
	            Console.WriteLine ("Cannot Open image file.");
	        	// DOn't know but it kill the application
	            //Environment.Exit (1);
	            return null;
	        }
	
	    }
	
		// Find a game in the list form a string
		public void FindGame(string tofind)    
		{
			foreach(string toto in liste)
			{
				string[] a = toto.Split('|');
				//	Console.WriteLine("GameName: "  + a[0]);
				if (a[0].Equals(tofind))
					{
						#if ( DEBUG )
							Console.WriteLine("ok i found: "  + a[0]);
						#endif
						UpdateSelectedTitleInfo(a);
					}
			}
		}
	
		// Update Selected Title Info Label
		public void UpdateSelectedTitleInfo(string[] newgameselected)
		{
			labelIDresult.Text = newgameselected[1];
			labelSpaceresult.Text = newgameselected[2] + " MB";
			labelSlackresult.Text = newgameselected[3] + " MB";
			//Console.WriteLine("ImageFile: " + nwgameselected[1] + ".bmp");
			//image = new Image(a[1] + ".bmp");
			
			if (DLicons.Active)
			{
				try
				{
				// Bad this is growindg in memory for each image pixbuf .
				// event if the image was all ready open
				Pixbuf p = GetPixbufFromFile ("titleimage/" + newgameselected[1] + ".bmp");
				image.Pixbuf = p;
				}	
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache icon file.");
					Console.WriteLine(e.Message);
					return;
				}	
			}
	
			if (CurrentGame != null)
			{
				CurrentGame.Clear();
			}
			// Create my list of the current game with info i need 
			CurrentGame.Add(newgameselected[0]); // name
			CurrentGame.Add(newgameselected[4]); // XBE
			CurrentGame.Add(newgameselected[5]); // dir
			CurrentGame.Add(newgameselected[1]); // ID
			#if ( DEBUG )
				Console.WriteLine("Nb info in CurrentGame: " + CurrentGame.Count);
				Console.WriteLine("==> {0},{1},{2},{3}", CurrentGame[0],
				                  CurrentGame[1], CurrentGame[2],
				                  CurrentGame[3]);
			#endif
		}
		
		// Handle zip file for picture titles
		public static void ZipExtract(string args)
		{
			ZipInputStream s = null;
			try
			{
				s = new ZipInputStream(File.OpenRead(args));
	        	}
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache zip image file.");
					Console.WriteLine(e.Message);
					return;
				}
				ZipEntry theEntry;
				#if ( DEBUG )
					Console.WriteLine("Zip:" + args);
				#endif
				while ((theEntry = s.GetNextEntry()) != null) 
				{
					#if ( DEBUG )
						Console.WriteLine(theEntry.Name);
					#endif
					string directoryName = null;
					string fileName = null;
					try
					{
						directoryName = System.IO.Path.GetDirectoryName(theEntry.Name);
						fileName      = System.IO.Path.GetFileName(theEntry.Name);
					}
					catch(Exception e) {
						Console.WriteLine("Error: Unable to open zip file. Zip File is corrupt " + 
							e.Message);
						return;
					}
					// we don't want it, i will do it mself
					// create directory
					//string[] dir = directoryName.Split('\');
					
					Directory.CreateDirectory("titleimage");
					string filenames = "titleimage/" + fileName;
	
					if (fileName != String.Empty) 
					{
						FileStream streamWriter = File.Create(filenames);
					
						int size = 2048;
						byte[] data = new byte[2048];
						while (true) 
						{
							size = s.Read(data, 0, data.Length);
							if (size > 0) 
							{
								streamWriter.Write(data, 0, size);
							} 
							else 
							{
								break;
							}
						}
					
						streamWriter.Close();
					}
				}
				s.Close();
			// End Zip
			}
		
		// FTP Connect then to the selected command  
		public void FtpToXbox(string newgamename)
		{
			try
			{
				UpdateStatusBar("FTP job Start.");
				// Create socket
				//FTPClient ftp = new FTPClient(FTPinfo.IP, FTPinfo.port, null, 2);
				FTPClient ftp = new FTPClient(FTPinfo.IP, FTPinfo.port);
				#if ( DEBUG )
					ftp.DebugResponses(true);
				#endif
				// Login
				ftp.Login(FTPinfo.user, FTPinfo.pass);
				ftp.System();
				// Crash on Linux
				//ftp.Timeout = 10;
				switch(xboxAction) 
				{
					case FtpXbox.scan: // Get Titles
					{
						ftp.TransferType = FTPTransferType.BINARY;
						// Do all command and get titles game in a string[]
						// The problem of this is than i need to wait to recevied the all list of Game
						string listings = ftp.GetTitles(FTPinfo.dir);
							
						ParseFTPTitles(listings);
						listings = null;
					
						// Check if i need to DL icons
						if (DLicons.Active)
						{
							ftp.Site("TITLEIMAGES");
							ftp.Get(@"titleimage.zip", @"/Z:/titleimage.zip");
							ZipExtract(@"titleimage.zip");
						}
						
						ftp.Site("FREEROOTSPACEENABLE");
						string[] rootspace = ftp.Dir("/", true);
						foreach(string space in rootspace)
						{
							//Console.WriteLine("Space:" + space + "]");
							string[] free = space.Split(' ');
							//Console.WriteLine("[" + free[24].ToString() +"] == [" +FTPinfo.dir.Substring(0, 2) +"]");
							if(free[24].Equals(FTPinfo.dir.Substring(0, 2)))
							{
								//Console.WriteLine("Free Space:" + free[26].ToString());
								labelAllFreespaceResult.Text = free[26].ToString() + " MB";
							}
						}
						
						break;
					}
					case FtpXbox.delete: // Delete
					{
						ftp.TransferType = FTPTransferType.BINARY;
						
						// I don't know why but they do it
						ftp.Site("FREEROOTSPACEDISABLE ");			
						
													// xbe full path
						bool ok = ftp.Site("DELTREE " + CurrentGame[2]);			
						if(ok == false)
						{
							// then we do it the old way
							ftp.Rmdir(CurrentGame[2].ToString());
						}
						
						if(deletesave)
						{										//ID
							ok = ftp.Site(@"DELTREE /E:/UDATA/" + CurrentGame[3]);
							ok = ftp.Site(@"DELTREE /E:/TDATA/" + CurrentGame[3]);
						}
						break;
					}

					case FtpXbox.rename: // Rename XBE
					{
						ftp.TransferType = FTPTransferType.BINARY;
											    // xbe full path
						ftp.Site("XBERENAME \"" + CurrentGame[2] + CurrentGame[1] + "\" " + newgamename);			
						break;
					}
					case FtpXbox.launch: // Launch 
					{
						ftp.TransferType = FTPTransferType.BINARY;
											// full path      // xbe
						ftp.Site("LAUNCH " + CurrentGame[2] + CurrentGame[1]);			
						break;
					}
					case FtpXbox.shutdown: // Shutdown
					{
						ftp.Site("SHUTDOWN");			
						break;
					}
					case FtpXbox.reboot: // Restart
					{
						ftp.Site("REBOOT");			
						break;
					}
					case FtpXbox.xbmc: // Launch XBMC
					{
						ftp.TransferType = FTPTransferType.BINARY;
		
										// XBMC xbe full path
						ftp.Site("LAUNCH " + XBMC);			
						break;
					}
					default:            
            			Console.WriteLine("Invalid FTP selection. Please select scan, rename, delete, launch, xbmc, reboot or shutdown.");            
            			break;  

				}

				// The default quit wait for a reply but there is none
				// so it crash, need to catch exception
				// or do it like this, I made my own Quit with out reply
				ftp.QuitXbox();
				UpdateStatusBar("FTP job Done.");
			// END try
			}
			catch (IOException ex) 
			{
				Console.WriteLine("Caught IO exception: " + ex.Message);
				return ;
			}
			catch (FTPException ex) 
			{
				Console.WriteLine("Caught FTP exception: " + ex.Message);
				return ;
			}
			catch (SocketException ex)
			{
				Console.WriteLine("Caught Socket exception: " + ex.Message);
				return ;
			}
		}
		
		#region conffile
		public void SaveConf()
		{		
			StreamWriter outputConfstream = null;
			try {
				outputConfstream = new StreamWriter("xbgmsharp.conf");
			}
			catch(Exception e) {
				Console.WriteLine("Error: Unable to setup conf file. " + 
					e.Message);
				return;
			}

			outputConfstream.WriteLine(FTPinfo.IP);
			outputConfstream.WriteLine(FTPinfo.port);
			outputConfstream.WriteLine(FTPinfo.dir);
			outputConfstream.WriteLine(FTPinfo.user);
			outputConfstream.WriteLine(FTPinfo.pass);
			outputConfstream.WriteLine(cache?"Y":"N");
			outputConfstream.WriteLine(XBMC);
			outputConfstream.Flush();
			outputConfstream.Close();
			outputConfstream = null;
		}
		
		public bool ReadConf()
		{
			//Catch exception and exit 	if not fount WHY?
			StreamReader inputConfstream = null;
			try {
				inputConfstream = new StreamReader("xbgmsharp.conf");
			}
			catch(Exception e) {
				Console.WriteLine("Warning: Unable to open conf file. " + 
					e.Message);
				return false;
			}
			string line = null;
			int nbline = 0;
			while((line = inputConfstream.ReadLine()) != null)
			{
				switch(nbline)
				{
					case 0:
						FTPinfo.IP = line.ToString();
						break;
					case 1:
						FTPinfo.port = Convert.ToInt32(line.ToString());
						break;
					case 2:
						FTPinfo.dir = line.ToString();
						break;
					case 3:
						FTPinfo.user = line.ToString();
						break;
					case 4:
						FTPinfo.pass = line.ToString();
						break;
					case 5:
						{
						string result = line.ToString();
						if(result.Equals("Y"))
							cache = true;
						else
							cache = false;
						break;
						}
					case 6:
						{
						XBMC = line.ToString();
						break;
						}
					default:
						Console.WriteLine("Error in conf file, Line not handle");
						break;
				}
				nbline++;
			}
			inputConfstream.Close();
			inputConfstream = null;
			#if ( DEBUG )
				Console.WriteLine("Readconf == user: \"" + FTPinfo.user + "\" pass: \"" + FTPinfo.pass + "\" IP: \"" + FTPinfo.IP + "\" PORT: \"" + FTPinfo.port + "\" Dir: \"" + FTPinfo.dir + "\"");
			#endif
			return true;
		}
		#endregion
	}
// End NameSpace
}

