/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  XBGM# Team (See AUTHORS)
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005-03-25 Pascal Giard <evilynux@gmail.com>
/// - initial version
///
/// </summary>

// created on 2005-03-25 at 18:13

using System;

namespace Xbgm.Core
{
	public struct GameInfo
	{
		public string name;
		public string id;
		public Int64 size;
		public Int64 space;
		public string path; // tmpdir
		public string region;
		public Int64 nbFolders;
		public Int64 nbFiles;
		
		public string SizeMB() { return this.size.ToString() + " Mb"; }
		public string SpaceMB() { return this.space.ToString(); }
		
		public string Xbe()
		{
			return this.path.Substring(this.path.LastIndexOf('/')+1); 
		}
		
		public string Directory()
		{
			return this.path.Substring(0, this.path.LastIndexOf('/')+1);
		}
	}
}
