/*
 * Copyright (C) 2003 Sanjay Madhavan.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.revasoft.shoutcast.plsdownloader;

public class PlsDescriptor implements PlsConstants {

	//

	private String oSequence = "00";
	private String oUrl = null;
	private String oDescription = null;
	private String oBitRate = null;

	/**
	 * @param pageSequence
	 * @param pageUrl
	 * @param pageDescription
	 */
	public PlsDescriptor(
		String pageSequence,
		String pageUrl,
		String pageDescription,
		String bitRate) {

		setSequence(pageSequence);
		setDescription(pageDescription);
		setUrl(pageUrl);
		setBitRate(bitRate);
	}
	public String toString() {

		return "{"
			+ (getSequence() == null ? "" : getSequence())
			+ " , "
			+ (getDescription() == null ? "" : getDescription())
			+ " , "
			+ (getBitRate() == null ? "" : getBitRate())
			+ " , "
			+ (getUrl() == null ? "" : getShortUrl(getUrl()))
			+ "}";
	}
	/**
	 * @param string
	 * @return
	 */
	private String getShortUrl(String string) {
		if (string != null) {
			int ndx = string.indexOf("?rn=");

			if (ndx > 0) {
				int ndx2 = string.indexOf("&", ndx);
				if (ndx2 > 0) {
					return string.substring(ndx + 1, ndx2);
				}
			}
		}
		return string;
	}
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return oDescription;
	}

	/**
	 * @param description
	 *            The description to set.
	 */
	public void setDescription(String description) {
		oDescription = description;
	}

	/**
	 * @return Returns the sequence.
	 */
	public String getSequence() {
		return oSequence;
	}

	/**
	 * @param sequence
	 *            The sequence to set.
	 */
	public void setSequence(String sequence) {
		oSequence = sequence;
	}

	/**
	 * @return Returns the url.
	 */
	public String getUrl() {
		return oUrl;
	}

	/**
	 * @param url
	 *            The url to set.
	 */
	public void setUrl(String url) {
		oUrl = url;
	}

	/**
	 * @return Returns the bitRate.
	 */
	public String getBitRate() {
		return oBitRate;
	}

	/**
	 * @param bitRate
	 *            The bitRate to set.
	 */
	public void setBitRate(String bitRate) {
		oBitRate = bitRate;
	}
	/**
	 * @param string
	 * @return
	 */
	public static PlsDescriptor fromFileName(String fileName) {
		String string = Util.getUnqualifiedFileName(fileName);
		int i = string.indexOf(' ');
		String seq = string.substring(0, i);
		string = string.substring(i);
		//
		i = string.indexOf('(');
		String descr = string.substring(0, i);
		string = string.substring(i + 1);
		i = string.indexOf(')');
		String bitrate = string.substring(0, i);

		return new PlsDescriptor(seq, null, descr, bitrate);
	}

	public String getFileName(GenreDescriptor genre) {
		String fileName = getDescription();
		if (fileName.length() == 0)
			fileName = genre.getDescription();
		if (fileName.length() == 0)
			fileName = genre.getKey();
		if (fileName.length() == 0)
			fileName = "Unknown";

		fileName =
			Character.toUpperCase(fileName.charAt(0)) + fileName.substring(1);

		if (fileName.length() > MAX_FILELENGTH) {
			fileName = fileName.substring(0, MAX_FILELENGTH);
		}
		fileName =
			getSequence()
				+ SPACE
				+ fileName
				+ SPACE
				+ OPEN_BRACKET
				+ getBitRate()
				+ CLOSE_BRACKET
				+ PLS_EXTENSION;
		return fileName;
	}
}
