/*
 * Copyright (C) 2003 Sanjay Madhavan.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.revasoft.shoutcast.plsdownloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/**
 * @author Sanjay
 * 
 *  
 */
public class Util {
	private static int CONNECTION_TIMEOUT = 5000;

	//
	public static String getHttpGetContents(
		String url,
		String proxyHost,
		int proxyPort) {
		return getPageContents(proxyHost, proxyPort, new GetMethod(url));
	}

	public static String getHttpPostContents(
		String url,
		String proxyHost,
		int proxyPort) {
		return getPageContents(proxyHost, proxyPort, new PostMethod(url));
	}
	private static String getPageContents(
		String proxyHost,
		int proxyPort,
		HttpMethod method) {
		boolean logHeaders = false;

		String pageContents = null;

		HttpClient client = new HttpClient();
		client.setConnectionTimeout(CONNECTION_TIMEOUT);

		if (proxyHost != null && proxyHost.trim().length() > 0)
			method.getHostConfiguration().setProxy(proxyHost, proxyPort);

		method.setFollowRedirects(true);

		String responseBody = null;
		URI url= null;
		try {
			url = method.getURI();
		} catch (URIException e) {
			 
			e.printStackTrace();
		}
		try {
			client.executeMethod(method);
			responseBody = method.getResponseBodyAsString();
		} catch (HttpException he) {
			System.err.println("Http error connecting to '" + url + "'");
			System.err.println(he.getMessage());
			return null;
		} catch (IOException ioe) {
			System.err.println("Unable to connect to '" + url + "'");
			return null;
		}

		if (logHeaders) {
			//write out the request headers
			System.out.println("*** Request ***");
			System.out.println("Request Path: " + method.getPath());
			System.out.println("Request Query: " + method.getQueryString());
			Header[] requestHeaders = method.getRequestHeaders();
			for (int i = 0; i < requestHeaders.length; i++) {
				System.out.print(requestHeaders[i]);
			}

			//write out the response headers
			System.out.println("*** Response ***");
			System.out.println("Status Line: " + method.getStatusLine());
			Header[] responseHeaders = method.getResponseHeaders();
			for (int i = 0; i < responseHeaders.length; i++) {
				System.out.print(responseHeaders[i]);
			}

			//write out the response body
			System.out.println("*** Response Body ***");
			System.out.println(responseBody);
		}

		pageContents = responseBody;
		//clean up the connection resources
		method.releaseConnection();
		method.recycle();

		return pageContents;

	}
	/**
	 * Return just the file name without its parent directory path.
	 * 
	 * @param string
	 * @return
	 */
	public static String getUnqualifiedFileName(String fullyQualifiedPath) {
		int ndx1 = fullyQualifiedPath.lastIndexOf('/');
		int ndx2 = fullyQualifiedPath.lastIndexOf('\\');
		int index = ndx2 > ndx1 ? ndx2 : ndx1;

		if (index == -1) {
			return fullyQualifiedPath;
		}

		String name =
			fullyQualifiedPath.substring(
				index + 1,
				fullyQualifiedPath.length());
		return name;
	}
	/**
	 * Read the contents from the specified file name.
	 * 
	 * @param file
	 * @return byte[]
	 * @throws IOException
	 */
	public static byte[] readFile(File file) throws IOException {
		InputStream is = new FileInputStream(file);
		// Get the size of the file
		long length = file.length();

		if (length > Integer.MAX_VALUE) {
			// File is too large
		}

		// Create the byte array to hold the data
		byte[] bytes = new byte[(int) length];

		// Read in the bytes
		int offset = 0;
		int numRead = 0;
		while (offset < bytes.length
			&& (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
			offset += numRead;
		}

		// Ensure all the bytes have been read in
		if (offset < bytes.length) {
			throw new IOException(
				"Could not completely read file " + file.getName());
		}

		// Close the input stream and return bytes
		is.close();
		return bytes;
	}
	/**
	 */
	public static String replaceString(
		String srcString,
		String matchString,
		String replacementString) {
		String newString = srcString;
		int start = newString.indexOf(matchString);
		if (start > 0) {
			newString =
				srcString.substring(0, start)
					+ replacementString
					+ srcString.substring(start + matchString.length());

		}

		return newString;
	}
	/**
	 * Dump the specified bytes to the specified file name. Overwrite the
	 * existing file only if overwriteExisiting is true
	 * 
	 * @param string
	 * @param pictureBytes
	 */
	public static void writeFile(
		String targetFileName,
		byte[] content,
		boolean overwriteExisiting)
		throws Exception {
		File outFile = new File(targetFileName);
		if (!outFile.exists() || overwriteExisiting) {
			//System.out.println("Writing: [" + targetFileName + "]");
			FileOutputStream fos = new FileOutputStream(outFile);
			fos.write(content);
			fos.close();

		} else
			System.out.println(
				"File: [" + targetFileName + "] exists. Skipping.");

	}
}
