/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * DOCUMENT ME!
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyAPIC
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyAPIC object.
     */
    public FrameBodyAPIC() {
        //        this.setObject("Text Encoding", new Byte((byte) 0));
        //        this.setObject("MIME Type", "");
        //        this.setObject("Picture Type", new Byte((byte) 0));
        //        this.setObject("Description", "");
        //        this.setObject("Picture Data", new byte[0]);
    }

    /**
     * Creates a new FrameBodyAPIC object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param mimeType DOCUMENT ME!
     * @param pictureType DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param data DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyAPIC(byte textEncoding, String mimeType, byte pictureType,
                         String description, byte[] data, boolean is6ByteHeader) {
        this.setObject("Text Encoding",
                       new Byte(textEncoding));
        this.setObject("MIME Type", mimeType);
        this.setObject("Picture Type",
                       new Byte(pictureType));
        this.setObject("Description", description);
        this.setObject("Picture Data", data);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyAPIC object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyAPIC(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void setDescription(String description) {
        setObject("Description", description);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return (String) getObject("Description");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "APIC" + ((char) 0) + getDescription();
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap("Text Encoding", 1));
        objectList.add(new ObjectStringNullTerminated("MIME Type"));
        objectList.add(new ObjectNumberHashMap("Picture Type", 1));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectByteArraySizeTerminated("Picture Data"));
    }
}