/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * DOCUMENT ME!
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyAENC
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyAENC object.
     */
    public FrameBodyAENC() {
        //        this.setObject("Owner", "");
        //        this.setObject("Preview Start", new Short((short) 0));
        //        this.setObject("Preview Length", new Short((short) 0));
        //        this.setObject("Encryption Info", new byte[0]);
    }

    /**
     * Creates a new FrameBodyAENC object.
     *
     * @param owner DOCUMENT ME!
     * @param previewStart DOCUMENT ME!
     * @param previewLength DOCUMENT ME!
     * @param data DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyAENC(String owner, short previewStart, short previewLength,
                         byte[] data, boolean is6ByteHeader) {
        this.setObject("Owner", owner);
        this.setObject("Preview Start",
                       new Short(previewStart));
        this.setObject("Preview Length",
                       new Short(previewLength));
        this.setObject("Encryption Info", data);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyAENC object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyAENC(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "AENC" + ((char) 0) + getOwner();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner() {
        return (String) getObject("Owner");
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void getOwner(String description) {
        setObject("Owner", description);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectStringNullTerminated("Owner"));
        objectList.add(new ObjectNumberFixedLength("Preview Start", 2));
        objectList.add(new ObjectNumberFixedLength("Preview Length", 2));
        objectList.add(new ObjectByteArraySizeTerminated("Encryption Info"));
    }
}