/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.filename;

import java.util.Iterator;

import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.AbstractFrameBodyTextInformation;
import org.farng.mp3.id3.AbstractFrameBodyUrlLink;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.id3.ID3v2_4Frame;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author $author$
 * @version $Revision: 1.1 $
 */
public class FilenameToken
    extends FilenameComposite {
    /** DOCUMENT ME! */
    String token;

    /** DOCUMENT ME! */
    private Class id3v2FrameBodyClass = null;

    /**
     * Creates a new FilenameToken object.
     */
    public FilenameToken() {}

    /**
     * DOCUMENT ME!
     *
     * @param id3v2FrameBodyClass DOCUMENT ME!
     */
    public void setId3v2FrameBodyClass(Class id3v2FrameBodyClass) {
        this.id3v2FrameBodyClass = id3v2FrameBodyClass;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Class getId3v2FrameBodyClass() {
        return id3v2FrameBodyClass;
    }

    /**
     * DOCUMENT ME!
     *
     * @param token DOCUMENT ME!
     */
    public void setToken(String token) {
        this.token = token.trim();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getToken() {
        return token;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String composeFilename() {
        return token;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        return new FilenameTokenIterator(this);
    }

    /**
     * DOCUMENT ME!
     *
     * @param id3v2FrameBodyClass DOCUMENT ME!
     */
    public void matchAgainstKeyword(Class id3v2FrameBodyClass) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(id3v2FrameBodyClass)) {
            if (TagOptionSingleton.getInstance()
                    .isCompositeMatchOverwrite() ||
                    (this.id3v2FrameBodyClass == null)) {
                Iterator iterator = TagOptionSingleton.getInstance()
                                    .getKeywordListIterator(id3v2FrameBodyClass);

                while (iterator.hasNext()) {
                    String matchString = (String) iterator.next();

                    if (matchString.equals(token) ||
                            (matchString.indexOf(token) >= 0) ||
                            (token.indexOf(matchString) >= 0)) {
                        setId3v2FrameBodyClass(id3v2FrameBodyClass);

                        break;
                    }
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param matchTag DOCUMENT ME!
     */
    public void matchAgainstTag(AbstractMP3Tag matchTag) {
        if (TagOptionSingleton.getInstance()
                .isCompositeMatchOverwrite() || (id3v2FrameBodyClass == null)) {
            ID3v2_4 tag;

            if (matchTag instanceof ID3v2_4) {
                tag = (ID3v2_4) matchTag;
            } else {
                tag = new ID3v2_4(matchTag);
            }

            Iterator                         iterator    = tag.iterator();
            AbstractID3v2Frame               frame;
            AbstractID3v2FrameBody           body;
            AbstractFrameBodyTextInformation textBody;
            AbstractFrameBodyUrlLink         urlBody;
            String                           matchString = null;

            while (iterator.hasNext()) {
                frame = (ID3v2_4Frame) iterator.next();
                body  = (AbstractID3v2FrameBody) frame.getBody();

                /**
                 * @todo-javadoc add support for more tag matches. only doing
                 *       text information and URL links right now because i'm
                 *       lazy
                 */
                if (body instanceof AbstractFrameBodyTextInformation) {
                    matchString = ((AbstractFrameBodyTextInformation) body).getText();
                } else if (body instanceof AbstractFrameBodyUrlLink) {
                    matchString = ((AbstractFrameBodyUrlLink) body).getUrlLink();
                }

                if (matchString.equals(token) ||
                        (matchString.indexOf(token) >= 0) ||
                        (token.indexOf(matchString) >= 0)) {
                    setId3v2FrameBodyClass(body.getClass());

                    break;
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return id3v2FrameBodyClass + ": " + token;
    }
}