/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.filename;

import java.io.RandomAccessFile;
import java.util.Iterator;

import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_4;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author $author$
 * @version $Revision: 1.1 $
 */
public class FilenameTag
    extends AbstractMP3Tag {
    /** DOCUMENT ME! */
    FilenameComposite composite = null;

    /** DOCUMENT ME! */
    ID3v2_4 id3tag = null;

    /** DOCUMENT ME! */
    MP3File mp3file = null;

    /**
     * Creates a new FilenameTag object.
     */
    protected FilenameTag() {}

    /**
     * DOCUMENT ME!
     *
     * @param composite DOCUMENT ME!
     */
    public void setComposite(FilenameComposite composite) {
        this.composite = composite;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public FilenameComposite getComposite() {
        return composite;
    }

    /**
     * DOCUMENT ME!
     *
     * @param frame DOCUMENT ME!
     */
    public void setFrame(AbstractID3v2Frame frame) {
        if (id3tag != null) {
            id3tag.setFrame(frame);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param identifier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public AbstractID3v2Frame getFrame(String identifier) {
        if (id3tag != null) {
            return id3tag.getFrame(identifier);
        }

        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param id3tag DOCUMENT ME!
     */
    public void setId3tag(ID3v2_4 id3tag) {
        this.id3tag = id3tag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ID3v2_4 getId3tag() {
        return id3tag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "org.farng.mp3.filename.FilenameTag";
    }

    /**
     * DOCUMENT ME!
     *
     * @param mp3file DOCUMENT ME!
     */
    public void setMp3file(MP3File mp3file) {
        this.mp3file = mp3file;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public MP3File getMp3file() {
        return mp3file;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return composeFilename()
               .length();
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws org.farng.mp3.TagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void append(RandomAccessFile file)
                throws org.farng.mp3.TagException, java.io.IOException {
        /**
         * @todo Implement this org.farng.mp3.AbstractMP3Tag abstract method
         */
        throw new java.lang.UnsupportedOperationException("Method append() not yet implemented.");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String composeFilename() {
        if (composite != null) {
            return composite.composeFilename()
                   .trim();
        }

        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void delete(RandomAccessFile file)
                throws java.io.IOException {
        /**
         * @todo Implement this org.farng.mp3.AbstractMP3Tag abstract method
         */
        throw new java.lang.UnsupportedOperationException("Method delete() not yet implemented.");
    }

    /**
     * DOCUMENT ME!
     *
     * @param identifier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean hasFrame(String identifier) {
        if (id3tag != null) {
            return id3tag.hasFrame(identifier);
        }

        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        if (composite != null) {
            return composite.iterator();
        } else {
            return null;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws org.farng.mp3.TagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void overwrite(RandomAccessFile file)
                   throws org.farng.mp3.TagException, java.io.IOException {
        String filename = composeFilename();

        /**
         * @todo Implement this org.farng.mp3.AbstractMP3Tag abstract method
         */
        throw new java.lang.UnsupportedOperationException("Method overwrite() not yet implemented.");
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     * @throws org.farng.mp3.TagException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws java.io.IOException, org.farng.mp3.TagException {
        /**
         * @todo Implement this org.farng.mp3.AbstractMP3FileItem abstract
         *       method
         */
        throw new java.lang.UnsupportedOperationException("Method read() not yet implemented.");
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public boolean seek(RandomAccessFile file)
                 throws java.io.IOException {
        /**
         * @todo Implement this org.farng.mp3.AbstractMP3Tag abstract method
         */
        throw new java.lang.UnsupportedOperationException("Method seek() not yet implemented.");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String   string   = "";
        Iterator iterator = iterator();

        while (iterator.hasNext()) {
            string += (iterator.next()
                       .toString() + "\n");
        }

        return string;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws java.io.IOException {
        /**
         * @todo Implement this org.farng.mp3.AbstractMP3FileItem abstract
         *       method
         */
        throw new java.lang.UnsupportedOperationException("Method write() not yet implemented.");
    }
}