/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectNumberFixedLength;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyRVRB
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyRVRB object.
     */
    public FrameBodyRVRB() {
        //        this.setObject("Reverb Left", new Short((short) 0));
        //        this.setObject("Reverb Right", new Short((short) 0));
        //        this.setObject("Reverb Bounces Left", new Byte((byte) 0));
        //        this.setObject("Reverb Bounces Right", new Byte((byte) 0));
        //        this.setObject("Reverb Feedback Left To Left", new Byte((byte) 0));
        //        this.setObject("Reverb Feedback Left To Right", new Byte((byte) 0));
        //        this.setObject("Reverb Feedback Right To Right", new Byte((byte) 0));
        //        this.setObject("Reverb Feedback Right to Left", new Byte((byte) 0));
        //        this.setObject("Premix Left To Right", new Byte((byte) 0));
        //        this.setObject("Premix Right To Left", new Byte((byte) 0));
    }

    /**
     * Creates a new FrameBodyRVRB object.
     *
     * @param reverbLeft DOCUMENT ME!
     * @param reverbRight DOCUMENT ME!
     * @param reverbBouncesLeft DOCUMENT ME!
     * @param reverbBouncesRight DOCUMENT ME!
     * @param reverbFeedbackLeftToLeft DOCUMENT ME!
     * @param reverbFeedbackLeftToRight DOCUMENT ME!
     * @param reverbFeedbackRightToRight DOCUMENT ME!
     * @param reverbFeedbackRightToLeft DOCUMENT ME!
     * @param premixLeftToRight DOCUMENT ME!
     * @param premixRightToLeft DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyRVRB(short reverbLeft, short reverbRight,
                         byte reverbBouncesLeft, byte reverbBouncesRight,
                         byte reverbFeedbackLeftToLeft,
                         byte reverbFeedbackLeftToRight,
                         byte reverbFeedbackRightToRight,
                         byte reverbFeedbackRightToLeft,
                         byte premixLeftToRight, byte premixRightToLeft,
                         boolean is6ByteHeader) {
        this.setObject("Reverb Left",
                       new Short(reverbLeft));
        this.setObject("Reverb Right",
                       new Short(reverbRight));
        this.setObject("Reverb Bounces Left",
                       new Byte(reverbBouncesLeft));
        this.setObject("Reverb Bounces Right",
                       new Byte(reverbBouncesRight));
        this.setObject("Reverb Feedback Left To Left",
                       new Byte(reverbFeedbackLeftToLeft));
        this.setObject("Reverb Feedback Left To Right",
                       new Byte(reverbFeedbackLeftToRight));
        this.setObject("Reverb Feedback Right To Right",
                       new Byte(reverbFeedbackRightToRight));
        this.setObject("Reverb Feedback Right to Left",
                       new Byte(reverbFeedbackRightToLeft));
        this.setObject("Premix Left To Right",
                       new Byte(premixLeftToRight));
        this.setObject("Premix Right To Left",
                       new Byte(premixRightToLeft));
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyRVRB object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyRVRB(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "RVRB";
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberFixedLength("Reverb Left", 2));
        objectList.add(new ObjectNumberFixedLength("Reverb Right", 2));
        objectList.add(new ObjectNumberFixedLength("Reverb Bounces Left", 1));
        objectList.add(new ObjectNumberFixedLength("Reverb Bounces Right", 1));
        objectList.add(new ObjectNumberFixedLength("Reverb Feedback Left To Left",
                                                   1));
        objectList.add(new ObjectNumberFixedLength("Reverb Feedback Left To Right",
                                                   1));
        objectList.add(new ObjectNumberFixedLength("Reverb Feedback Right To Right",
                                                   1));
        objectList.add(new ObjectNumberFixedLength("Reverb Feedback Right to Left",
                                                   1));
        objectList.add(new ObjectNumberFixedLength("Premix Left To Right", 1));
        objectList.add(new ObjectNumberFixedLength("Premix Right To Left", 1));
    }
}