/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectGroupRepeated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectNumberHashMap;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyETCO
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyETCO object.
     */
    public FrameBodyETCO() {
        //        this.setObject("Time Stamp Format", new Long(0));
        //        this.addGroup((byte) 0, (int) 0);
    }

    /**
     * Creates a new FrameBodyETCO object.
     *
     * @param timeStampFormat DOCUMENT ME!
     * @param event DOCUMENT ME!
     * @param timeStamp DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyETCO(byte timeStampFormat, byte event, int timeStamp,
                         boolean is6ByteHeader) {
        this.setObject("Time Stamp Format",
                       new Long(timeStampFormat));
        this.addGroup(event, timeStamp);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyETCO object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyETCO(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "ETCO" + ((char) 0) + getOwner();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner() {
        return (String) getObject("Owner");
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void getOwner(String description) {
        setObject("Owner", description);
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     * @param timeStamp DOCUMENT ME!
     */
    public void addGroup(byte event, int timeStamp) {
        ObjectGroupRepeated group = (ObjectGroupRepeated) this.getObject("Data");
        AbstractMP3Object   ev = new ObjectNumberHashMap("Type Of Event", 1);
        AbstractMP3Object   ts = new ObjectNumberFixedLength("Time Stamp", 4);
        group.addObject(ev);
        group.addObject(ts);
        this.setObject("Data", group);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap("Time Stamp Format", 1));

        ObjectGroupRepeated group = new ObjectGroupRepeated("Data");
        group.addProperty(new ObjectNumberHashMap("Type Of Event", 1));
        group.addProperty(new ObjectNumberFixedLength("Time Stamp", 4));
        objectList.add(group);
    }
}