/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectStringSizeTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractFrameBodyUrlLink
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyUrlLink object.
     */
    public AbstractFrameBodyUrlLink() {
        //        setObject("URL Link", "");
    }

    /**
     * Creates a new FrameBodyUrlLink object.
     *
     * @param urlLink DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public AbstractFrameBodyUrlLink(String urlLink, boolean is6ByteHeader) {
        setObject("URL Link", urlLink);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyUrlLink object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public AbstractFrameBodyUrlLink(java.io.RandomAccessFile file,
                                    boolean is6ByteHeader)
                             throws java.io.IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getBriefDescription() {
        return this.getUrlLink();
    }

    /**
     * DOCUMENT ME!
     *
     * @param urlLink DOCUMENT ME!
     */
    public void setUrlLink(String urlLink) {
        setObject("URL Link", urlLink);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUrlLink() {
        return (String) getObject("URL Link");
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectStringSizeTerminated("URL Link"));
    }
}