/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

import org.farng.mp3.TagConstants;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectNumberHashMap
    extends ObjectNumberFixedLength
    implements ObjectHashMapInterface {
    /** DOCUMENT ME! */
    public static final String GENRE = "Genre";

    /** DOCUMENT ME! */
    public static final String TEXT_ENCODING = "Text Encoding";

    /** DOCUMENT ME! */
    public static final String INTERPOLATION_METHOD = "Interpolation Method";

    /** DOCUMENT ME! */
    public static final String ID3V2_FRAME_DESCRIPTION = "ID3v2 Frame Description";

    /** DOCUMENT ME! */
    public static final String PICTURE_TYPE = "Picture Type";

    /** DOCUMENT ME! */
    public static final String TYPE_OF_EVENT = "Type Of Event";

    /** DOCUMENT ME! */
    public static final String TIME_STAMP_FORMAT = "Time Stamp Format";

    /** DOCUMENT ME! */
    public static final String TYPE_OF_CHANNEL = "Type Of Channel";

    /** DOCUMENT ME! */
    public static final String RECIEVED_AS = "Recieved As";

    /** DOCUMENT ME! */
    private HashMap idToString = null;

    /** DOCUMENT ME! */
    private HashMap stringToId = null;

    /** DOCUMENT ME! */
    private boolean hasEmptyValue = false;

    /**
     * Creates a new ObjectNumberHashMap object.
     *
     * @param identifier DOCUMENT ME!
     * @param size DOCUMENT ME!
     */
    public ObjectNumberHashMap(String identifier, int size) {
        super(identifier, size);

        if (identifier.equals(ObjectNumberHashMap.GENRE)) {
            stringToId    = TagConstants.genreStringToId;
            idToString    = TagConstants.genreIdToString;
            hasEmptyValue = true;
        } else if (identifier.equals(ObjectNumberHashMap.TEXT_ENCODING)) {
            stringToId = TagConstants.textEncodingStringToId;
            idToString = TagConstants.textEncodingIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.INTERPOLATION_METHOD)) {
            stringToId = TagConstants.interpolationMethodStringToId;
            idToString = TagConstants.interpolationMethodIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.ID3V2_FRAME_DESCRIPTION)) {
            stringToId = TagConstants.id3v2_4FrameStringToId;
            idToString = TagConstants.id3v2_4FrameIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.PICTURE_TYPE)) {
            stringToId = TagConstants.pictureTypeStringToId;
            idToString = TagConstants.pictureTypeIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.TYPE_OF_EVENT)) {
            stringToId = TagConstants.typeOfEventStringToId;
            idToString = TagConstants.typeOfEventIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.TIME_STAMP_FORMAT)) {
            stringToId = TagConstants.timeStampFormatStringToId;
            idToString = TagConstants.timeStampFormatIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.TYPE_OF_CHANNEL)) {
            stringToId = TagConstants.typeOfChannelStringToId;
            idToString = TagConstants.typeOfChannelIdToString;
        } else if (identifier.equals(ObjectNumberHashMap.RECIEVED_AS)) {
            stringToId = TagConstants.recievedAsStringToId;
            idToString = TagConstants.recievedAsIdToString;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getIdToString() {
        return idToString;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getStringToId() {
        return stringToId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param value DOCUMENT ME!
     */
    public void setValue(Object value) {
        if (value instanceof Byte) {
            this.value = new Long(((Byte) value).byteValue());
        } else if (value instanceof Short) {
            this.value = new Long(((Short) value).shortValue());
        } else if (value instanceof Integer) {
            this.value = new Long(((Integer) value).intValue());
        } else {
            this.value = value;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectNumberHashMap) == false) {
            return false;
        }

        ObjectNumberHashMap object = (ObjectNumberHashMap) obj;

        if (this.hasEmptyValue != object.hasEmptyValue) {
            return false;
        }

        if (this.idToString.equals(object.idToString) == false) {
            return false;
        }

        if (this.stringToId.equals(object.stringToId) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        if (idToString == null) {
            return null;
        } else {
            // put them in a treeset first to sort them
            TreeSet treeSet = new TreeSet(idToString.values());

            if (hasEmptyValue) {
                treeSet.add("");
            }

            return treeSet.iterator();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        if (value == null) {
            return "";
        } else if (idToString.get(value) == null) {
            return "";
        } else {
            return idToString.get(value)
                   .toString();
        }
    }
}