/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;

import org.farng.mp3.AbstractMP3Fragment;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstants;
import org.farng.mp3.TagUtilities;


/**
 * Title:       ID3v2Frame Description: This abstract class is each frame
 * header inside a ID3v2 tag Copyright:   Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractID3v2Frame
    extends AbstractMP3Fragment {
    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        if (body == null) {
            return "";
        }

        return body.getIdentifier();
    }

    /**
     * DOCUMENT ME!
     *
     * @param identifier DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isValidID3v2FrameIdentifier(String identifier) {
        char    ch;
        boolean valid = true;

        for (int i = 0; i < identifier.length(); i++) {
            ch = identifier.charAt(i);

            if (((ch >= 'A') && (ch <= 'Z')) || ((ch >= '0') && (ch <= '9'))) {
                // nothing
            } else {
                valid = false;
            }
        }

        return valid;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        if (body == null) {
            return "";
        }

        return body.toString();
    }

    /**
     * DOCUMENT ME!
     *
     * @param identifier DOCUMENT ME!
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    protected AbstractID3v2FrameBody readBody(String identifier,
                                              RandomAccessFile file,
                                              boolean is6ByteHeader)
                                       throws IOException, InvalidTagException {
        String                 id   = "";
        AbstractID3v2FrameBody body = null;

        if (TagUtilities.isID3v2_2FrameIdentifier(identifier)) {
            id = (String) TagConstants.id3v2_2ToId3v2_4.get(identifier);
        } else {
            id = identifier;
        }

        if (id.equals("APIC")) {
            body = new FrameBodyAPIC(file, is6ByteHeader);
        } else if (id.equals("COMM")) {
            body = new FrameBodyCOMM(file, is6ByteHeader);
        } else if (id.equals("ENCR")) {
            body = new FrameBodyENCR(file, is6ByteHeader);
        } else if (id.equals("GEOB")) {
            body = new FrameBodyGEOB(file, is6ByteHeader);
        } else if (id.equals("GRID")) {
            body = new FrameBodyGRID(file, is6ByteHeader);
        } else if (id.equals("MCDI")) {
            body = new FrameBodyMCDI(file, is6ByteHeader);
        } else if (id.equals("PCNT")) {
            body = new FrameBodyPCNT(file, is6ByteHeader);
        } else if (id.equals("POPM")) {
            body = new FrameBodyPOPM(file, is6ByteHeader);
        } else if (id.equals("PRIV")) {
            body = new FrameBodyPRIV(file, is6ByteHeader);
        } else if (id.equals("RVAD")) {
            body = new FrameBodyRVAD(file, is6ByteHeader);
        } else if (id.equals("SYLT")) {
            body = new FrameBodySYLT(file, is6ByteHeader);
        } else if (id.equals("TALB")) {
            body = new FrameBodyTALB(file, is6ByteHeader);
        } else if (id.equals("TBPM")) {
            body = new FrameBodyTBPM(file, is6ByteHeader);
        } else if (id.equals("TCOM")) {
            body = new FrameBodyTCOM(file, is6ByteHeader);
        } else if (id.equals("TCON")) {
            body = new FrameBodyTCON(file, is6ByteHeader);
        } else if (id.equals("TCOP")) {
            body = new FrameBodyTCOP(file, is6ByteHeader);
        } else if (id.equals("TDAT")) {
            body = new FrameBodyTDAT(file, is6ByteHeader); // Deprecated
        } else if (id.equals("TDEN")) {
            body = new FrameBodyTDEN(file, is6ByteHeader);
        } else if (id.equals("TDLY")) {
            body = new FrameBodyTDLY(file, is6ByteHeader);
        } else if (id.equals("TDOR")) {
            body = new FrameBodyTDOR(file, is6ByteHeader);
        } else if (id.equals("TDRC")) {
            body = new FrameBodyTDRC(file, is6ByteHeader);
        } else if (id.equals("TDRL")) {
            body = new FrameBodyTDRL(file, is6ByteHeader);
        } else if (id.equals("TDTG")) {
            body = new FrameBodyTDTG(file, is6ByteHeader);
        } else if (id.equals("TENC")) {
            body = new FrameBodyTENC(file, is6ByteHeader);
        } else if (id.equals("TEXT")) {
            body = new FrameBodyTEXT(file, is6ByteHeader);
        } else if (id.equals("TFLT")) {
            body = new FrameBodyTFLT(file, is6ByteHeader);
        } else if (id.equals("TIME")) {
            body = new FrameBodyTIME(file, is6ByteHeader); // Deprecated
        } else if (id.equals("TIPL")) {
            body = new FrameBodyTIPL(file, is6ByteHeader);
        } else if (id.equals("TIT1")) {
            body = new FrameBodyTIT1(file, is6ByteHeader);
        } else if (id.equals("TIT2")) {
            body = new FrameBodyTIT2(file, is6ByteHeader);
        } else if (id.equals("TIT3")) {
            body = new FrameBodyTIT3(file, is6ByteHeader);
        } else if (id.equals("TKEY")) {
            body = new FrameBodyTKEY(file, is6ByteHeader);
        } else if (id.equals("TLAN")) {
            body = new FrameBodyTLAN(file, is6ByteHeader);
        } else if (id.equals("TLEN")) {
            body = new FrameBodyTLEN(file, is6ByteHeader);
        } else if (id.equals("TMCL")) {
            body = new FrameBodyTMCL(file, is6ByteHeader);
        } else if (id.equals("TMED")) {
            body = new FrameBodyTMED(file, is6ByteHeader);
        } else if (id.equals("TMOO")) {
            body = new FrameBodyTMOO(file, is6ByteHeader);
        } else if (id.equals("TOAL")) {
            body = new FrameBodyTOAL(file, is6ByteHeader);
        } else if (id.equals("TOFN")) {
            body = new FrameBodyTOFN(file, is6ByteHeader);
        } else if (id.equals("TOLY")) {
            body = new FrameBodyTOLY(file, is6ByteHeader);
        } else if (id.equals("TOPE")) {
            body = new FrameBodyTOPE(file, is6ByteHeader);
        } else if (id.equals("TORY")) {
            body = new FrameBodyTORY(file, is6ByteHeader); // Deprecated
        } else if (id.equals("TOWN")) {
            body = new FrameBodyTOWN(file, is6ByteHeader);
        } else if (id.equals("TPE1")) {
            body = new FrameBodyTPE1(file, is6ByteHeader);
        } else if (id.equals("TPE2")) {
            body = new FrameBodyTPE2(file, is6ByteHeader);
        } else if (id.equals("TPE3")) {
            body = new FrameBodyTPE3(file, is6ByteHeader);
        } else if (id.equals("TPE4")) {
            body = new FrameBodyTPE4(file, is6ByteHeader);
        } else if (id.equals("TPOS")) {
            body = new FrameBodyTPOS(file, is6ByteHeader);
        } else if (id.equals("TPRO")) {
            body = new FrameBodyTPRO(file, is6ByteHeader);
        } else if (id.equals("TPUB")) {
            body = new FrameBodyTPUB(file, is6ByteHeader);
        } else if (id.equals("TRCK")) {
            body = new FrameBodyTRCK(file, is6ByteHeader);
        } else if (id.equals("TRDA")) {
            body = new FrameBodyTRDA(file, is6ByteHeader); // Deprecated
        } else if (id.equals("TRSN")) {
            body = new FrameBodyTRSN(file, is6ByteHeader);
        } else if (id.equals("TRSO")) {
            body = new FrameBodyTRSO(file, is6ByteHeader);
        } else if (id.equals("TSIZ")) {
            body = new FrameBodyTSIZ(file, is6ByteHeader); // Deprecated
        } else if (id.equals("TSOA")) {
            body = new FrameBodyTSOA(file, is6ByteHeader);
        } else if (id.equals("TSOP")) {
            body = new FrameBodyTSOP(file, is6ByteHeader);
        } else if (id.equals("TSOT")) {
            body = new FrameBodyTSOT(file, is6ByteHeader);
        } else if (id.equals("TSRC")) {
            body = new FrameBodyTSRC(file, is6ByteHeader);
        } else if (id.equals("TSSE")) {
            body = new FrameBodyTSSE(file, is6ByteHeader);
        } else if (id.equals("TSST")) {
            body = new FrameBodyTSST(file, is6ByteHeader);
        } else if (id.equals("TXXX")) {
            body = new FrameBodyTXXX(file, is6ByteHeader);
        } else if (id.equals("TYER")) {
            body = new FrameBodyTYER(file, is6ByteHeader); // Deprecated
        } else if (id.equals("UFID")) {
            body = new FrameBodyUFID(file, is6ByteHeader);
        } else if (id.equals("USLT")) {
            body = new FrameBodyUSLT(file, is6ByteHeader);
        } else if (id.equals("WCOM")) {
            body = new FrameBodyWCOM(file, is6ByteHeader);
        } else if (id.equals("WCOP")) {
            body = new FrameBodyWCOP(file, is6ByteHeader);
        } else if (id.equals("WOAF")) {
            body = new FrameBodyWOAF(file, is6ByteHeader);
        } else if (id.equals("WOAR")) {
            body = new FrameBodyWOAR(file, is6ByteHeader);
        } else if (id.equals("WOAS")) {
            body = new FrameBodyWOAS(file, is6ByteHeader);
        } else if (id.equals("WORS")) {
            body = new FrameBodyWORS(file, is6ByteHeader);
        } else if (id.equals("WPAY")) {
            body = new FrameBodyWPAY(file, is6ByteHeader);
        } else if (id.equals("WPUB")) {
            body = new FrameBodyWPUB(file, is6ByteHeader);
        } else if (id.equals("WXXX")) {
            body = new FrameBodyWXXX(file, is6ByteHeader);
        } else {
            body = new FrameBodyUnsupported(file, is6ByteHeader);
        }

        return body;
    }
}