/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3;

/**
 * This class represents parts of tags. It contains methods that they all use
 * use. ID3v2 tags have frames. Lyrics3 tags have fields. ID3v1 tags do not
 * have parts. It also contains thier header while the body contains the
 * actual fragments.
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public abstract class AbstractMP3Fragment
    extends AbstractMP3FileItem {
    /** actual data this fragment holds */
    protected AbstractMP3FragmentBody body;

    /**
     * Sets the body object for this fragment. The body object contains the
     * actual information for the fragment.
     *
     * @param body the body object
     */
    public void setBody(AbstractMP3FragmentBody body) {
        this.body = body;
    }

    /**
     * Returns the body object for this fragment. The body object contains the
     * actual information for the fragment.
     *
     * @return the body object
     */
    public AbstractMP3FragmentBody getBody() {
        return this.body;
    }

    /**
     * Returns true if this object and it's body is a subset of the argument.
     * This object is a subset if the argument is the same class.
     *
     * @param obj object to determine if subset of
     *
     * @return true if this object and it's body is a subset of the argument.
     */
    public boolean isSubsetOf(Object obj) {
        if ((obj instanceof AbstractMP3Fragment) == false) {
            return false;
        }

        if (body.isSubsetOf(((AbstractMP3Fragment) obj).body) == false) {
            return false;
        }

        return super.isSubsetOf(obj);
    }

    /**
     * Returns true if this object and its body equals the argument and its
     * body. this object is equal if and only if they are the same class and
     * have the same <code>getIdentifier</code> id string.
     *
     * @param obj object to determine equality of
     *
     * @return true if this object and its body equals the argument and its
     *         body.
     */
    public boolean equals(Object obj) {
        String debug = this.getIdentifier();

        if ((obj instanceof AbstractMP3Fragment) == false) {
            return false;
        }

        AbstractMP3Fragment object = (AbstractMP3Fragment) obj;

        if (this.getIdentifier()
                .equals(object.getIdentifier()) == false) {
            return false;
        }

        if (this.body.equals(object.body) == false) {
            return false;
        }

        return super.equals(obj);
    }
}