{
 Unidad: XBE.PAS
 Autor: Yursoft
 Descripcion: Lee la estructura de un ejecutable de XBOX (XBE)
}

unit xbe;

interface

uses windows, classes, sysutils, dialogs;

const
 XBEH = 'XBEH';

type
{$A-}
 TCabecera = record
  XBEH: array[0..3] of char;
  FirmaDigital: array[0..255] of byte;
  dBaseXBE: DWORD;  // $10000 normalmente
  tCabeceras: DWORD;
  tImagen: DWORD;
  tCabeceraImagen: DWORD; //$178 normalmente
  FechaHora: DWORD;
  pDireccionCertificado: DWORD; // Puntero a la estructura de certificacion
  NumeroSecciones: DWORD;
  pSeccionCabeceras: DWORD;
  BanderasInicio: DWORD;
  pEntryPoint: DWORD; // XOReadas con PUBKEY[$80] y PUBKEY[$90]       
  pHiloDirectorio: DWORD; //Direccion al Hilo del Directorio de almacenamiento local
  tPila: DWORD; // Tamao Pila (Copia PE)
  tMonticuloReserva: DWORD; // Tamao Monticulo de Reserva (Copia PE)
  tMonticulo: DWORD; // Tamao Monticulo (Copia PE)
  pDirBaseOriginal: DWORD; // Puntero a direccion base original
  tImagenOriginal: DWORD; // (Copia PE)
  ChecksumOriginal: DWORD; // (Copia PE)
  FechaHoraOriginal: DWORD; // (Copia PE)
  pNombreRutaDebug: DWORD; //Puntero a un char
  pNombreFicheroDebug: DWORD;
  pUnicodeNombreFichero: DWORD;
  pImagenKernel: DWORD; // XOReada con PUBKEY[$84] y PUBKEY[$88]
  pNoImportarDirectorioKernel: DWORD;
  dNumeroVersionLibreria: DWORD;
  pVersionLibreria: DWORD;
  pVersionKernel: DWORD;
  pXAPI: DWORD;
  pLogoBMP: DWORD;
  tLogoBMP: DWORD;
 end;

 TCertificado = record
  tCertificado: DWORD;
  FechaHora: DWORD;
  IDTitulo: DWORD;
  NombreJuego: array[0..$50-1] of Char;
  IDsAlternativos: array[0..15] of DWORD;
  MediosPermitidos: DWORD;
  Regiones: DWORD;
  Calificacion: DWORD;
  NumeroDisco: DWORD;
  Version: DWORD;
  LANKey: array[0..15] of byte;
  SignatureKey: array[0..15] of byte;
  KeysAlternativos: array[0..15] of array[0..15] of byte;
 end;

 TXBE = record
  Cabecera: TCabecera;
  Certificado: TCertificado;
 end;
{$A+}

function LeerXBE(sXBE: string; var pXBE: TXBE): boolean;

implementation

//--- 4 Bytes a DWORD formato Motorola
function mByte2DWORD(b3,b2,b1,b0 : byte) : Dword;
begin
      result := ((LongInt(b3) shl 24) and $FF000000) or
                ((LongInt(b2) shl 16) and $00FF0000) or
                ((LongInt(b1) shl  8) and $0000FF00) or
                ((LongInt(b0)       ) and $000000FF);
end;

//--- 4 Bytes a DWORD formato Intel
function iByte2DWORD(b3,b2,b1,b0 : byte) : Dword;
begin
      result := ((LongInt(b0) shl 24) and $FF000000) or
                ((LongInt(b1) shl 16) and $00FF0000) or
                ((LongInt(b2) shl  8) and $0000FF00) or
                ((LongInt(b3)       ) and $000000FF);
end;


function LeerXBE(sXBE: string; var pXBE: TXBE): boolean;
var
   fXBE: TFilestream;
   PUBKEY1,PUBKEY2,PUBKEY3,PUBKEY4: DWORD;
   ParcheEntry,ParcheKernel: DWORD;
begin
        result := False;
        fXBE := TFilestream.Create(sXBE, fmOpenReadWrite);
        fXBE.Read(pXBE.Cabecera, sizeof(pXBE.Cabecera));
        fXBE.Seek(pXBE.Cabecera.pDireccionCertificado - pXBE.Cabecera.dBaseXBE,soBeginning);
        fXBE.Read(pXBE.Certificado,sizeof(pXBE.Certificado));

        //--- DWORDs extraidos de la clave publica RSA1
        PUBKEY1 := $1b103fe6; //$80
        PUBKEY2 := $8f95a2ad; //$90
        PUBKEY3 := $14a34fa8; //$84
        PUBKEY4 := $fb12befa; //$88

    {    PUBKEY1 := iByte2DWORD(xXBE.FirmaDigital[$80],
                    xXBE.FirmaDigital[$81],
                    xXBE.FirmaDigital[$82],
                    xXBE.FirmaDigital[$83]);

        PUBKEY2 := iByte2DWORD(xXBE.FirmaDigital[$90],
                    xXBE.FirmaDigital[$91],
                    xXBE.FirmaDigital[$92],
                    xXBE.FirmaDigital[$93]);  }

//        pXBE.pEntryPoint := pXBE.pEntryPoint xor 2491784523 xor 2835109803;//(xXBE.pEntryPoint xor 2491784523);// xor 2835109803;
//        pXBE.pImagenKernel := pXBE.pImagenKernel xor 4021416274 xor 1533886646;
//        pXBE.pEntryPoint := xXBE.pEntryPoint xor PUBKEY1 xor PUBKEY2;
//        pXBE.pImagenKernel := xXBE.pImagenKernel xor PUBKEY3 xor PUBKEY4;

 {       fXBE.Seek(296,soFromBeginning);
        fXBE.Write(pXBE.pEntryPoint,4);
        fXBE.Seek(344,soFromBeginning);
        fXBE.Write(pXBE.pImagenKernel,4);   }
        fXBE.Free;

        result := True;          
end;

end.
