// Main entry point for xbox dumper
// (c) 2001 Andrew de Quincey

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include "util.h"
#include "fatx.h"

// The partition details
u_int64_t partitionAddresses[] = { 0x80000,
                                   0x2ee80000,
                                   0x5dc80000,
                                   0x8ca80000,
                                   0xabe80000 };
u_int64_t partitionSizes[] = { 0x2ee80000,
                               0x2ee80000,
                               0x2ee80000,
                               0x1f400000,
                               0x131F00000 };

/**
 * Output syntax
 */
void syntax();


/**
 * Main entry point
 */
int main(int argc, char* argv[]) {
  int sourceFd;
  FATXPartition* partition;
  char* sourceFilename;
  char* extractFilename;
  char* outputFilename;
  int partitionId;
  int outputFd;
  int listFiles = 0;
  int extractFile = 0;
  
  
  // parse the arguments
  if (argc < 4) {
    syntax();
  }
  if (!strcmp(argv[1], "list")) {
    // extract details
    listFiles = 1;
    if ((!isdigit(argv[2][0])) || (strlen(argv[2]) != 1)) {
      syntax();
    }
    partitionId = atoi(argv[2]);
    sourceFilename = argv[3];
  } else if (!strcmp(argv[1], "dump")) {
    // ensure we still have enough args
    if (argc < 6) {
      syntax();
    }

    // extract config
    extractFile = 1;
    extractFilename = argv[2];
    outputFilename = argv[3];
    if ((!isdigit(argv[4][0])) || (strlen(argv[4]) != 1)) {
      syntax();
    }
    partitionId = atoi(argv[4]);
    sourceFilename = argv[5];
  } else {
    syntax();
  }

  // check partition id
  if ((partitionId < 0) || (partitionId > 4)) {
    syntax();
  }

  // open output file
  if (extractFile) {
    outputFd = open64(outputFilename, 
		      O_RDWR | O_TRUNC | O_CREAT);
    if (outputFd < 0) {
      error("Unable to open output file %s", outputFilename);
    }
  }
  
  // open the file
  if ((sourceFd = open64(sourceFilename, O_RDWR)) < 0) {
    error("Unable to open source file %s", sourceFilename);
  }

  // open the partition
  partition = openPartition(sourceFd,
                            partitionAddresses[partitionId],
                            partitionSizes[partitionId]);
  
  // dump the directory tree
  if (listFiles) {
    dumpTree(partition, fileno(stdout));
  }
  if (extractFile) {
    dumpFile(partition, extractFilename, outputFd);
  }
  
  // close output file
  if (extractFile) {
    close(outputFd);
  }
  
  // close the partition
  closePartition(partition);
  
  // close the file
  close(sourceFd);
}
  
/**
 * Output syntax
 */
void syntax() {
  error("Syntax: xboxdumper <list|dump <FATX filename> <output filename>> <partition ID (0|1|2|3|4)> <XBOX image file>");
}
