package kr.util.audio;


public class GainAudioClip extends AudioClip
{
	private AudioClip source;
	private float gain=1; //from 0 to 1
	private boolean onFlag = true;
	
	public GainAudioClip()
	{
	}
	
	public GainAudioClip(String name) {
		super.setName(name);
	}

	public String getName()
	{
		if(super.getName() == null)
			return source.getName();
		
		return super.getName();
	}
	
	@Override
	public int getNumChannels() {
		if(source == null) return 1;
		return source.getNumChannels();
	}
	@Override
	public int length() {
		if(source == null) return 0;
		return source.length();
	}
	
	@Override
	public int getRate() {
		if(source == null) return 0;
		return source.getRate();
	}
	@Override
	public byte byteAt(int index) {
		return onFlag && source != null? (byte)(source.byteAt(index) * gain) : 0;
	}
	@Override
	public void copyTo(int offset, int length, byte[] dest, int destOffset) {
		if(!onFlag || source == null)
		{
			for(int i = destOffset; i < length; i++)
			{
				dest[i] = 0;
			}
			return;
		}
		
		source.copyTo(offset, length, dest, destOffset);
		
		for(int i = destOffset; i < destOffset+length; i++)
		{
			dest[i] *= gain;
		}
		
	}
	public AudioClip getSource() {
		return source;
	}
	public void setSource(AudioClip source) {
		this.source = source;
	}
	public float getGain() {
		return gain;
	}
	public void setGain(float gain) {
		this.gain = gain;
	}
	public boolean isOnFlag() {
		return onFlag;
	}
	public void setOnFlag(boolean onFlag) {
		this.onFlag = onFlag;
	}
	

}
