package kr.miditunemodel;

import kr.miditunemodel.Event.Type;

public class MetrodomeEvent extends Event
{
	private long quarterNoteMicros;
	
	public MetrodomeEvent(long micros, long microsPerQuarterNote) {
		super(Event.Type.METRODOME, micros);	
		this.quarterNoteMicros = microsPerQuarterNote;
	} 
	
	public long getEndMicros()
	{
		if(getNext() != null)
			return ((Event) getNext()).getMicros();
		
		return -1;
	}

	public long getQuarterNoteMicros() {
		return quarterNoteMicros;
	}

	public void setQuarterNoteMicros(long quarterNoteMicros) {
		this.quarterNoteMicros = quarterNoteMicros;
	}

	@Override
	public Event clone() {
		return new MetrodomeEvent(micros, quarterNoteMicros);
	}
	
	
}
