package kr.miditunemodel;

import kr.miditunemodel.Event.Type;


public class KREvent extends Event
{
	private KREvent.Type krType;
	
	public enum Type 
	  { 
		BASS_OFF("bass_off"),
		BASS_ON("bass_on"),
		BRIDGE("bridge"),
		CHORUS("chorus"),
		CLAP_OFF("clap_off"),
		DJ_OFF("dj_off"),
		DJ_ON("dj_on"),
		DRUM_OFF("drum_off"),
		DRUM_ON("drum_on"),
		GTR_OFF("gtr_off"),
		GTR_ON("gtr_on"),
		GTR_SOLO_1("gtr_solo_1"),
		GTR_SOLO_2("gtr_solo_2"),
		GTR_SOLO_OFF("gtr_solo_off"),
		INTRO_END("intro_end"),
		KEYS_OFF("keys_off"),
		KEYS_ON("keys_on"),
		KEYS_SOLO_1("keys_solo_1"),
		KEYS_SOLO_OFF("keys_solo_off"),
		LONG_OFF("long_off"),
		LONG_ON("long_on"),
		SINGER_FINAL_POS("singer_final_pos"),
		SINGER_MIC_DOWN("singer_mic_down"),
		SINGER_MIC_UP("singer_mic_up"),
		SINGER_NO_CHANGES("singer_no_changes"),
		SONG_END("song_end"),
		TUT_ARROW_OFF("tut_arrow_off"),
		TUT_BOX_OFF("tut_box_off"),
		TUT_COMBO_BOX_ON("tut_combo_box_on"),
		TUT_CROWDMETER_BOOT("tut_crowdmeter_boot"),
		TUT_CROWDMETER_BOX_ON("tut_crowdmeter_box_on"),
		TUT_CROWDMETER_GREEN("tut_crowdmeter_green"),
		TUT_CROWDMETER_PEAK("tut_crowdmeter_peak"),
		TUT_CROWDMETER_RED("tut_crowdmeter_red"),
		TUT_CROWDMETER_YELLOW("tut_crowdmeter_yellow"),
		TUT_INTERACTIVE1_DEMO("tut_interactive1_demo"),
		TUT_INTERACTIVE1_START("tut_interactive1_start"),
		TUT_INTERACTIVE2_START("tut_interactive2_start"),
		TUT_LIMIT_RATING_BAD("tut_limit_rating_bad"),
		TUT_LIMIT_RATING_GOOD("tut_limit_rating_good"),
		TUT_LIMIT_RATING_GREAT("tut_limit_rating_great"),
		TUT_LIMIT_RATING_OK("tut_limit_rating_ok"),
		TUT_LYRICS_BOX_ON("tut_lyrics_box_on"),
		TUT_MSG_COMPLETE("tut_msg_complete"),
		TUT_MSG_GETREADY("tut_msg_getready"),
		TUT_MSG_GO("tut_msg_go"),
		TUT_MSG_LASTONE("tut_msg_lastone"),
		TUT_MSG_LISTENCLOSELY("tut_msg_listenclosely"),
		TUT_MSG_ONEMORE("tut_msg_onemore"),
		TUT_MSG_READY("tut_msg_ready"),
		TUT_MSG_WELCOME("tut_msg_welcome"),
		TUT_NOTETUBES_BOX_ON("tut_notetubes_box_on"),
		TUT_NOWBAR_ARROW_ON("tut_nowbar_arrow_on"),
		TUT_PHRASEMETER_BOX_ON("tut_phrasemeter_box_on"),
		TUT_PITCHARROW_BOX_ON("tut_pitcharrow_box_on"),
		TUT_SCORE_BOX_ON("tut_score_box_on"),
		TUT_STOP_MIC("tut_stop_mic"),
		VENUE_BONUS("venue_bonus"),
		VERSE("verse"),
		WIN_LOSE("win_lose")
		;
	  
	  	private String text;

		private Type(String text)
	  	{
	  		this.text = text;
	  	}

		public String getText() {
			return text;
		}

		public static kr.miditunemodel.KREvent.Type getTypeFromText(String text) {
			for(Type t : values())
			{
				if(t.getText().equals(text))
					return t;
			}
			
			return null;
		}
		};
	
	public KREvent(KREvent.Type krType, long micros)
	{
		super(Event.Type.KR_COMM, micros);
		this.krType = krType;
	}

	public KREvent.Type getKRType() {
		return krType;
	}

	public void setKRType(KREvent.Type krType) {
		this.krType = krType;
	}
	
	public long getEndMicros()
	{
		return getMicros()+1;
	}

	@Override
	public Event clone() {
		return new KREvent(krType, micros);
	}
	
	

}