package kr.miditunemodel;

import kr.gui.midigraph.NoteUI;
import kr.gui.midigraph.ScaleUI;
import kr.undo.Operation;

public class ChangeMetrodomeOperation extends MidiOperation<MetrodomeEvent> implements Operation
{
	private long quarterNoteMicrosDelta;
	private long microsDelta;

	public ChangeMetrodomeOperation(MetrodomeEvent ne)
	{
		super(ne);
	}
	
	public void setNewQuarterNoteMicros(long newMicrosPerQuarterNote)
	{
		this.quarterNoteMicrosDelta = newMicrosPerQuarterNote - event.getQuarterNoteMicros();
	}
	
	public void undo() 
	{
		event.setQuarterNoteMicros(event.getQuarterNoteMicros() - quarterNoteMicrosDelta);
		event.setMicros(event.getMicros() - microsDelta);
	}

	public void doIt() 
	{
		event.setQuarterNoteMicros(event.getQuarterNoteMicros() + quarterNoteMicrosDelta);
		event.setMicros(event.getMicros() + microsDelta);
	}

	public void setQuarterNoteMicrosDelta(long microsDelta) {
		this.quarterNoteMicrosDelta = microsDelta;
	}
	
	public void setNewMicros(long newMicros)
	{
		this.microsDelta = newMicros - event.getMicros();
	}

	public boolean isValid() {
		if(event.getQuarterNoteMicros() <= 1000 ||
				event.getMicros() < 0)
			return false;
		return true;
		
	}

	public void setMicrosDelta(long microsDelta) {
		this.microsDelta = microsDelta;
	}

	
}
