package kr.miditunemodel;

import kr.gui.midigraph.NoteUI;
import kr.gui.midigraph.ScaleUI;
import kr.undo.Operation;

public class ChangeKREventOperation extends MidiOperation<KREvent> implements Operation
{
	private long microsDelta;

	public ChangeKREventOperation(KREvent ne)
	{
		super(ne);
	}
	
	public void setNewMicros(long newMicros)
	{
		this.microsDelta = newMicros - event.getMicros();
	}
	
	public void undo() 
	{
		event.setMicros(event.getMicros() - microsDelta);
		event.setEndMicros(event.getEndMicros() - microsDelta);
	}

	public void doIt() 
	{
		event.setMicros(event.getMicros() + microsDelta);
		event.setEndMicros(event.getEndMicros() + microsDelta);
	}

	public void setMicrosDelta(long microsDelta) {
		this.microsDelta = microsDelta;
	}

	public boolean isValid() {
		if(event.getMicros() + microsDelta < 0)
			return false;
		return true;
		
	}

	
}
