package kr.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.event.MouseInputAdapter;

import kr.AudioChannelModel;
import kr.AudioModel;
import kr.gui.midigraph.MidiTuneGraph.MousePositionStatus;
import kr.gui.util.MouseInputUIMode;
import kr.gui.util.UIModeHandler;
import kr.util.Listener;
import kr.util.ListenerManager;

/**
 * Controls an AudioGraph
 */
public class AudioController extends TimeSyncedController implements Listener
{
	private GuiModel guiModel;
	private AudioGraph audioGraph;
	private AudioChannelModel audioChannelModel;
	private UIModeHandler uiModeHandler;

	public AudioController()
	{
	}
	
	public void init(GuiModel guiModel, AudioChannelModel audioChannelModel, AudioGraph audioGraph, AudioModel am)
	{
		this.guiModel = guiModel;
		this.audioGraph = audioGraph;
		this.audioChannelModel = audioChannelModel;
		uiModeHandler = new UIModeHandler(audioGraph);
		uiModeHandler.addMode(new NormalUIMode());
		super.init(guiModel, audioGraph);
		ListenerManager.inst().registerListener(guiModel, this);
		ListenerManager.inst().registerListener(audioChannelModel, this);
	}

	public AudioChannelModel getAudioChannelModel() {
		return audioChannelModel;
	}

	public void setAudioModel(AudioChannelModel audioChannelModel) {
		this.audioChannelModel = audioChannelModel;
	}

	public void notify(Object source, Object type, Object... values) {
		if(source == guiModel)
		{
			if(type == GuiModel.MessageType.SELECTION_UPDATED)
			{
				audioGraph.repaintScrollingData();
			}
		}
		else if(source == audioChannelModel)
		{
			audioGraph.repaintScrollingData();			
		}
//		//HACK
//		else if(source == am)
//		{
//			if(type == AudioModel.MessageType.VOCALS_CLIP_UPDATED)
//			{
//				audioChannelModel.setClip(guiModel.getMonoVocalsAudioClip());
//			}
//		}
//		//END HACK
	}
	
	/**
	 * Triggered when there is no or only a single note selected
	 */
	private class NormalUIMode extends MouseInputUIMode
	{
		public void mouseClicked(MouseEvent e)
		{
			
			if(e.getButton() != MouseEvent.BUTTON1)
				guiModel.setSelectionRight(audioGraph.pixelsToMicros(e.getX()));
			else
				guiModel.setSelectionLeft(audioGraph.pixelsToMicros(e.getX()));
				
		}
	}

	
}
