package kr.util.sample;

public class Utils {
	public static void performFFT(double[] re, double[]im) {
		int size = re.length;
	    double scale = Math.sqrt(1.0/(double)size);
	    int i,j;
	    double tempr,tempi;
	    for (i=j=0; i<size; ++i) {
	        if (j>=i) {
	            tempr = re[j]*scale;
	            tempi = im[j]*scale;
	            re[j] = re[i]*scale;
	            im[j] = im[i]*scale;
	            re[i] = tempr;
	            im[i] = tempi;
	        }
	        int m = size>>1;
	        while (m>=1 && j>=m) {
	            j -= m;
	            m>>=1;
	        }
	        j += m;
	    }

	    int imax = 1,istep = 2,m;
	    double w,wr,wi,tr,ti,delta;
	    while (imax<size) {
//	    	System.out.println("imax is "+imax+" size is "+size);
	        delta = Math.PI/imax;
	        for (m=0; m<imax; ++m) {
	            w = m*delta;
	            wr = Math.cos(w);
	            wi = Math.sin(w);
	            for (i=m; i<size; i+=istep) {
	                j = i+imax;
	                tr = wr*re[j]-wi*im[j];
	                ti = wr*im[j]+wi*re[j];
	                re[j] = re[i] - tr;
	                im[j] = im[i] - ti;
	                re[i] += tr;
	                im[i] += ti;
	            }
	        }
	        imax<<=1;
	        istep<<=1;
	    }
	}
	

}
